%% Replication of Figure 3 for "Monetary Policy, Bounded Rationality, and Incomplete Markets"
% by Emmanuel Farhi and Ivn Werning
% 
% Written and prepared by Mikel Petri
% Sunday June 23, 2019

T	= 17;	% Max horizon in the graph
K	= 4;	% Max K in the graph

%% Create and store simulations
param3			= param;

% Heterogeneous Agents
econ			= DynamicsInfUpstream(param3);
file_name		= './simulations/fig3/simul_sticky_T';
for t = 1:T
    if exist(fullfile(pwd, [file_name, num2str(t,'%02.0f'), '.mat']), 'file') == 0
        display([newline, 'Fig 3: Calculating HA response for shock at T=', num2str(t)]);
        econ.one_period_shock(t,1/1.01,t+20,K);
        save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param3');
    end
end

% Representative Agent
econ			= DynamicsInfUpstreamRA(param3);
file_name		= './simulations/fig3/simul_RA_sticky_T';
for t = 1:T
    if exist(fullfile(pwd, [file_name, num2str(t,'%02.0f'), '.mat']), 'file') == 0
        display([newline, 'Fig 3: Calculating RA response for shock at T=', num2str(t)]);
        econ.one_period_shock(t,1/1.000001,t+10,K+30);
        save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param3');
    end
end

%% Load and collect data from simulations
y1_HA = zeros(T,K);
y1_RA = zeros(T,K);
y1_RE = zeros(T,1);
pi_HA = zeros(T,K);
pi_RA = zeros(T,K);
pi_RE = zeros(T,1);

experiments = 1:T;

% HA
file_name		= './simulations/fig3/simul_sticky_T';
for t = 1:T
    load([file_name, num2str(t,'%02.0f'), '.mat'], 'econ');
    y1_HA(t,:)	= (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(t)-1);
	pi_HA(t,:)	= (econ.pt_realized(2,2:(K+1))-1)/(econ.R/econ.Rt(t)-1);
end

% RA
file_name		= './simulations/fig3/simul_RA_sticky_T';
for t = 1:T
    load([file_name, num2str(t,'%02.0f'), '.mat'], 'econ');
    y1_RA(t,:)	= (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(t)-1);
	y1_RE(t)	= (econ.Yt(1,end)/econ.Y-1)/(econ.R/econ.Rt(t)-1);
	pi_RA(t,:)	= (econ.pt_realized(2,2:(K+1))-1)/(econ.R/econ.Rt(t)-1);
	pi_RE(t)	= (econ.pt_realized(2,end)-1)/(econ.R/econ.Rt(t)-1);
end

%% Plot graph
figure('position',[.1 .1 1000 800]) %1400 800 if 2x3

% OUTPUT
subplot(2,1,1)
co = get(gca,'colororder');
semilogy(0:16,y1_RE,'-','Color', 'k','LineWidth',2);
set(gca, 'ColorOrderIndex', 1);
hold on;
marker = {'o', '^', 's', 'd'};
leg = cell(2*K+1, 1);
leg{1} = '$k=\infty$ (RE)';
for k=1:K
    semilogy(0:16, y1_RA(:,k), strcat('--', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
    set(gca, 'ColorOrderIndex', k);
    semilogy(0:16, y1_HA(:,k), strcat('- ', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
	leg(2*k:2*k+1) = {['RA $$k=', num2str(k), '$$'], ['HA $$k=', num2str(k), '$$']};
end

h = legend(leg(1:2*K+1),'Interpreter','Latex','Location','northwest','NumColumns',5);
h.AutoUpdate = 'off';
h.PlotChildren = h.PlotChildren([2:9, 1]);

ylim([0.5 10]);
xlim([0 16]);
yticks([0.5, 1, 5, 10])
ylabel('$\epsilon^k_{\tau}$ (log scale)', 'Interpreter','Latex', 'FontSize', 20)
xlabel('$\tau$', 'Interpreter','Latex', 'FontSize', 20)

set(gca, 'Color', 'none');
set(h, 'Color', 'w');
grid on
set(gca, 'XGrid', 'off')

% INFLATION
subplot(2,1,2)
plot(0:16,pi_RE,'-','Color', 'k','LineWidth',2);
set(gca, 'ColorOrderIndex', 1);
hold on;
for k=1:K
    plot(0:16, pi_RA(:,k), strcat('--', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
    set(gca, 'ColorOrderIndex', k);
    plot(0:16, pi_HA(:,k), strcat('- ', marker{k}), 'LineWidth', 2, 'MarkerSize', 6, 'MarkerFaceColor', co(k,:));
end

h = legend(leg(1:2*K+1),'Interpreter','Latex','Location','northwest','NumColumns',5);
h.AutoUpdate = 'off';
h.PlotChildren = h.PlotChildren([2:9, 1]);

ylim([0 2.5]);
xlim([0 16]);
ylabel('$\epsilon^{\Pi,k}_{\tau}$', 'Interpreter','Latex', 'FontSize', 20)
xlabel('$\tau$', 'Interpreter','Latex', 'FontSize', 20)

set(gca, 'Color', 'none');
set(h, 'Color', 'w');
grid on
set(gca, 'XGrid', 'off')

export_fig ('./figures/fig3.pdf', '-transparent');

clearvars -except param