%% Replication of Figure 2 for "Monetary Policy, Bounded Rationality, and Incomplete Markets"
% by Emmanuel Farhi and Iv�n Werning
% 
% Written and prepared by Mikel Petri
% Sunday June 23, 2019

horizons	= [1, 9, 17];	% Horizon for each panel (only 3 panels)
K			= 4;			% Max K in the graph

%% Create and store simulations
param4              = param;

rho				= 0.966;
std				= sqrt(0.017);
Nstate			= 21; 

param4			= calibrate_income_process(rho, std, Nstate, param4);
param4.ahigh	= param4.yh*20;
param4.a		= param4.a_NL.^param4.grid_NL*(param4.ahigh - param4.alow) + param4.alow;

liqs	= (exp(linspace(log(1),log(10),10))-1)/(10-1)*(0.09-0.01)+0.01;		% Small liquidity
liqs	= [liqs, (exp(linspace(log(1),log(10),15))-1)/(10-1)*(10-0.1)+0.1];	% High liquidity
liqs	= [liqs, 0.165, 0.230];		% Covering some more space

for j = 1:length(liqs)
    param4.delta	= liqs(j)*4*(param4.R-1); % capital share
    param4.gamma	= (2+1.44*4*(param4.R-1))/(1-1.44*4*(param4.R-1))*(1-param4.delta)-param4.delta; % Inverse Frisch to preserve RE response for different delta
    
    % HA
    file_name = ['./simulations/fig4/simul_L',num2str(liqs(j)*1000,'%05.0f'),'_sticky_T'];
    if exist(fullfile(pwd, [file_name, '01.mat']), 'file') == 0
        fprintf('\n\n====\nHA Liquidity level = %05.0f \n====\n', liqs(j)*1000);
        econ			= DynamicsInfUpstream(param4);
        econ.setfrac_consMC(1e6,300);
        for t=horizons
            if exist(fullfile(cd, [file_name, num2str(t), '.mat']), 'file') == 0
                display(['Calculating T=', num2str(t)]);
                econ.one_period_shock(t,1/1.001,t+20,K);
                save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param4');
            end
        end
    end
    
    % RA
    file_name = ['./simulations/fig4/simul_RA_L',num2str(liqs(j)*1000,'%05.0f'),'_sticky_T'];
    if exist(fullfile(pwd, [file_name, '01.mat']), 'file') == 0
        fprintf('\n\n====\nRA Liquidity level = %05.0f \n====\n', liqs(j)*1000);
        econ			= DynamicsInfUpstreamRA(param4);
        for t=horizons
            if exist(fullfile(cd, [file_name, num2str(t), '.mat']), 'file') == 0
                display(['Calculating T=', num2str(t)]);
                econ.one_period_shock(t,1/1.000001,t+30,K+30);
                save([file_name, num2str(t,'%02.0f'), '.mat'], 'econ', 'param4');
            end
        end
    end
end

%% Load and collect data from simulations

files = dir('./simulations/fig4/simul_L*_sticky_T01.mat')';

y1= zeros(length(files), K, 3);
yRE= zeros(length(files), 3);
bcfrac = zeros(length(files), 3);

for i_exp=1:length(horizons)
    for j_file=1:length(files)
        try
            load(['./simulations/fig4/', files(j_file).name(1:end-6), num2str(horizons(i_exp),'%02.0f'), '.mat'], 'econ');
            y1(j_file,:,i_exp) =  (econ.Yt(1,2:(K+1))/econ.Y-1)/(econ.R/econ.Rt(horizons(i_exp))-1);
            bcfrac(j_file,i_exp) = econ.frac_consMC*100;
			load(['./simulations/fig4/', files(j_file).name(1:6), 'RA_' files(j_file).name(7:end-6), num2str(horizons(i_exp),'%02.0f'), '.mat'], 'econ');
			yRE(j_file,i_exp) =  (econ.Yt(1,end)/econ.Y-1)/(econ.R/econ.Rt(horizons(i_exp))-1);
        catch
            y1(j_file,:,i_exp) = NaN;
            bcfrac(j_file,i_exp) = NaN;
			yRE(j_file,i_exp) = NaN;
        end
    end
end

bcfrac(bcfrac==-1) = 0;

%% Create plots
figure('position',[.1 .1 1400 350])
co = get(gca,'colororder');
marker = {'o', '^', 's', 'd'};

yRE(:,3) = yRE(:,3) - 57 + 16;

for i_exp=1:length(horizons)
    subplot(1,3,i_exp)
	semilogy([0; bcfrac(bcfrac(2:end,i_exp)>=0, 1)], yRE(bcfrac(:,i_exp)>=0,i_exp), 'k', 'LineWidth',2);
	set(gca, 'ColorOrderIndex', 1);
	hold on;
    for k=1:K
        semilogy(bcfrac(bcfrac(:,i_exp)>=0, 1), y1(bcfrac(:,i_exp)>=0,k,i_exp), marker{k}, 'MarkerFaceColor', co(k,:));
        ylim([0.05 18]);
        xlim([0 90]);
        hold on;
		grid on
		set(gca, 'XGrid', 'off')
    end
    set(gca,'Color','none');
    set(gca,'XTick',0:10:90)
	yticks([0.05, 0.1, 1, 4, 6, 10])
	
	h = legend({'$k=\infty$ (RE)','$$k=1$$','$$k=2$$','$$k=3$$','$$k=4$$'},'Location','southwest', 'interpreter', 'latex', 'NumColumns', 1);
	set(h, 'color', 'w');
	h.AutoUpdate = 'off';
	h.PlotChildren = h.PlotChildren([2:5, 1]);
	
    title(strcat('$\tau=',num2str(horizons(i_exp)-1),'$'), 'Interpreter','Latex', 'FontSize',20);
    ylabel('$\epsilon^k_{\tau}$ (log scale)', 'Interpreter','Latex', 'FontSize',20)
    xlabel('% of borrowing constrained', 'Interpreter','Latex')
    
    hold off;
end
yticks([0.05, 0.1, 1, 4, 6, 10, 16])
yticklabels({0.05, 0.1, 1, 4, 6, 10, 57});
annotation('line',[0.686-0.001 0.698857142857143+0.001], [0.839857142857143 0.847714285714286]);
annotation('line',[0.686-0.001 0.698857142857143+0.001], [0.829857142857143 0.837714285714286]);

export_fig ('./figures/fig4.pdf', '-transparent');

clearvars -except param
