classdef DynamicsReducedFormRA < SteadyStateReducedFormRA
    properties (GetAccess = public, SetAccess = private)
        Ct                  % Aggregate consumption
		Yt                  % Aggregate Output time t
        Rt                  % Nominal interest rate sequence
        At                  % Savings sequence
        qt                  % Asset price
        t_change            % Time of the experiment
    end
    
    methods

        function obj = DynamicsReducedFormRA(calibr)
            % Constructor. pass it a calibration structure containing
            % relevant parameters
            obj  = obj@SteadyStateReducedFormRA(calibr);            
            disp('Steady state found successfully');
            
        end
        
        function one_period_shock(obj, t_change, shock, T, K)
            K = K+1;
            % Relevant sequences to calculate equilibrium
            obj.Ct = ones(T,K)*obj.C;
            
            obj.Rt = obj.R*ones(T,1);
            obj.Rt(t_change) = obj.Rt(t_change)*shock;
            obj.t_change = t_change;
            
            obj.Yt = ones(T,K)*obj.Y;
            
            obj.At = ones(T,K)*obj.A;
                        
            obj.qt = ones(T,K)*obj.q;
                        
            for k = 2:K
%                 disp(['K=', num2str(k-1)]);
                for t=1:T-1                    
					cumR = cumprod(obj.Rt(t:end));
					obj.qt(t,k) = obj.delta*(obj.Yt(t+1:end,k-1)'*(1./cumR(1:end-1)) + obj.Y*obj.R/(cumR(end)*(obj.R-1)));
					cumBeta = cumprod(obj.beta*ones(length(obj.Rt(t:end)), 1));
					
					pv_y = (1-obj.delta)*(obj.Yt(t+1:end,k-1)'*(1./cumR(1:end-1)) + obj.Y*obj.R/(cumR(end)*(obj.R-1)));
					mpc = ((cumBeta(1:end-1)'.^(1/obj.sigma))*((1./cumR(1:end-1)).^(1-1/obj.sigma)) + cumBeta(end)^(1/obj.sigma)*(1/cumR(end)^(1-1/obj.sigma))/(1-obj.beta))^-1;
					obj.Ct(t,k) = mpc*(pv_y + obj.qt(t,k));
					
					obj.Yt(t,k) = obj.Ct(t,k);
					
					obj.At(t+1,k) = obj.qt(t,k)*obj.Rt(t);
                end
            end
        end
        
	end
end