/* ============================================================================================================
	Name of file: 	BCBSFL Project.do
	
	Author: 		Michael Richards - michael.r.richards@vanderbilt.edu
					Sebastian Tello - sebastian.tello@virginia.edu
					
	Project: 		BCBS
	
	Introduction:	
	Info: 	* Using analytic file generated on 7-25-16

	
	Files Used:		Raw data from FL Workforce		
				
	Files Created:  		
	
	============================================================================================================ */
	set more off 
	* ======================================================
					* Calling the directory.
	* ======================================================
	 di "Enter user name: michael,sebastian, tello"
	 di "Enter word: " _request(user)

	while ("$user" != "michael" & "$user" != "sebastian" & "$user" != "tello")  {

	display ">>>>Not an acceptable responde. Please Try again<<<<"
	di "Enter user name: michael,sebastian,tello"
	di "Enter word: " _request(user)

}

	else {

	if "$user" == "michael" {
	do "~/Dropbox/Vanderbilt/Research/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "sebastian" {
	do "C:/Users/Danie/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "tello" {
	do "D:/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	}
	


cd "$wkfrc" 

*// Creating a FLORIDA MAP 
	*// need to install:
	
	*ssc install maptile
	*ssc install spmap
	*maptile_install using "http://files.michaelstepner.com/geo_county2014.zip"
	
	

	use "$data\FL_enrollment_data\bcbs\bcbs_mrkt_share_2.dta", clear
	keep FIPSCode bcbs_prcnt_2012
	gen state=12
	rename FIPSCode county
	destring county, replace
	maptile bcbs_prcnt_2012, geo(county2014) mapif(state==12) fcolor(Greys) twopt(legend(pos(7)))
	graph export "$figures/BCBS/BCBS_Map_MktShare.emf" , replace
	graph export "$figures/BCBS/BCBS_Map_MktShare.pdf" , replace
	
	
clear
	
	
use workforce_cleaned, clear
sort year
tab year

* Merge countly market share info

tab counties1		
tab counties1, nolab

gen cnty_mrg = counties1			// NOTE: just merging to primary county location //

merge m:1 cnty_mrg using "$data/FL_enrollment_data/bcbs/bcbs_mrkt_share_2.dta" 

browse if _merge==2			// 1 blank obs //

drop if _merge==2
drop _merge

* Create Primary Psych Indicator (codes 400 - 409)

tab spec_prim			// NOTE: by far largest two gen pysch (400) and child psych (405) //

gen psy = (spec_prim==400 | spec_prim==405) if spec_prim <.		// combining gen psych with smaller kid psych b/c kid group is too small by itself //

drop if spec_prim==401 | spec_prim==402 | spec_prim==406 | spec_prim==407 | spec_prim==409		// removing tiny and irrelevant psych sub-specs //

tab year psy					 // 1000 plus each year from 2009 onwards //

* Create Indicator for High BCBS Market Share (in Jan 2012)

gen abv_med_bcbs = (quart_2012==3 | quart_2012==4) if quart_2012 <.		// to get larger sample sizes in the most exposed group, just Q4 likely too thin //


* Create Additional Outcome Measures

gen atleast_31 = timespent1 >= 7 if timespent1 <.
gen low_vol = (howmanypatients==1) if howmanypatients <.

*// Added by Sebastian
	egen num_counties=anycount( counties1 counties2 counties3 counties4 counties5 counties6), values(1/79)
	replace num_counties=. if num_counties==0
	label var num_counties "Number of Counties Provider Works at"
	
	gen bcbs_prcnt_2012_2 = bcbs_prcnt_2012/100

	
* Physician Counts Over Time (among those saying not retired)

forval i = 2009/2015 {
	di "General Pysch Count in YEAR `i'"
	count if psy==1 & retire==0 & year==`i'
	di "All Other Docs"
	count if psy==0 & retire==0 & year==`i'
	}

forval i = 2009/2015 {
	di "General Pysch Count in YEAR `i'"
	count if psy==1 & abv_med_bcbs==1 & retire==0 & year==`i'
	di "All Other Docs"
	count if psy==0 & abv_med_bcbs==1 & retire==0 & year==`i'
	}


								************************ // Descriptive Figures for Key Outcomes // ***********************
	
keep if year >=2009
tab year	
sort year

set scheme s1mono

* capture mkdir ~/Desktop/Figures

* Share of Psych Among Physician Markets

egen psy_byc = mean(psy) if (retire==0)		 			 , by(year cnty_mrg)
egen psy_hi_byc = mean(psy_byc) if abv_med_bcbs==1, by(year)
egen psy_lo_byc = mean(psy_byc) if abv_med_bcbs==0, by(year)

twoway (scatter psy_hi_byc psy_lo_byc year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.02(.01)0.08, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction of Physicians in Psychiatry") xtitle("Year") ///
legend(order(1 "All of Florida" 2 "High BCBSFL Share Areas" 3 "Low BCBSFL Share Areas")) ///
xline(2012, lpattern(dot)) text(0.07 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)


egen psy_fl = mean(psy) if (retire==0)		 			 , by(year)
egen psy_hi = mean(psy) if (retire==0 & abv_med_bcbs==1) , by(year)
egen psy_lo = mean(psy) if (retire==0 & abv_med_bcbs==0) , by(year)

twoway (scatter psy_fl psy_hi psy_lo year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.02(.01)0.08, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction of Physicians in Psychiatry") xtitle("Year") ///
legend(order(1 "All of Florida" 2 "High BCBSFL Share Areas" 3 "Low BCBSFL Share Areas")) ///
xline(2012, lpattern(dot)) text(0.07 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/psych_trends.emf" , replace


*//Sebastian
*Distribution of BCBS Mkt Share 
sum bcbs_prcnt_2012, det 
histogram bcbs_prcnt_2012  if (psy!=. & retire==0), bin(20) percent xtitle("BCBS Market Share") ytitle("Percent of Counties") ylabel(,angle(horizontal)) xline(`r(p50)', lpattern(dot)) graphregion(fcolor(white)) fcolor(dimgray) lcolor(gray) xlabel(#6)
graph export "$figures/BCBS/BCBS_MktShare.emf" , replace
graph export "$figures/BCBS/BCBS_MktShare.pdf" , replace
  




local outcomes retireish newmedicaid newmedicare mpg2 atleast_31 low_vol
*// Sebastian Changed this
foreach yvar of local outcomes {
	egen psy_`yvar' 	  = mean(`yvar') if (retire==0 & psy==1) 					 	 				 , by(year)
	egen psy_hi_`yvar'    = mean(`yvar') if (retire==0 & psy==1 & abv_med_bcbs==1) 					 	 , by(year)
	egen psy_low_`yvar'    = mean(`yvar') if (retire==0 & psy==1 & abv_med_bcbs==0)					 	 , by(year)
	egen oth_`yvar' 	  = mean(`yvar') if (retire==0 & psy==0)	 	 	 				 			 , by(year)
	egen oth_hi_`yvar'    = mean(`yvar') if (retire==0 & psy==0 & abv_med_bcbs==1)	 	 	 			 , by(year)
	egen oth_low_`yvar'    = mean(`yvar') if (retire==0 & psy==0 & abv_med_bcbs==0)	 	 	 			 , by(year)
	}


	****************************** // GRAPHS FOR MAIN OUTCOMES FOR ALL COUNTIES // **************************

* RETIRE IN 5 YRS

twoway (scatter psy_retireish oth_retireish year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.05)0.25, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Planning to Retire within 5 Yrs") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.23 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/retire_5yrs_all.emf" , replace

* MEDICAID

twoway (scatter psy_newmedicaid oth_newmedicaid year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.2(.1)0.7, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS//medicaid_all.emf" , replace

	reg psy_newmedicaid year
	predict psy_newmedicaid_res, res
	reg oth_newmedicaid year 
	predict oth_newmedicaid_res, res
	* MEDICAID with no Linear Trend = Things looks pretty similar
	twoway (scatter psy_newmedicaid_res oth_newmedicaid_res year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
	ylabel(-0.2(.05)0.2, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
	legend(order(1 "General Psych" 2 "All Other Specs")) ///
	xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
	xsize(5.0) ysize(3.0) scale(1.0)
	drop psy_newmedicaid_res oth_newmedicaid_res

* MEDICARE

twoway (scatter psy_newmedicare oth_newmedicare year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.4(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicare Pts") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.87 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/medicare_all.emf" , replace

* HOSPITAL PRACTICE

twoway (scatter psy_mpg2 oth_mpg2 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.1)0.4, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Working for a Hospital") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.35 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/hospital_wrk_all.emf" , replace


* HIGH PATIENT CARE HOURS

twoway (scatter psy_atleast_31 oth_atleast_31 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.5(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction with High Patient Care Hours Per Week") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.85 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/pt_care_hrs_all.emf" , replace

* LOW VOLUME PRACTICE

twoway (scatter psy_low_vol oth_low_vol year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.05(.1)0.3, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Operating Low Volume Practice") xtitle("Year") ///
legend(order(1 "General Psych" 2 "All Other Specs")) ///
xline(2012, lpattern(dot)) text(0.25 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/low_volume_prac_all.emf" , replace

			****************************** // GRAPHS FOR MAIN OUTCOMES ONLY USING HIGH BCBS  // **************************
								
* Retireish
twoway (scatter psy_hi_retireish oth_hi_retireish year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.05)0.35, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Planning to Retire within 5 Yrs") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.33 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_retireish.emf" , replace

* Medicaid
twoway (scatter psy_hi_newmedicaid oth_hi_newmedicaid year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.2(.1)0.7, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_mcaid.emf" , replace

	*## Medicaid withou linear trend
		reg psy_hi_newmedicaid year 
		predict psy_hi_newmedicaid_res, res
		reg oth_hi_newmedicaid year 
		predict oth_hi_newmedicaid_res, res

		twoway (scatter psy_hi_newmedicaid_res oth_hi_newmedicaid_res year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
		ylabel(-0.2(.05)0.2, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
		legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
		xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
		xsize(5.0) ysize(3.0) scale(1.0)

		drop psy_hi_newmedicaid_res oth_hi_newmedicaid_res


* Medicare
twoway (scatter psy_hi_newmedicare oth_hi_newmedicare year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.4(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicare Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.87 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_mcare.emf" , replace

* Hospital
twoway (scatter psy_hi_mpg2 oth_hi_mpg2 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.1)0.4, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Working for a Hospital") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.35 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_hosp.emf" , replace

* High Patient Care
twoway (scatter psy_hi_atleast_31 oth_hi_atleast_31 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.5(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction with High Patient Care Hours Per Week") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.85 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_ptcare.emf" , replace

* Low Volume								
twoway (scatter psy_hi_low_vol oth_hi_low_vol year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.05(.1)0.3, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Operating Low Volume Practice") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS")) ///
xline(2012, lpattern(dot)) text(0.25 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/highonly_volume.emf" , replace

			****************************** // GRAPHS FOR MAIN OUTCOMES ONLY USING LOW BCBS  // **************************
								
* Retireish
twoway (scatter psy_low_retireish oth_low_retireish year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.05)0.35, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Planning to Retire within 5 Yrs") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.33 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_retireish.emf" , replace

* Medicaid
twoway (scatter psy_low_newmedicaid oth_low_newmedicaid year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.2(.1)0.7, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_mcaid.emf" , replace

* Medicare
twoway (scatter psy_low_newmedicare oth_low_newmedicare year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.4(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicare Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.87 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_mcare.emf" , replace

* Hospital
twoway (scatter psy_low_mpg2 oth_low_mpg2 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.1(.1)0.4, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Working for a Hospital") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.35 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_hosp.emf" , replace

* High Patient Care
twoway (scatter psy_low_atleast_31 oth_low_atleast_31 year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.5(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction with High Patient Care Hours Per Week") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.85 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_ptcare.emf" , replace

* Low Volume								
twoway (scatter psy_low_low_vol oth_low_low_vol year , msymbol(D T O) msize(*2.0 *2.0 *2.0) connect(l l l) lwidth(*1.75 *1.75 *1.75)) , ///
ylabel(0.05(.1)0.3, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Operating Low Volume Practice") xtitle("Year") ///
legend(order(1 "Gen Psych - Low BCBS" 2 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.25 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/lowonly_volume.emf" , replace



****************************** // GRAPHS FOR MAIN OUTCOMES CONTRASTING HIGH & LOW BCBS COUNTIES // **************************
* Retireish
twoway (scatter psy_hi_retireish oth_hi_retireish psy_low_retireish oth_low_retireish year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.1(.05)0.35, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Planning to Retire within 5 Yrs") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.33 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_retireish.emf" , replace

* Medicaid
twoway (scatter psy_hi_newmedicaid oth_hi_newmedicaid psy_low_newmedicaid oth_low_newmedicaid year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.2(.1)0.7, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_mcaid.emf" , replace

	* ### Medicaid without Linear Trends DDD graph
	foreach var of varlist psy_hi_newmedicaid oth_hi_newmedicaid psy_low_newmedicaid oth_low_newmedicaid {
	reg `var' year
	predict `var'_res, res
	}
	twoway (scatter psy_hi_newmedicaid_res oth_hi_newmedicaid_res psy_low_newmedicaid_res oth_low_newmedicaid_res year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
	ylabel(-0.2(.05)0.2, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicaid Pts") xtitle("Year") ///
	legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
	xline(2012, lpattern(dot)) text(0.67 2012 "BCBS Carve-Out", place(nw)) ///
	xsize(5.0) ysize(3.0) scale(1.0)
	foreach var of varlist psy_hi_newmedicaid oth_hi_newmedicaid psy_low_newmedicaid oth_low_newmedicaid {
	drop `var'_res
	}
	
	graph export "$figures/BCBS/high_low_only_mcaidNoTrend.pdf" , replace


* Medicare
twoway (scatter psy_hi_newmedicare oth_hi_newmedicare psy_low_newmedicare oth_low_newmedicare year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.4(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Accepting New Medicare Pts") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.87 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_mcare.emf" , replace

* Hospital
twoway (scatter psy_hi_mpg2 oth_hi_mpg2 psy_low_mpg2 oth_low_mpg2 year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.1(.1)0.4, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Working for a Hospital") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.35 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_hosp.emf" , replace

* High Patient Care
twoway (scatter psy_hi_atleast_31 oth_hi_atleast_31 psy_low_atleast_31 oth_low_atleast_31 year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.5(.1)0.9, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction with High Patient Care Hours Per Week") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.85 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_ptcare.emf" , replace

* Low Volume								
twoway (scatter psy_hi_low_vol oth_hi_low_vol psy_low_low_vol oth_low_low_vol year , msymbol(D D O O) msize(*2.0 *2.0 *2.0 *2.0) connect(l l l l) lwidth(*1.75 *1.75 *1.75 *1.75)), ///
ylabel(0.05(.1)0.3, angle(horizontal)) xlabel(2009(1)2015) ytitle("Fraction Operating Low Volume Practice") xtitle("Year") ///
legend(order(1 "Gen Psych - High BCBS" 2 "All Other - High BCBS" 3 "Gen Psych - Low BCBS" 4 "All Other - Low BCBS")) ///
xline(2012, lpattern(dot)) text(0.25 2012 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export "$figures/BCBS/high_low_only_volume.emf" , replace
 

								******************************* // DD and DDD Regressions // ********************************
								
gen sample = (psy==1 | psy==0)
gen post = (year >=2012)

estimates clear
eststo: reg psy i.post##i.abv_med_bcbs 				   if (sample==1 & retire==0) , cluster(uniqueid)
eststo: reg psy i.post##i.abv_med_bcbs i.agegrp1 i.sex if (sample==1 & retire==0) , cluster(uniqueid)
esttab est*, keep(1.post 1.abv_med_bcbs 1.post#1.abv_med_bcbs ) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 




*// Sebastian
estimates clear
eststo: reg psy i.post##c.bcbs_prcnt_2012_2 				   	if (sample==1 & retire==0) , cluster(uniqueid)
eststo: reg psy i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0) , cluster(uniqueid)
eststo: reg workinfl i.psy##i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0) , cluster(uniqueid)
esttab est*, keep(1.post#c.bcbs_prcnt_2012_2 1.psy#1.post#c.bcbs_prcnt_2012_2) label se star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  
	
								
								
local outcomes retireish mpg2 newmedicaid newmedicare  atleast_31 low_vol age sex
foreach y of local outcomes {
	display "THIS IS OUTCOME `y' for GENERAL PSYCH"
	estimates clear
	eststo: reg `y' i.psy##i.post 								  if (sample==1 & retire==0) , cluster(uniqueid)
	eststo: reg `y' i.psy##i.post##i.abv_med_bcbs 				  if (sample==1 & retire==0) , cluster(uniqueid)
	 eststo: reg `y' i.psy##i.post##i.abv_med_bcbs i.agegrp1 i.sex if (sample==1 & retire==0) , cluster(uniqueid)
	esttab est*, keep(1.psy 1.post 1.psy#1.post 1.psy#1.post#1.abv_med_bcbs) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	}

*// Sebastian
	capture erase "$tables/BCBS/regressionstablesDDD.tex"
	local outcomes  newmedicaid newmedicare  atleast_31 low_vol retireish movein5yrs mpg2  num_counties	
	label var newmedicaid "Accepting New Medicaid Patients"
	label var newmedicare "Accepting New Medicare Patients" 
	label var atleast_31 "At Least 31 hours with Patient"
	label var low_vol "At most 25 Patients"
	label var retireish "Plan to Retire in 5 years"
	label var movein5yrs "Plan to Leave FL within 5 years"
	label var mpg2 "Main Work Location is Hospital"
	
	foreach y of local outcomes {
		local lbl: var label `y' 
		estimates clear 
		qui eststo: reg `y' i.psy##i.post		  	   	   					    if (sample==1 & retire==0) , cluster(uniqueid)
		qui eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 					if (sample==1 & retire==0) , cluster(uniqueid)
		qui eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0) , cluster(uniqueid)
		esttab est* , keep(1.psy 1.post 1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust )
		esttab est* using "$tables/BCBS/regressionstablesDDD.tex", append keep(1.psy 1.post 1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) title("Effects of BCBSFL Network and Pricing Shock on `lbl' ")			
		gen 	y = _b[1.psy#1.post#c.bcbs_prcnt_2012_2]*bcbs_prcnt_2012_2
		sum 	bcbs_prcnt_2012_2, det 
		local 	medianeffect = _b[1.psy#1.post#c.bcbs_prcnt_2012_2]*r(p50)
		local 	textposition = `medianeffect' + 0.0005
		if ("`y'"!="low_vol" & "`y'"!="num_counties"  | "`y'"!="movein5yrs")  {
		histogram y, percent  bin(20)  fcolor(dimgray) lcolor(gray) xlabel(#6) xline(`medianeffect', lpattern(dot) extend) ///
		title(Effect on the Pr(`lbl')) subtitle(Distribution of Estimates)  ///
		graphregion(fcolor(white)) ylabel(,  angle(horizontal)  ) ytitle(" ") xtitle(" ") ///
		text(25 `medianeffect' "Median BCBS Marktet Share", place(ne))
		}
		if ("`y'"=="low_vol" | "`y'"=="num_counties" | "`y'"=="movein5yrs")  {
		histogram y, percent  bin(20)  fcolor(dimgray) lcolor(gray) xlabel(#6) xline(`medianeffect', lpattern(dot) extend) ///
		title(Effect on the Pr(`lbl')) subtitle(Distribution of Estimates)  ///
		graphregion(fcolor(white)) ylabel(,  angle(horizontal)  ) ytitle(" ") xtitle(" ") ///
		text(25 `medianeffect' "Median BCBS Marktet Share", place(nw))
		}
		graph export "$figures/BCBS/Robustness/CMktShareEffect_`y'.emf" , replace
		graph export "$figures/BCBS/Robustness/CMktShareEffect_`y'.pdf" , replace
		drop y
		}
		
		
	*==Table 6 : Accepting New Medicaid Patients depending on where you work
		estimates clear 
		eststo: reg newmedicaid i.psy##i.post##i.abv_med_bcbs 		if (sample==1 & retire==0 & mpg2==1) , cluster(uniqueid)
		eststo: reg newmedicaid i.psy##i.post##c.bcbs_prcnt_2012_2 	if (sample==1 & retire==0 & mpg2==1) , cluster(uniqueid)
		
		eststo: reg newmedicaid i.psy##i.post##i.abv_med_bcbs 		if (sample==1 & retire==0 & mpg2==0) , cluster(uniqueid)		
		eststo: reg newmedicaid i.psy##i.post##c.bcbs_prcnt_2012_2 	if (sample==1 & retire==0 & mpg2==0) , cluster(uniqueid)
		esttab est*, keep(1.psy#1.post#1.abv_med_bcbs 1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
		
		*==Table X7: Accepting New Medicare Patients depending on where you work
		estimates clear 
		eststo: reg newmedicare i.psy##i.post##i.abv_med_bcbs		if (sample==1 & retire==0 & mpg2==1) , cluster(uniqueid)
		eststo: reg newmedicare i.psy##i.post##c.bcbs_prcnt_2012_2 	if (sample==1 & retire==0 & mpg2==1) , cluster(uniqueid)
		
		eststo: reg newmedicare i.psy##i.post##i.abv_med_bcbs		if (sample==1 & retire==0 & mpg2==0) , cluster(uniqueid)		
		eststo: reg newmedicare i.psy##i.post##c.bcbs_prcnt_2012_2 	if (sample==1 & retire==0 & mpg2==0) , cluster(uniqueid)
		esttab est*, keep(1.psy#1.post#1.abv_med_bcbs 1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	
	

	
								***************************** // Explore Role of Compositional Changes // **************************
			
						
										// Restrict to New Market Entrants //
										// these are not new-to-florida, but new to the county in FL. 
sort uniqueid counties1 year

by uniqueid counties1: gen obsnum = _n if counties1 <.
tab obsnum

*//Sebastian
by uniqueid: gen obsnum2 = _n 
tab obsnum2
replace obsnum2=. if counties1==. 
gen new_entrantFL = (obsnum2==1)			

gen new_entrant = (obsnum==1)
tab year new_entrant		
tab year new_entrant if abv_med_bcbs==1
tab year new_entrant if abv_med_bcbs==1 & psy==1
tab year new_entrant if abv_med_bcbs==1 & psy==0

tab year new_entrant if abv_med_bcbs==0 & psy==1

preserve

keep if new_entrant==1
	
local yvar newmedicaid newmedicare atleast_31 low_vol mpg2

foreach y of local yvar {
	estimates clear
	eststo: reg `y' i.psy##i.post 				  if (sample==1 & abv_med_bcbs==1 & retire==0) , cluster(uniqueid)
	eststo: reg `y' i.psy##i.post i.agegrp1 i.sex if (sample==1 & abv_med_bcbs==1 & retire==0) , cluster(uniqueid)
	esttab est*, keep(1.psy#1.post) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	}

*//Sebastian 	- Regs to Calculate the % of the DD that's coming from New-Entrants vs Non-New Entrants

	local yvar newmedicaid newmedicare atleast_31 low_vol mpg2 abv_med_bcbs
	foreach y of local yvar {
			estimates clear 
			eststo: reg `y' i.psy##i.post 				  						if (sample==1 & retire==0) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post i.agegrp1 i.sex 						if (sample==1 & retire==0) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 					if (sample==1 & retire==0) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0) , cluster(uniqueid)
			esttab est*, keep(1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label se star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust )	
			}
	
	local yvar newmedicaid newmedicare atleast_31 low_vol mpg2 abv_med_bcbs
	foreach y of local yvar {
			estimates clear 
			eststo: reg `y' i.psy##i.post 				  						if (sample==1 & retire==0 & new_entrantFL==1) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post i.agegrp1 i.sex 						if (sample==1 & retire==0 & new_entrantFL==1) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 					if (sample==1 & retire==0 & new_entrantFL==1) , cluster(uniqueid)
			eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0 & new_entrantFL==1) , cluster(uniqueid)
			esttab est*, keep(1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label se star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 	
			}
			
			

*// Sebastian = Are new market entrants going to Low rather than High BCBS			
	
restore													
								
										// Exclude New Market Entrants //

										
preserve

keep if obsnum >=2 & obsnum <=4

local yvar newmedicaid newmedicare atleast_31 low_vol mpg2
foreach y of local yvar {
	estimates clear
	eststo: reg `y' i.psy##i.post 				  if (sample==1 & abv_med_bcbs==1 & retire==0) , cluster(uniqueid)
	eststo: reg `y' i.psy##i.post i.agegrp1 i.sex if (sample==1 & abv_med_bcbs==1 & retire==0) , cluster(uniqueid)
	esttab est*, keep(1.psy#1.post) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	}

*//Sebastian 
local yvar newmedicaid newmedicare atleast_31 low_vol mpg2
foreach y of local yvar {
		estimates clear 
		eststo: reg `y' i.psy##i.post 				  						if (sample==1 & retire==0) , cluster(uniqueid)
		eststo: reg `y' i.psy##i.post i.agegrp1 i.sex 						if (sample==1 & retire==0) , cluster(uniqueid)
		eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 					if (sample==1 & retire==0) , cluster(uniqueid)
		eststo: reg `y' i.psy##i.post##c.bcbs_prcnt_2012_2 i.agegrp1 i.sex 	if (sample==1 & retire==0) , cluster(uniqueid)
		esttab est*, keep(1.psy#1.post 1.psy#1.post#c.bcbs_prcnt_2012_2) label se star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  	
	}

restore		

*// Sebastian - Remaking of Table of High BCBS Mkt Entrants 

local yvar newmedicaid newmedicare atleast_31 low_vol mpg2

foreach y of local yvar {
	estimates clear
	qui eststo: reg `y' i.psy##i.post 				  if (sample==1 & abv_med_bcbs==1 & retire==0 & new_entrant==1) , cluster(uniqueid)
	qui eststo: reg `y' i.psy##i.post 				  if (sample==1 & abv_med_bcbs==1 & retire==0 & obsnum >=2 & obsnum <=4) , cluster(uniqueid)
	qui eststo: reg `y' i.psy##i.post i.agegrp1 i.sex if (sample==1 & abv_med_bcbs==1 & retire==0 & new_entrant==1) , cluster(uniqueid)
	esttab est*, keep(1.psy#1.post) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	}

	
											

										// Focus on a Persistently Present in High BCBS Market Sample //

bys uniqueid: egen tot_hi = total(abv_med_bcbs)
bys uniqueid: gen obstot  = _N
gen ratio_hi = tot_hi / obstot
sum ratio_hi, d

drop if retire==1						// remove data rows for individuals entering or already in retirement //

count if ratio_hi==1
tab obstot if ratio_hi==1

xtset uniqueid year

by uniqueid: gen exit_hi = (abv_med_bcbs==0 & abv_med_bcbs[_n-1]==1) if abv_med_bcbs <.

local yvar newmedicaid newmedicare atleast_31 low_vol

foreach y of local yvar {
	estimates clear 
	eststo: xtreg `y' i.psy##i.post			  if (sample==1 & ratio_hi==1 & obstot >=3) , fe cluster(uniqueid)
	eststo:	xtreg `y' i.psy##i.post age 	  if (sample==1 & ratio_hi==1 & obstot >=3) , fe cluster(uniqueid)
	esttab est*, keep(1.psy#1.post) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 
	}

										// Model Exit from High BCBS Markets //
	
xtreg exit_hi i.psy##i.post     if (sample==1 & obstot >=3) , fe cluster(uniqueid)
xtreg exit_hi i.psy##i.post age if (sample==1 & obstot >=3) , fe cluster(uniqueid)

*// Sebastian 
	* Table X
	local yvar newmedicaid newmedicare exit_hi
	estimates clear
	foreach y of local yvar {
		if "`y'"=="exit_hi" {
		eststo: xtreg exit_hi i.psy##i.post     if (sample==1 & obstot >=3) , fe cluster(uniqueid)
		eststo: xtreg exit_hi i.psy##i.post age if (sample==1 & obstot >=3) , fe cluster(uniqueid)
		}
		else {
		eststo: xtreg `y' i.psy##i.post			  if (sample==1 & ratio_hi==1 & obstot >=3) , fe cluster(uniqueid)
		eststo:	xtreg `y' i.psy##i.post age 	  if (sample==1 & ratio_hi==1 & obstot >=3) , fe cluster(uniqueid)
		}
		
		}
		esttab est*, keep(1.post 1.psy#1.post) label b(3) se(3) star(+ 0.10 * 0.05 ** 0.01 *** 0.001)  stats( N N_clust ) 





stop

*====================================== The End ========================================


















							
