



* Replicate Main Results from Florida AHCA Emergency Department Discharge Records

* All data prep beings with AHCA-provided raw data that has been converted from DBF files to DTA



********** Set Path to ED Discharge Raw Data in DTA format


cd "~/Documents/Research/Florida/ED"					



********** Find 5 Most Popular CPT Codes 2009-2011 for Mental-Behavioral Health ED Encounters


* Assemble Full Data

use ED09Q1 , clear							

forval i = 2/4 {
	append using ED09Q`i' 
	}


forval i = 10/11 {

	forval j = 1/4 {
		append using ED`i'Q`j'
		}
	}
	
tab year	


* Counts of Ancillary CPTs For MH Patients

keep if TYPE_SERV=="2"

gen diag_num = real(prindiag)

keep if (diag_num >= 290 & diag_num <=316)					

keep SYS_RECID OTHCPT*

reshape long OTHCPT, i(SYS_RECID) j(column)

keep OTHCPT

keep if OTHCPT !=""

gen case = 1

bysort OTHCPT: egen tot_cases = total(case)

keep OTHCPT tot_cases

duplicates drop

sum tot_cases, d

gsort -tot_cases

list OTHCPT tot_cases in 1/5		// top 5: 85025 (208K), 82055 (177K), 80101 (152K), 80053 (141K), 93005 (107K) //


/* NOTES: 85025 is blood count; 82055 EtOH or drug screen in blood or urine; 80101 single drug or drug class screen; 
		  80053comprehensive metabolic panel; 93005 is EKG
*/



****************************************** // ASSEMBLE ANALYTIC DATA // ************************************




* 2009 Data					// NOTE: data structure changes in 2010 Q1 so some variable definitions have to be reconciled bewtween 2009 and 2010-2014 //


forval i = 1/4 {

	tempfile tfile_9_`i'

	use ED09Q`i' , clear
	keep if TYPE_SERV=="2"
	
	gen male  = (sex=="1")
	gen white = (race=="4")
	
	gen suicide = .

	forval j = 1/9 {
	replace suicide = 1 if OTHDIAG`j'=="V62.84" 
		}

	keep year qtr faclnbr FAC_COUNTY age male white ptcounty payer prindiag OTHCPT* suicide

	gen diag_num = real(prindiag)

	keep if (diag_num >= 290 & diag_num <=316)
	
	forval k = 1/9 {
		gen cpt_num_`k' = real(OTHCPT`k')
		}
			
	egen tot_procs = rownonmiss(cpt_num_*)
	label var tot_procs "count total of all listed CPTs for encounter"
	drop cpt_num_*
	
	gen cbc  =.
	gen etoh =.
	gen drug =.
	gen meta =.
	gen ekg  =.

	forval x = 1/9 {

		replace cbc  = 1 if cbc==.  & OTHCPT`x'=="85025"
		replace etoh = 1 if etoh==. & OTHCPT`x'=="82055"
		replace drug = 1 if drug==. & OTHCPT`x'=="80101"
		replace meta = 1 if meta==. & OTHCPT`x'=="80053"
		replace ekg  = 1 if ekg==.  & OTHCPT`x'=="93005"
		}
		
	drop OTHCPT*	
	
	save "`tfile_9_`i''"
	}


* 2010 - 2014 Data

forval i = 10/14 {

	forval j = 1/4 {
	
		tempfile tfile_`i'_`j'
		
		use ED`i'Q`j' , clear
		keep if TYPE_SERV=="2"
		gen white = (race=="5")
		gen male  = (sex=="M")
		
		gen suicide = .

		forval k = 1/9 {
		replace suicide = 1 if OTHDIAG`k'=="V62.84" 
		}
		
		keep year qtr faclnbr FAC_COUNTY age white male ptcounty payer prindiag  OTHCPT* suicide

		gen diag_num = real(prindiag)

		keep if (diag_num >= 290 & diag_num <=316)
		
		forval k = 1/30 {
			gen cpt_num_`k' = real(OTHCPT`k')
			}
			
		egen tot_procs = rownonmiss(cpt_num_*)
		label var tot_procs "count total of all listed CPTs for encounter"
		drop cpt_num_*
			
		gen cbc  =.
		gen etoh =.
		gen drug =.
		gen meta =.
		gen ekg  =.

		forval x = 1/30 {										// up to 30 columns of ancillary CPTs starting in Q1 2010 //

			replace cbc  = 1 if cbc==.  & OTHCPT`x'=="85025"
			replace etoh = 1 if etoh==. & OTHCPT`x'=="82055"
			replace drug = 1 if drug==. & OTHCPT`x'=="80101"
			replace meta = 1 if meta==. & OTHCPT`x'=="80053"
			replace ekg  = 1 if ekg==.  & OTHCPT`x'=="93005"
			}
			
		drop OTHCPT*	
		
		save "`tfile_`i'_`j''"
		}
	}	


* Assemble Analytic Data 2009 Q1 - 2014 Q4


use "`tfile_9_1'" , clear

forval q = 2/4 {
	append using "`tfile_9_`q''"
	}
	
forval r = 10/14 {
	forval s = 1/4 {
		append using "`tfile_`r'_`s''"
		}
	}	

tab year
				

gen qtr_real = real(qtr)
gen time = yq(year , qtr_real)





****************************************** // REGRESSION ANALYSES // ************************************


* Keep only FL Residents

tab ptcounty
drop if ptcounty=="99"						// 9% of observations //


* Flag High BCBSFL Counties (based on Jan 2012 enrollment data provided by Decision Resources Group)

gen county = real(FAC_COUNTY)

drop if county==99						// removing "unknown" geo reporting , zero obs deleted //

gen abv_med_bcbs = (county==1  | ///
					county==3  | ///
					county==4  | ///
					county==7  | ///
					county==9  | ///
					county==12 | ///
					county==14 | ///
					county==15 | ///
					county==19 | ///
					county==21 | ///
					county==23 | ///
					county==24 | ///
					county==25 | ///
					county==26 | ///
					county==30 | ///
					county==31 | ///
					county==32 | ///
					county==34 | ///
					county==38 | ///
					county==39 | ///
					county==40 | ///
					county==42 | ///
					county==43 | ///
					county==44 | ///
					county==47 | ///
					county==54 | ///
					county==55 | ///
					county==56 | ///
					county==61 | ///
					county==62 | ///
					county==63 | ///
					county==66 | ///
					county==67 )

tab county if abv_med_bcbs==1
sum abv_med_bcbs

* Payer Groups

tab payer

gen private  = (payer=="E" | payer=="F" | payer=="G")
gen selfpay  = (payer=="L")



* Procedures in ED

sum tot_procs, d				// NOTE: 2009 data had diff max then subsequent data reporting years //

gen many_procs = (tot_procs>=8)

* Post Period Dummy

gen post = (time>=208)



*********** TABLE 5


local outcomes tot_procs many_procs

foreach yvar of local outcomes {
	reg  `yvar' i.private##i.post##i.abv_med_bcbs if (private==1 | selfpay==1)  , cluster(faclnbr)
	areg `yvar' i.private##i.post##i.abv_med_bcbs if (private==1 | selfpay==1)  , absorb(county)   vce(cluster faclnbr)
	areg `yvar' i.private##i.post##i.abv_med_bcbs if (private==1 | selfpay==1)  , absorb(faclnbr)  vce(cluster faclnbr)
	}
	
sum tot_procs many_procs if ((private==1 | selfpay==1) & post==0)


*********** TABLE 6



replace cbc  =0  if cbc==.
replace etoh =0  if etoh==.
replace drug =0  if drug==.
replace meta =0  if meta==.
replace ekg  =0  if ekg==.

sum cbc etoh drug meta ekg


local outcomes cbc etoh drug meta ekg

foreach yvar of local outcomes {

	sum  `yvar' 								  if ((private==1 | selfpay==1) & post==0)
	areg `yvar' i.private##i.post##i.abv_med_bcbs if (private==1  | selfpay==1)           , absorb(faclnbr) vce(cluster faclnbr)
	}


	
	
********************************* // PROCEDURE INTENSITY OUTCOMES OVER TIME // *****************************	


* Below creates the Main Text Figures 4 and 5 which correspond to the regression analyses in Table 5


keep if private==1 | selfpay==1

collapse tot_procs many_procs , by(private abv_med_bcbs time)

set scheme s1mono

gen avg_procs_priv_hi = tot_procs if (private==1 & abv_med_bcbs==1)
gen avg_procs_self_hi = tot_procs if (private==0 & abv_med_bcbs==1)

twoway (line avg_procs_priv_hi avg_procs_self_hi  time , lpattern(solid dash) lwidth(*1.75 *1.75 *1.75)) , ///
xlabel(196 "2009q1" 200 "2010q1" 204 "2011q1" 208 "2012q1" 212 "2013q1" 216 "2014q1") ///
ylabel(3(1)7) ///
ytitle("Average Number of ED Procedures") xtitle("Year") ///
legend(order(1 "Private - High BCBS Share Areas" 2 "Self-Pay - High BCBS Share Areas")) ///
xline(208, lpattern(line)) text(6 208 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export ~/Desktop/figure_4.pdf , replace


gen procs_priv_hi = many_procs if (private==1 & abv_med_bcbs==1)
gen procs_self_hi = many_procs if (private==0 & abv_med_bcbs==1)

twoway (line procs_priv_hi procs_self_hi  time , lpattern(solid dash) lwidth(*1.75 *1.75 *1.75)) , ///
xlabel(196 "2009q1" 200 "2010q1" 204 "2011q1" 208 "2012q1" 212 "2013q1" 216 "2014q1") ///
ylabel(0.15(0.05)0.45) ///
ytitle("Fraction with High Number of ED Procedures") xtitle("Year") ///
legend(order(1 "Private - High BCBS Share Areas" 2 "Self-Pay - High BCBS Share Areas")) ///
xline(208, lpattern(line)) text(0.4 208 "BCBS Carve-Out", place(nw)) ///
xsize(5.0) ysize(3.0) scale(1.0)

graph export ~/Desktop/figure_5.pdf , replace



