## ==========================
## Figure 3: Mandatorily reported foodborne illnesses, 1990-2015.
## ===========================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)
  
## ==========================
## Read in data
## ==========================  
  
  #Notifiables
  notif.cty.yr.1990.2015 <- read.csv("../Data/illness_reportable_1990_2015.csv", stringsAsFactors = FALSE)
  
  #County population
  county.pop.1964.2015 <- read.csv("../Data/county_population_1964_2015.csv", stringsAsFactors = FALSE)
  
##================================
## Aggregate notifiables and population
## ===============================

  ##Sum notifiables over diseases by county, year
  notif.all <- aggregate(count~county+year, data = notif.cty.yr.1990.2015, FUN = sum)
  
  ## Generate county-year PK in notifiables and in pop data
  notif.all$pk <- apply(notif.all[,c("county", "year")],1,paste,collapse="-")
  county.pop.1964.2015$pk <- paste0(county.pop.1964.2015$Name, "-", county.pop.1964.2015$year)
    
  ## Augmenting notifiables with population
  notif.all$pop <- county.pop.1964.2015$pop[match(notif.all$pk, county.pop.1964.2015$pk)]

  ## Rates
  notif.all$rate <- 100000*notif.all$count/notif.all$pop
  
  #Population and rates for CA (non-LA)
  ca.series <- aggregate(cbind(count, pop) ~ year,
                         data=subset(notif.all, county!="Los Angeles"), FUN=sum)
  ca.series$rate <- 100000*ca.series$count/ca.series$pop 
  
  ## Population and rates for CA (non-LA)
  socal <- c("Imperial", "Kern","Orange","San Bernardino","San Diego",
             "San Luis Obispo","Santa Barbara", "Riverside", "Ventura")
  socal.series <- aggregate(cbind(count, pop) ~ year,
                            data=subset(notif.all, county%in%socal), FUN=sum)
  socal.series$rate <- 100000*socal.series$count/socal.series$pop
  

##================================
## Output: Plot 
## ===============================
  
  #Plot range for y limits
  my.range <- c(20,50)
  
  #Years for x limits
  years <- 1990:2015
    
  #Code for plot
  par(mfrow=c(1,2))
  par(mar=c(3,3,2,1), mgp=c(1.5,0.5,0), tcl =-0.3)
  
  plot(years, notif.all$rate[notif.all$county=="Los Angeles"],type="n",
       main="Illnesses", xlab="Years", ylab="Rate",
       ylim=my.range)
  rect(1995, par("usr")[3], 1999, par("usr")[4], col = rgb(0,0,0,0.15), border = NA)
  abline(v=1997.5,col="white")
  lines(years, ca.series$rate,col=rgb(0,0,1,0.8),lty=5)
  lines(years, notif.all$rate[notif.all$county=="Los Angeles"],col=rgb(1,0,0,0.8),lwd=1.5)
  text(1991.5, 48, "CA", col="blue")
  text(1991.5, 30, "LA", col="red")
  
  plot(years, notif.all$rate[notif.all$county=="Los Angeles"],type="n",
       ylim=my.range,xlab="Years", ylab="Rate",main="Southern California")
  rect(1995, par("usr")[3], 1999, par("usr")[4], col = rgb(0,0,0,0.15), border = NA)
  abline(v=1997.5,col="white")
  lines(years, socal.series$rate,col=rgb(1,0,1,0.95),lty=5)
  lines(years, notif.all$rate[notif.all$county=="Los Angeles"],col=rgb(1,0,0,0.8),lwd=1.5)
  text(1991.5, 43, "LA", col="red")
  text(1992, 25, "Southern\nCA", col="purple",cex=0.8)


