function diff3 = dif_mcp_sT(gamma,aucvec_use,time,time2,time3,time4,...
    time5,mc_unit,mc_inc_q,qse_id,p,qinc,bidderid,p_fringe_all,q_fringe_all,...
    nbidders_CH,bidders_CH,qcont_mat,hbid,K,X,mcp,n_aucs,PDF)

%**************************************************************************
%************************* for i1 = 1:n_aucs ******************************
%************************ loop over auctions ******************************
%**************************************************************************


% define number of grid points to be used.
np = 81;

diffM = zeros(np,K+1,nbidders_CH,n_aucs); % This array stores the differences between bid data and
% bids as predicted by the model for each player in each auction, for each
% possible type of that strategic player, for all the bids points under
% consideration.

PR_Type=zeros(K+1,nbidders_CH,n_aucs); % This array has the probability of bidder i of being 
% type k in auction t.

parfor i1 = 1:n_aucs
    % load data for this auction %
    thisauction = aucvec_use(i1);
    iauc = find(time == thisauction);
    iauc2 = find(time2 == thisauction);
    iauc3 = find(time3 == thisauction);
    iauc4 = find(time4 == thisauction);
    iauc5 = find(time5 == thisauction);
    
    mcpauc = mcp(iauc2);
    mcp_auc = mc_unit(iauc3);
    mcq_auc = mc_inc_q(iauc3);
    qseidauc = qse_id(iauc3);
    
    pauc = p(iauc);
    qauc = qinc(iauc);
    bidderidauc = bidderid(iauc);
    
    p_fringe = p_fringe_all(iauc4);
    q_fringe = q_fringe_all(iauc4);
    
    qcont = qcont_mat(iauc5,:);
    
    % grid price interval around market clearing price %
    pgrid_lower = mcpauc-20;
    pgrid_upper = mcpauc+20;
    pgrid_xp = [pgrid_lower:0.5:pgrid_upper]';
    n_pgrid = length(pgrid_xp);
    
    % define outcome matrices %
    bids_fnc = zeros(n_pgrid,nbidders_CH,K+1); % bids_fnc(2,:,4)==bidder2's bid function when he is type 3
    bids_fnc_inc = zeros(n_pgrid,nbidders_CH,K+1); % bids_fnc_inc(2,:,4)==bidder2's incremental bid
    % function when he is type 3
    
    %**************************************************************************
    %********************** for i2 = 1:nbidders_CH ****************************
    %********************* loop over bidders in CH ****************************
    %**** find xpo opt bids and theoretical opt bids for type 0 and type1 *****
    %**************************************************************************
    
    for i2 = 1:nbidders_CH
        % load data for this bidder in this auction %
        thisbidder = bidders_CH(i2);
        ibidder2 = find(qseidauc == thisbidder);
        mcpbidder = mcp_auc(ibidder2);
        mcqbidder = mcq_auc(ibidder2);
        mcqcumbidder = cumsum(mcqbidder);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%% find theoretical opt bids for type 0 %%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        qcont_bidder = qcont(i2);
        bidq_0 = qcont_bidder*ones(n_pgrid,1);
        bidq_inc_0 = zeros(n_pgrid,1);
        bidq_inc_0(1) = qcont_bidder;
        bidq_inc_0(2:n_pgrid) = zeros(1,n_pgrid-1);
        bids_fnc(:,i2,1) = bidq_0;
        bids_fnc_inc(:,i2,1) = bidq_inc_0';
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%% find theoretical opt bids for type 1 %%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % qcont_bidder = qcont(i2);
        [bidq_1, bidp_1] = find_expost_optimum(thisbidder,qcont_bidder,...
            mcqcumbidder,mcpbidder,p_fringe,q_fringe,hbid,pgrid_xp);
        bidq_inc_1 = incremental(bidq_1);
        bids_fnc(:,i2,2) = bidq_1;
        bids_fnc_inc(:,i2,2) = bidq_inc_1;
        
    end % i2=1:nbidders_CH

    
    %**************************************************************************
    %************************** for i3=2:K ************************************
    %************************ loop over types *********************************
    %********************** for i4=1:nbidders_CH ******************************
    %********************* loop over bidders in CH ****************************
    %************* find theoretical opt bids for type2 to typeK ***************
    %**************************************************************************
    
    for i3=2:K
        for i4=1:nbidders_CH
            % load data for this bidder in this auction %
            thisbidder = bidders_CH(i4);
            ibidder2 = find(qseidauc == thisbidder);
            mcpbidder = mcp_auc(ibidder2);
            mcqbidder = mcq_auc(ibidder2);
            mcqcumbidder = cumsum(mcqbidder);
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%% find theoretical opt bids for type k %%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            qcont_bidder = qcont(i4);
            [q_rd,p_rd] = find_rd(pgrid_xp,nbidders_CH,bids_fnc_inc,i3,gamma,...
                X,p_fringe,q_fringe,i4,K);
            [bidq_K, bidp_K] = find_expost_optimum(thisbidder,qcont_bidder,...
                mcqcumbidder,mcpbidder,p_rd,q_rd,hbid,pgrid_xp);
            bidq_inc_K = incremental(bidq_K);
            bids_fnc(:,i4,i3+1) = bidq_K;
            bids_fnc_inc(:,i4,i3+1) = bidq_inc_K';
            
        end % i4=1:nbidders_CH
    end % i3=1:K
    
    %**************************************************************************
    %************************* find objective function ************************
    %**************************************************************************
    
    diff_PKB=zeros(np,K+1,nbidders_CH);
    type_prB=zeros(K+1,nbidders_CH);
    for i5 = 1:nbidders_CH
        % load data for this bidder in this auction %
        thisbidder = bidders_CH(i5);
        ibidder = find(bidderidauc == thisbidder);
        pbidder = pauc(ibidder);
        qbidder = qauc(ibidder);
        ybidder = cumsum(qbidder);
        % grid actual bids %
        [ygrid,pgrid] = grid_new(ybidder,pbidder,pgrid_xp);
        % find type distribution for this bidder
        tao = exp(gamma*[1;X(:,i5)]); % find tao for poisson
        type_prB(:,i5) = sel_type_pr_smooth(tao,K)'; % drawing type distribution according to Untruncated poisson %
        
        diff_K = zeros(length(pgrid),K+1);
        diff_K_S = diff_K;
        q_tho = zeros(length(pgrid),K+1);
        for i7 = 1:length(pgrid)
            for i6 = 1:K+1
                q_tho(i7,i6) = bids_fnc(i7,i5,i6);
               diff_K(i7,i6) = q_tho(i7,i6)-ygrid(i7);
            end
             for i6=1:K+1
                 if abs(q_tho(i7,K+1)-q_tho(i7,1))<=1e-10
                diff_K_S(i7,i6)=0;
                 else
                diff_K_S(i7,i6)=(diff_K(i7,i6)./(abs(q_tho(i7,K+1)-q_tho(i7,1)))).^2;
                 end
             end
        end
        diff_PK=diff_K_S;
        diff_PKB(:,:,i5) = diff_PK;
        PR_Type(:,:,i1) = type_prB;
    end % for i5=1:nbidders_CH
    diffM(:,:,:,i1) = diff_PKB;
end % for i1=1:n_aucs

% Sum over weighted price points
diffM=reshape(sum(PDF.*diffM,1),K+1,nbidders_CH,n_aucs);

% For each bidder-type, sum differences across all auctions
diffM=sum(diffM,3);
% Multiply, for each firm, the type prob matrix by the differences,
% conditional on type. Then add over types. Finally, add over firms.
Weighted_differences=sum(sum(diffM.*mean(PR_Type,3),2));

diff3 = Weighted_differences;
end
