function [qint,pint] = intersect_grid(qbid,qmc,pgrid)

% intersect step functions which are adapted to a common price grid
% make sure first argument is bid, second argument is MC

% in the regular case, MC goes to the "right" of the bid curve
% at the crossing point
agtb = (qmc>=qbid);

% find 0 to 1 transition points

crossings=[];
np=length(qbid);
for j=2:np
    if agtb(j)~=agtb(j-1)
        crossings=[crossings,j];
    end
end

qint=qbid(crossings);
pint=pgrid(crossings);

