/* This do file is used to process the output of the counterfactuals and
 generates the plots and tables that we use in the paper.

We proceed as follows:

1) Compute average "total" inefficiency across auctions separating dec
and inc side. It is "total" as the benchmark is when CH firms bid MC. As
realized cost we use the one predicted by the model at the estimated
parameters. We also compute the realized "total" inefficiency using the
bid data.

2) We compute the inefficiency for each of the Increasing IQ
counterfactuals.

3) We compute the inefficiency for each of the mergers

NOTE: When loading files, the first number says whether it refers to all
auctions (0), inc (1), or dec (2). The second number refers to the
exercise.
*/


********************************************************************************
* INC SIDE: public
********************************************************************************

* "Total" inefficiency under CH

import delimited benchmark4_s_tcost_1.csv, clear
count
rename v1 aucid
sort aucid
by aucid: keep if _n==1 
egen avcostauction = rowmean(v2-v1001)
sum avcostauction

gen benchmark = 1
save benchmark_draw_1.dta, replace
/*
Average cost predicted by the model: 22343.61 (avcostauction)
Average cost data: 27199.41 
Average cost "everybody" bids MC (everybody for whom we have mc data): 8721.279 (acost1)
Average cost CH firms bid MC: 13222.21 (acost2)

Total inefficiency to be reduced: 22343.61-13222.21 = 9121.4

*/

* Increasing IQ
*  Firms below the median taken to the median:

import delimited "IncIQ_s_draw_tcost firm 4   8  23  24  29   9 incIQ to 0.10461_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction


/* average total cost: 21710.16
 percentage reduction: 21710.16-13222.21=8487.95 ---> reduction is 1-(8487.95/9121.4) = 6.95%
*/

* Above median firms taken to the max
import delimited "IncIQ_s_draw_tcost firm 16   6  15   5  27 incIQ to 0.195_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 22096.26
* percentage reduction: 22096.26-13222.21=8874.05 ---> reduction is 1-(8874.05/9121.4) = 2.71%%

* Three smallest firms and put them just above the median
import delimited "IncIQ_s_draw_tcost firm 4   8  23 incIQ to 0.10461_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 21917.21
* percentage reduction: 21917.21-13222.21=8695 ---> reduction is 1-(8695/9121.4) = 4.67%

********************************************************************************
* INC SIDE: private
********************************************************************************

* Increasing IQ
*  Firms below the median taken to the median:

import delimited "Private_IncIQ_s_draw_tcost firm 4   8  23  24  29   9 incIQ to 0.10461_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

/* average total cost: 21776.1
 percentage reduction: 21776.1-13222.21=8553.89 ---> reduction is 1-(8553.89/9121.4) = 6.22%
*/

* Above median firms taken to the max
import delimited "Private_IncIQ_s_draw_tcost firm 16   6  15   5  27 incIQ to 0.195_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 22164.74
* percentage reduction: 22164.74-13222.21=8942.53 ---> reduction is 1-(8942.53/9121.4) = 1.96%

* Three smallest firms and put them just above the median
import delimited "Private_IncIQ_s_draw_tcost firm 4   8  23 incIQ to 0.10461_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 22001.26
* percentage reduction: 22001.26-13222.21=8779.05 ---> reduction is 1-(8779.05/9121.4) = 3.75%


********************************************************************************
* DEC SIDE: public
********************************************************************************

* "Total" inefficiency

import delimited benchmark4_s_tcost_2.csv, clear

rename v1 aucid
sort aucid
by aucid: keep if _n==1 
egen avcostauction = rowmean(v2-v1001)
sum avcostauction

/*
Average cost predicted by the model: -37652.82 (acostpred)
Average cost data: -11335.82 (acostreal)
Average cost "everybody" bids MC (everybody for whom we have mc data): -52008.93 (acost1)
Average cost CH firms bid MC: -52842.14 (acost2)

Total inefficiency to be reduced: -37652.82-(-52842.14) = 15189.32

*/

* Increasing IQ
*  Firms below the median taken to the median:

import delimited "IncIQ_s_draw_tcost firm 4   8  23  24  29   9 incIQ to 0.10461_2.csv", clear

rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -40452.82
* percentage reduction: -40452.82-(-52842.14)=12389.32 ---> reduction is 1-(12389.32/15189.32) = 18.4%

* Above median firms taken to the max
import delimited "IncIQ_s_draw_tcost firm 16   6  15   5  27 incIQ to 0.195_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -39698.8
* percentage reduction: -39698.8-(-52842.14)=13143.34 ---> reduction is 1-(13143.34/15189.32) = 13.47%

* Three smallest firms and put them just above the median
import delimited "IncIQ_s_draw_tcost firm 4   8  23 incIQ to 0.10461_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -39815.72
* percentage reduction: -39815.72-(-52842.14)=13026.42 ---> reduction is 1-(13026.42/15189.32) = 14.24%

********************************************************************************
* DEC SIDE: private
********************************************************************************

* Increasing IQ
*  Firms below the median taken to the median:

import delimited "Private_IncIQ_s_draw_tcost firm 4   8  23  24  29   9 incIQ to 0.10461_2.csv", clear

rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -40326.59
* percentage reduction: -40326.59-(-52842.14)=12515.55 ---> reduction is 1-(12515.55/15189.32) = 17.6%

* Above median firms taken to the max
import delimited "Private_IncIQ_s_draw_tcost firm 16   6  15   5  27 incIQ to 0.195_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -39544.79
* percentage reduction: -39544.79-(-52842.14)=13297.35 ---> reduction is 1-(13297.35/15189.32) = 12.46%


* Three smallest firms and put them just above the median
import delimited "Private_IncIQ_s_draw_tcost firm 4   8  23 incIQ to 0.10461_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -39723.94
* percentage reduction: -39723.94-(-52842.14)=13118.2 ---> reduction is 1-(13118.2/15189.32) = 13.64%


********************************************************************************
*************************        MERGERS            ****************************
********************************************************************************

* We do three mergers: smallest and largest firm, median firm and largest, and 
* second biggest and the largest

* Smallest firm is 4
* Median is 9
* Second biggest is 27
* Biggest is 19

* INC side:

* Merger with smallest firm
import delimited "merger_s_draw_tcost 19 acquires 4_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 22104.63 
* Recall that total inefficiency to be reduced is: 9121.4
* percentage reduction: 22104.63 -13222.21=8882.42---> reduction is 1-(8882.42/9121.4) = 2.62%

* Merger with median firm
import delimited "merger_s_draw_tcost 19 acquires 9_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 23282.18 
* Recall that total inefficiency to be reduced is: 9121.4
* percentage increase: 23282.18 -13222.21=10059.97 ---> INCREASE in cost of (10059.97/9121.4)-1 = 10.29%

* Merger with second largest firm
import delimited "merger_s_draw_tcost 19 acquires 27_1.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: 24020.32
* Recall that total inefficiency to be reduced is: 22478.02-13222.21 = 9121.4
* percentage increase: 24020.32-13222.21=10798.11 ---> INCREASE in cost of (10798.11/9121.4)-1 = 18.38%

* DEC side:

* Merger with smallest firm
import delimited "merger_s_draw_tcost 19 acquires 4_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -38638.4
* percentage reduction: -38638.4 -(-52842.14)=14203.74 ---> reduction is 1-(14203.74/15189.32) = 6.49%

* Merger with median firm
import delimited "merger_s_draw_tcost 19 acquires 9_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -36077.62
* percentage reduction: -36077.62-(-52842.14)=16764.52 ---> Increase in inefficiency is (16764.52/15189.32)-1 = 10.37%


* Merger with second largest firm
import delimited "merger_s_draw_tcost 19 acquires 27_2.csv", clear
rename v1 aucid

egen avcostauction = rowmean(v2-v1001)
sum avcostauction

* average total cost: -30251.95
* percentage reduction: -30251.95-(-52842.14)=22590.19 ---> Increase in inefficiency is (22590.19/15189.32)-1 = 48.72%
