function [time_id_bids_mat,n_pgrid] = find_bids_pre_draw(gamma,aucvec,time_dem,mktcp,...
    time_mc,time_fringe,time_qcont,mc_unit,mc_inc_q,qse_id,p_fringe_all,...
    q_fringe_all,bidders_CH,qcont_mat,X,K)

hbid=50;
nbidders_CH=length(bidders_CH);
time_id_bids_mat=[];
for i1 = 1:length(aucvec)
    % load data for this auction %
    thisauction = aucvec(i1);
    
    % market clearing price for this auction
    mcpauc=mktcp(find(time_dem == thisauction));
    % grid price interval around market clearing price %
    pgrid_lower = mcpauc-20;
    pgrid_upper = mcpauc+20;
    pgrid_xp = [pgrid_lower:0.5:pgrid_upper]';
    n_pgrid = length(pgrid_xp);
    
    mcp_auc = mc_unit(find(time_mc == thisauction));
    mcq_auc = mc_inc_q(find(time_mc == thisauction));
    qseidauc = qse_id(find(time_mc == thisauction));
    
    p_fringe = p_fringe_all(find(time_fringe == thisauction));
    q_fringe = q_fringe_all(find(time_fringe == thisauction));
    
    qcont = qcont_mat(find(time_qcont == thisauction),:);
    
    % define outcome matrices %
    bids_fnc = []; % bids_fnc(2,:,4)==bidder2's bid function when he is type 3
    bids_fnc_inc = []; % bids_fnc_inc(2,:,4)==bidder2's incremental bid
 
    
    %**************************************************************************
    %********************** for i2 = 1:nbidders_CH ****************************
    %********************* loop over bidders in CH ****************************
    %**** find xpo opt bids and theoretical opt bids for type 0 and type1 *****
    %**************************************************************************
    
    for i2 = 1:nbidders_CH
        % load data for this bidder in this auction %
        thisbidder = bidders_CH(i2);
        mcpbidder = mcp_auc(find(qseidauc == thisbidder));
        mcqbidder = mcq_auc(find(qseidauc == thisbidder));
        mcqcumbidder = cumsum(mcqbidder);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%% find theoretical opt bids for type 0 %%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        qcont_bidder = qcont(i2);
        bidq_0 = qcont_bidder*ones(n_pgrid,1);
        bidq_inc_0(1) = qcont_bidder;
        bidq_inc_0(2:n_pgrid) = zeros(1,n_pgrid-1);
        bids_fnc(:,i2,1) = bidq_0;
        bids_fnc_inc(:,i2,1) = bidq_inc_0';
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%% find theoretical opt bids for type 1 %%%%%%%%%%%%%%%%%
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % qcont_bidder = qcont(i2);
        [bidq_1, bidp_1] = find_expost_optimum(thisbidder,qcont_bidder,...
            mcqcumbidder,mcpbidder,p_fringe,q_fringe,hbid,pgrid_xp);
        bidq_inc_1 = incremental(bidq_1);
        bids_fnc(:,i2,2) = bidq_1;
        bids_fnc_inc(:,i2,2) = bidq_inc_1';
        
    end % i2=1:nbidders_CH
    
    %**************************************************************************
    %************************** for i3=2:K ************************************
    %************************ loop over types *********************************
    %********************** for i4=1:nbidders_CH ******************************
    %********************* loop over bidders in CH ****************************
    %************* find theoretical opt bids for type2 to typeK ***************
    %**************************************************************************
    
    for i3=2:K
        for i4=1:nbidders_CH
            % load data for this bidder in this auction %
            thisbidder = bidders_CH(i4);
            mcpbidder = mcp_auc(find(qseidauc == thisbidder));
            mcqbidder = mcq_auc(find(qseidauc == thisbidder));
            mcqcumbidder = cumsum(mcqbidder);
            
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%% find theoretical opt bids for type k %%%%%%%%%%%%%%%%%%%%%%
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            qcont_bidder = qcont(i4);
            [q_rd,p_rd] = find_rd(pgrid_xp,nbidders_CH,bids_fnc_inc,i3,gamma,...
                X,p_fringe,q_fringe,i4,K);
            [bidq_K, bidp_K] = find_expost_optimum(thisbidder,qcont_bidder,...
                mcqcumbidder,mcpbidder,p_rd,q_rd,hbid,pgrid_xp);
            bidq_inc_K = incremental(bidq_K);
            bids_fnc(:,i4,i3+1) = bidq_K;
            bids_fnc_inc(:,i4,i3+1) = bidq_inc_K';
            
        end % i4=1:nbidders_CH
    end % i3=1:K
    
    
    bids = reshape(bids_fnc,nbidders_CH*n_pgrid,K+1);
    bids_inc = reshape(bids_fnc_inc,nbidders_CH*n_pgrid,K+1);
    

    id_bids_mat=[];
    for i10=1:length(bidders_CH)
        id_temp=bidders_CH(i10)*ones(length(pgrid_xp),1);
        id_bids=[id_temp pgrid_xp bids_inc(n_pgrid*(i10-1)+1:n_pgrid*i10,:) bids(n_pgrid*(i10-1)+1:n_pgrid*i10,:)];
        id_bids_mat=[id_bids_mat;id_bids];
    end
    time_id_bids_mat=[time_id_bids_mat; thisauction*ones(length(id_bids_mat),1) id_bids_mat];
    

end % for i1=1:n_aucs

