function mcp = find_mktclr_new(aggsq, aggsp, totdemauc)

% ASSUMES THAT BIDS ARE IN INC FORMAT
% find mkt clearing price 
% given
% quantity steps of aggregate supply curve -- aggsq
% price steps of aggregate supply curve -- aggsp
% total demand in the auction -- totdemauc

% find the first price at which supply exceeds demand
igt = find(aggsq>totdemauc);

if ~isempty(igt)
    mcp = aggsp(igt(1));
else
    mcp = 10001;
end
