function [profit_i,totcost] = find_profit1(mcqcumbidder,mcpbidder,qcall_i,mcpaucsim,qcont,whichbidder)

%%%%%%%%%%%%%%%%%%
% finds profits by "integrating" under MC function
%  Overall idea:  find length and width of each rectangle from q=0 to q=qcall_i and take dot product
%%%%%%%%%%%%%%%%%

error_n = -999999;


if whichbidder==5 & max(mcqcumbidder)<=0
    profit_i = error_n;
    totcost = error_n;
    return
end    


if (qcall_i>max(mcqcumbidder) | qcall_i<min(mcqcumbidder) )  
profit_i= error_n;
totcost= error_n;


else  %MAIN PART OF FUNCTION

%--extend the MC function so can evaluate MC(q) at every necessary q (in particular q=0 & qcall_i)
%       (right now, there is no MC(q) for q=0 or q=qcall_i and we need those points to calculate the right rectangles

keeppts=find(abs(mcpbidder)<999);   %drop the MC=1000 and -1000 points -- should KEEP MC=-99 (mingen) points
mcqcumbidder1=mcqcumbidder(keeppts);
mcpbidder1=mcpbidder(keeppts);

mcqtemp = [0,qcall_i,mcqcumbidder1']';  %add 2 quantity points to evaluate MC at
mcptemp = [-666,-666,mcpbidder1']';     %MC vector with 2 prices that needed replacing (-666 used below so don't change)

sortedmc = sortrows([mcqtemp,mcptemp],1);
mcqcumbidder_new = sortedmc(:,1);
mcpbidder_new = sortedmc(:,2);


ng=length(mcqcumbidder_new);

for k=1:ng
    ind_mcq = find(mcqcumbidder_new(k)<=mcqcumbidder1);  %NOTE: use weak <= b/c not higher MC until move above the q
      if (~isempty(ind_mcq) & mcpbidder_new(k)==-666)  %only replace the missing (-666) prices with MC(q)
            mcpbidder_new(k)=mcpbidder1(min(ind_mcq));
      end
end


%find area under C(qcall_i)
mcq_inc = mcqcumbidder_new;

if qcall_i>0
    for j=2:ng
        mcq_inc(j)=mcqcumbidder_new(j)-mcqcumbidder_new(j-1);  %find incremental q_INC
    end
    limits = find(mcqcumbidder_new>0 & mcqcumbidder_new<=qcall_i);  %>0 to starts on first incremental (as long as 0 is a q point)
    totcost = mcq_inc(limits)'*mcpbidder_new(limits);  %"add" the rectangles
    
elseif qcall_i<0
    for j=2:ng
        mcq_inc(j)=mcqcumbidder_new(j)-mcqcumbidder_new(j-1);  %find incremental q_DEC
    end
    mcq_inc(1)=0;  %fix the first point - not DEC beyond this point, so set to 0, should never matter    
    limits = find(mcqcumbidder_new>qcall_i & mcqcumbidder_new<=0);    %see notes 10/7/03 -- multiply "beginning point of DEC" times mcq_inc
    totcost = (-1) * mcq_inc(limits)'*mcpbidder_new(limits);
    
elseif qcall_i==0
    totcost = 0;    
    
end


profit_i = mcpaucsim*qcall_i - totcost - mcpaucsim*qcont;


end  %main function
