% This m-file executes all counterfactuals for the base case when tau is
% only a function of size.

%% Some data
firms=[4,8,23,24,29,9,16,6,15,5,27,19]; 
fsize=[0.021538 0.044231 0.055385 0.07 0.086154 0.103462 0.104615 0.135385 0.152308 0.156923 0.169615,0.195];
size(firms)
size(fsize)
R = 1000;    % number of simulation

% take type draws
[id_org,type_sim]=type_draw(R);


%% Increasing IQ (public)

%  take all 6 firms that are size 54% or below (relative to largest)

type_sim1=type_draw_IncIQ_replace([4,8,23,24,29,9],0.104615,R,id_org,type_sim);
inc_IQ_s_draw([4,8,23,24,29,9],0.104615,1,R,type_sim1);
inc_IQ_s_draw([4,8,23,24,29,9],0.104615,2,R,type_sim1);

% take the above median size firms EXCEPT largest and give them largest IQ.

type_sim2=type_draw_IncIQ_replace([16,6,15,5,27],0.195,R,id_org,type_sim);
inc_IQ_s_draw([16,6,15,5,27],0.195,1,R,type_sim2);
inc_IQ_s_draw([16,6,15,5,27],0.195,2,R,type_sim2);

% take the three smallest firms and make the just above the median
type_sim3=type_draw_IncIQ_replace([4,8,23],0.104615,R,id_org,type_sim);
inc_IQ_s_draw([4,8,23],0.104615,1,R,type_sim3);
inc_IQ_s_draw([4,8,23],0.104615,2,R,type_sim3);

%% Increasing IQ (private)

type_sim_p1=type_draw_IncIQ_replace([4,8,23,24,29,9],0.104615,R,id_org,type_sim);
inc_IQ_private_s_draw([4,8,23,24,29,9],0.104615,1,R,type_sim_p1);
inc_IQ_private_s_draw([4,8,23,24,29,9],0.104615,2,R,type_sim_p1);


type_sim_p2=type_draw_IncIQ_replace([16,6,15,5,27],0.195,R,id_org,type_sim);
inc_IQ_private_s_draw([16,6,15,5,27],0.195,1,R,type_sim_p2);
inc_IQ_private_s_draw([16,6,15,5,27],0.195,2,R,type_sim_p2);


type_sim_p3=type_draw_IncIQ_replace([4,8,23],0.104615,R,id_org,type_sim);
inc_IQ_private_s_draw([4,8,23],0.104615,1,R,type_sim_p3);
inc_IQ_private_s_draw([4,8,23],0.104615,2,R,type_sim_p3);


