* APPENDIX_TABLE_B1.DO
*
*   This code is used to generate Appendix Table B1
*     It tests whether firms offer more generation capacity into the market
*     in the second versus the first year of the market.
*   The input data are firm-level output and bids across auctions in
*     year 1 and year 2 of the market.
*

clear

eststo clear
local regressout particip_learning.out

	
use participation_CH, clear
	
*qcall_act = actual production under bids
*qcont = contract position 
g participation_q = qcall_act - qcont
g abs_participation_q = abs(qcall_act - qcont)

g year2=(year==2)


*Controls:  INC or DEC, Day of Week

g INC=(totdemauc>=0)
g dow = dow(daycount+mdy(7,31,2001))

egen firm = group(firm90)
xtset firm

xtreg abs_participation_q year2, fe vce(robust)
eststo,title("Benchmark")
xtreg abs_participation_q year2 INC, fe vce(robust)
eststo,title("Add INC")
xtreg abs_participation_q year2 INC i.dow, fe vce(robust)
eststo,title("INC+DOW")
xtreg abs_participation_q year2 INC i.dow if smallfirm==1, fe vce(robust)
eststo,title("OnlySmall")

estout using `regressout', cells(b(star fmt(%9.2f) ) se(fmt(%9.2f) par(`"="("'`")""')) ) stats(depvar N r2, fmt(0 0 %9.4f) labels(DepVar "N" "R^2")) label wrap starlevels(+ 0.05 * 0.01) legend varlabels(_cons Constant) replace
