% This is a marginally modified version of the Cesa-Bianchi's code


%=========================================================================%
% Carlstrom and Fuerst model (1997, AER)
% Ambrogio Cesa-Bianchi, November 2012
%=========================================================================%
% If you find any bugs when using this file or want to give me comments
% and suggestions you can email me at ambrogio.cesabianchi@gmail.com

% I thank Kevin Salyer for spotting a bug in a previous version of this code


% Number of simulations
nz=10000;
% nz=1000;
% length of a simulation
hor = 270;





gg=1.0156^0.25;

hh=1:hor;
hh0=51:50+hor;
ddate(1)=1948;
for i=2:hor
    ddate(i)=ddate(i-1)+.25;
end;

samp=find(ddate==1948):find(ddate==2015.25); % for Total hours data

var K ke H He h q n i omegab ce cc w we Y r I Cc Ce C Bankrupcy Rb rpBANK rpENT lev rif PHI phi f g A;

varexo eA eN;

parameters alpha zeta beta delta gamma eta S nu mu p M rhoA StdeA StdeN;
alpha    = 0.36;
zeta     = 1-alpha-0.0001;
beta     = 0.99;
delta    = 0.02;
gamma    = 0.9474;
eta      = 0.1;
rhoA     = 0.99;
StdeA    = 0.01;
StdeN    = 0.1;
S        = 0.207;
nu       = 2.52;
mu       = 0.25;
p        = pi;
M        = -.5*S^2;
rhoStdA  = 0.83;
StdeStdA = 0.19;


model;
q/cc = beta*(1/cc(+1))*(q(+1)*(1-delta)+r(+1));
nu*cc = w;
ke = i*f - ce/q;
n = we + (ke(-1))*(q*(1-delta)+r) + StdeN*eN;
K = (1-delta)*K(-1) + I*(1-mu*PHI);
(1-eta)*cc + eta*ce + eta*i = Y;
q =  (beta*gamma) * (r(+1) + q(+1)*(1-delta))  * ( (q(+1)*f(+1))/(1-q(+1)*g(+1)) );
q = 1/(1 - mu*PHI - (mu*phi*f)/(1-PHI));
i = (1/(1-q*g)) * n;
Y = A*(K(-1)^alpha)*(H^zeta)*(He^(1-alpha-zeta));
r = alpha*A*(K(-1)^(alpha-1))*(H^zeta)*(He^(1-alpha-zeta));
w = zeta*A*(K(-1)^alpha)*(H^(zeta-1))*(He^(1-alpha-zeta));
we = (1-alpha-zeta)*A*(K(-1)^alpha)*(H^zeta)*He^(-(alpha+zeta));
H = (1-eta)*h;
He = eta;
Cc = (1-eta)*cc;
Ce = eta*ce;
C = (1-eta)*cc + eta*ce;
I = eta*i;
Bankrupcy = PHI;
Rb = (q*i*omegab)/(i-n);
rpBANK = Rb - 1;
lev = i/n;
rif = q*f*i/n;
rpENT = q*(1+r)-Rb;
PHI = normcdf((log(omegab)-M)/S);
phi = normpdf((log(omegab)-M)/S) / (omegab*S);
g   = normcdf((log(omegab)-M)/S - S) - PHI*mu + (1-PHI)*omegab;
f   = 1 - mu*PHI - g;
A    = (1-rhoA) + rhoA*A(-1) + StdeA*eA;
end;


initval;
omegab  = 0.603892;
PHI     = normcdf((log(omegab)-M)/S);
phi     = normpdf((log(omegab)-M)/S) / (omegab*S);
g       = normcdf((log(omegab)-M)/S - S) - PHI*mu + (1-PHI)*omegab;
f       = 1-mu*PHI- g;
q       = 1/(1-mu*0.01+(gamma-1)*f);
r       = q*((1-beta*(1-delta))/beta);
H       = .3;
He      = eta;
h       = .3/(1-eta);
K       = (alpha/r)^(1/(1-alpha))*(He^(1-alpha-zeta))*(H^(zeta/(1-alpha)));
Y       = (K^alpha)*(H^zeta)*(He^(1-alpha-zeta));
i       = (delta/(eta*(1-mu*0.01)))*K;
n       = (1-g*q)*i;
ke      = (beta/q)*(eta*n-(1-alpha-zeta)*Y);
ce      = q*(f*i-(ke/eta));
cc      = (Y - eta*ce - eta*i)/(1-eta);
A       = 1;
end;

steady;
check;

shocks;
var eA = 1;
var eN = 1;
end;



%% Stochastic simulations

nj=0;

while nj<nz;
    nj=nj+1;
    disp(nj);
    
    
    stoch_simul(order=1,periods=355,nocorr,nofunctions,nomoments,irf=0,noprint);
    
    
    
    
    for i=[3 4];
        s1=['V' deblank(M_.endo_names(i,:)) ' = (oo_.endo_simul(' num2str(i) ',2:options_.periods)) ;'];% Levels
        eval(s1);
        s2=[deblank(M_.endo_names(i,:)) 'bar = (oo_.steady_state(' num2str(i) ')) ;'];% SS level
        eval(s2);
    end;
    
    
    
    
    lh=log(VHe(hh0)+VH(hh0))';
    
    
    X0=lh;
    
    
    Xbp(:,nj)=(X0(samp)-mean(X0(samp)))*100;
    
    
    
end;  % end of simulations


%% Estimating Spectral density

TT = 1024;                   % number of points in fft
nkern=13;                    % Kernel
kr = hamming(nkern);

Tsp = length((samp));                    % size of simulated data set, minus 1, before cutting

% number of points in one side of fft
Todd = logical(mod(TT,2));
if Todd
    TT2 = (TT+1)/2;
else
    TT2 = TT/2 + 1;
end

kr = kr/sum(kr);                            % normalize weights to sum to one
nkr = numel(kr);                            % length of kernel function



for nj=1:nz
    [datspecT,~] = DatSpec([Xbp(:,nj)],kr,0,TT);        % call external spectrum estimation function
    spXbpLevel(:,nj)  = squeeze(datspecT(1,1,:));
end

spXm=mean(spXbpLevel,2);

spXmh=spXm;

save CFSimulatedSpectrum spXmh;

