##########################################################
# EstimFM.R

# Last updated: 6 June 2015 

# Purpose: This file runs the estimation algorithm for the 
# measurement system  and extracts the output needed to
# to draw the factors 
##########################################################


for (boot in 0:Bootstrap){

##########################################################
##########################################################
# ON TRUE DATA 
##########################################################
##########################################################

if (boot==0 & onlyboot==0){   

# Estimate factor model by calling EM_continuous (defined in "EM_continuous_groups_norestrict_endo.R") 
if (parametric==1){
  if (invar==0){
   if (nM>=2){
     all <- estim.meas.model.group(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,mstep.start, param.start) 
   }
  }else if (invar==1){
    all <- estim.meas.model.group.intercept.invariance(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,invarint, invarload,mstep.start, param.start)            
  }

  
  
# Save estimates in long format to use as starting values in bootstrap 
param.start.new  <- all[[1]]
setwd(dir_outputFM)
save(param.start.new, file="param_start.R")

# Save estimates from the EM algorithm as starting values in bootstrap 
mstep.start.new <- all[[3]]
setwd(dir_outputFM)
save(mstep.start.new, file="mstep_start.R")

# Extract output for drawing factors 
est              <- all[[2]]  
prob.mix         <- as.vector(est$prob)
mean.mix         <- est$mean 
cov.mix          <- list()

for (g in 1:nG) { 
  cov.mix[[g]] <- make.positive.definite(est$cov[[g]][[1]])
  for (m in 2:nM) cov.mix[[g]] <- rbind(cov.mix[[g]], make.positive.definite(est$cov[[g]][[m]]))
} 

lambda           <- est$lambda 
if (invar==0){
rownames(lambda) <- colnames(y)[1:nZ]
} else if (invar==1){
  for (g in 1:nG){
    rownames(lambda[[g]]) <- colnames(y)[1:nZ]  
  }  
}

eps              <- est$eps 
if (invar==0){
  intercept      <- 0 
}
if (invar==1){
 intercept        <- est$int 
}

# Save estimates along with indexes for estimation of production function 
setwd(dir_outputFM)
save(prob.mix, mean.mix, cov.mix, lambda, eps, intercept, nG, nM, nF, nZ, bsample, file="trueFM.R") 

########################### NON PARAMETRIC METHOD 
} else if (parametric == 0){
  all <- estim.meas.model.nonparametric.group(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,mstep.start, param.start) 
  
  # Save estimates in long format to use as starting values in bootstrap 
  param.start.new  <- all[[1]]
  setwd(dir_outputFM)
  save(param.start.new, file="param_start.R")

  
  # Extract output for drawing factors 
  est              <- all[[2]]  
  mean.mix         <- est$mean 
  cov.mix          <- list()
  
  for (g in 1:nG) { 
    cov.mix[[g]] <- make.positive.definite(est$cov[[g]])
  } 
  
  lambda           <- est$lambda 
  if (invar==0){
    rownames(lambda) <- colnames(y)[1:nZ]
  } else if (invar==1){
    for (g in 1:nG){
      rownames(lambda[[g]]) <- colnames(y)[1:nZ]  
    }  
  }
  
  eps              <- est$eps 
  if (invar==0){
    intercept      <- 0 
  }
  if (invar==1){
    intercept        <- est$int 
  }
  
  # Save estimates along with indexes for estimation of production function 
  setwd(dir_outputFM)
  save(mean.mix, cov.mix, lambda, eps, intercept, nG, nM, nF, nZ, bsample, file="trueFM.R") 
}
  
  
  
  
  
}  


##########################################################
##########################################################
# ON BOOTSTRAP DATA 
##########################################################
##########################################################
if (boot==1){ 
if (parametric==1){
  setwd(dir_outputFM)
  load("param_start.R")
  load("mstep_start.R")
  
  # Define a function that runs the estimation algorithm on each boostrapped sample (b)
  bootfactor   <- function(b){  
    
    # Load bootstrapped dataset 
    setwd(dir_data)
    measures <- call.data(paste("measures_b", (b + (node-1)*bsample), ".csv", sep=""))  
    
    # Specify measurement system 
    setwd(dir_anal)
    source(inputFM)
    
    # Estimate factor model 
    if (invar==0){
      all <- estim.meas.model.group(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,mstep.start.new, param.start.new$par)   
    }else if (invar==1){
      all <- estim.meas.model.group.intercept.invariance(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,invarint, invarload,mstep.start.new, param.start.new$par)            
    }
    
    return(all[[2]])
  } 
  
  # Run the function defined above 
  bootFM <- list()
  for (b in 1:bsample){
    print(b)
    bootFM[[b]] <- try(bootfactor(b))
  }

  
  
}else if (parametric==0){
  setwd(dir_outputFM)
  load("param_start.R")
  
  # Define a function that runs the estimation algorithm on each boostrapped sample (b)
  bootfactor   <- function(b){  
    
    # Load bootstrapped dataset 
    setwd(dir_data)
    measures <- call.data(paste("measures_b", (b + (node-1)*bsample), ".csv", sep=""))  
    
    # Specify measurement system 
    setwd(dir_anal)
    source(inputFM)
    
    # Estimate factor model 
    if (invar==0){
      all <- estim.meas.model.nonparametric.group(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,mstep.start.new, param.start.new$par)   
    }else if (invar==1){
      all <- estim.meas.model.group.intercept.invariance(y, treat, nM, nF, nI, conv, freelambda, freeuniq, freemean,invarint, invarload,mstep.start.new, param.start.new$par)            
    }
  
    return(all[[2]])
  } 
  
  # Run the function defined above 
  bootFM <- list()
  for (b in 1:bsample){
    print(b)
    bootFM[[b]] <- try(bootfactor(b))
  }
  
}

# Save estimates along with indexes for estimation of production function 
setwd(dir_outputFM)
save(bootFM, file=nameBootFM)
}

} 

