#!/bin/bash
#$ -j y
#$ -o logs/$JOB_NAME-$JOB_ID-$TASK_ID.log
#$ -q short.q
#$ -l m_mem_free=1G

# create array of all possible options
tasks=()

# tasks - 5,353 jobs
for bs in {0..100}; do
	tasks+=( "$bs 4 7 0 1 1 1 1" ) #BASE
	tasks+=( "$bs 4 7 1 1 1 1 1" ) #US-EU
	for dc in {1..3}; do
		tasks+=( "$bs 4 7 0 $dc 1 1 1" ) #DISCOUNTING
	done
	for mc in {1..3}; do
		tasks+=( "$bs 4 7 0 1 $mc 1 1" ) #MC ROBUST
	done
	for postmkt in {1..11}; do
		tasks+=( "$bs 4 7 0 1 1 $postmkt 1") #SIGMA A2
	done
	for ptc in {1..3}; do
		for mod in {1..7}; do
			tasks+=( "$bs $mod $ptc 0 1 1 1 1" ) #VARY FC, RHO, SIGQ
		done
	done
	for sigac2 in {1..11}; do
		tasks+=( "$bs 4 4 0 1 1 1 $sigac2" ) #SIGMA AC2 INV
	done
	for des in {5..6}; do
		tasks+=( "$bs 4 $des 0 1 1 1 1" ) #NO DES, NO STENTS
	done
done

# set your variables for THIS task
echo ${tasks[$SGE_TASK_ID-1]} | while read bs mod ptc us dis mc siga2 sigac2; do
    echo "$JOB_NAME bs: $bs mod: $mod paramtochange: $ptc usflag: $us discountflag: $dis mc_rob: $mc siga2: $siga2 sigac2: $sigac2 "

    # pick the job you want based on job name and task
	   echo "step1"
    matlab -nodisplay -r "clear all; cd '~/IntlMedDevMkts/code'; Master_Cfcl_Optimality_b_v3($bs, $mod, $ptc, $us, $dis, $mc, $siga2, $sigac2); exit"
	
done
