* Figures on Age vs. Usage patterns

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"
*capture log close
*log using output/Figures_3and4and5.smcl, replace

********************************************************************
* basics with raw data---EU and US
clear
use data/EUdata_agg
append using data/USdata_agg
gen US=(USeventual==.)
keep if age<=24
replace USeventual=1 if US==1
gen lnd = log(sj/s0)

* and first differences within product
sort US product t
gen lnd_d = lnd-lnd[_n-1]
su lnd_d if age==2 & USeventual==1, detail
su lnd_d if age==12 & USeventual==1, detail
su lnd_d if age==23 & USeventual==1, detail
sort US product t
by US product: gen lnd_diff = abs(lnd-lnd[_n+1])
drop if lnd_diff==. // average over products of same age

quietly tab age, gen(aFE)
su age
forvalues i = 1/`r(max)' { 
	gen aEU_FE`i'=aFE`i'*(1-US) 
	}
forvalues i = 1/`r(max)' { 
	gen aEUtrials_FE`i'=aFE`i'*(1-US)*USeventual 
	}
	
*bysort US product: egen aj_max = max(age)
*drop if aj_max<12

********************************************************************
* raw data plots

bysort age US: egen d_mean = mean(lnd)
bysort age US: egen d_sd = sd(lnd)
gen d_mean_psd = d_mean + d_sd
gen d_mean_msd = d_mean - d_sd
bysort age US: egen d_diff_mean = mean(lnd_diff)

********************************************************************
* use within-product variation
bysort US USeventual: egen group_m = mean(lnd)
bysort US prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m
bysort US USeventual: egen group_m_zeros = mean(zeros)
bysort US prod: egen zeros_m = mean(zeros)
gen zeros_within = zeros-zeros_m+group_m_zeros

bysort age US USeventual: egen d_within_mean = mean(lnd_within)
bysort age US USeventual: egen d_within_sd = sd(lnd_within)
bysort age US USeventual: egen d_diff_within_mean = mean(lnd_diff)
bysort age US USeventual: egen zeros_within_mean = mean(zeros_within)

* fix sd for composition of products---how to do?
bysort US USeventual: egen group_m_sd = mean(d_within_sd)
bysort US prod: egen sd_m = mean(d_within_sd)
gen d_sd_within = d_within_sd-sd_m+group_m_sd
bysort age US USeventual: egen d_sd_within_mean = mean(d_sd_within)

* create one observation per age flag for SD
bysort age US USeventual: gen age_cumsum = sum(age)

* EU vs US, same products, within

twoway (scatter d_within_mean age if age==age_cumsum & US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_within age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	(scatter d_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "US" 6 "EU (US trials)" 9 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("E{sub:j}[ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(-8(1)-3,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMean.pdf, replace 

twoway (scatter d_within_sd age if age==age_cumsum & US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci d_within_sd age if age==age_cumsum & US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	(scatter d_within_sd age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if age==age_cumsum & US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci d_within_sd age if age==age_cumsum & US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "US" 6 "EU (US trials)" 9 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("SD{sub:j}[ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(0(.2)1.2,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsSD.pdf, replace 

twoway (scatter d_diff_within_mean age if age==age_cumsum & US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_diff age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "US" 6 "EU (US trials)" 9 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("E{sub:j}[{&Delta}{sub:t}ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(0(.2).8,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMeanFirstDiff.pdf, replace 

twoway (scatter zeros_within_mean age if age==age_cumsum & US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci zeros_within age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	(scatter zeros_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci zeros_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter zeros_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci zeros_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "US" 6 "EU (US trials)" 9 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("Pr[s{sub:j}=0]", size(large)) ylabel(0(.2)1,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsPr0.pdf, replace 



* regressions for table below
*mean
*fp <age>, scale: reg lnd_within <age> if US==0 & USeventual==1, noconstant cluster(t)
reg lnd_within aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*zeros
reg zeros_within aFE1-aFE23 if US==1, noconstant cluster(t)
lincom aFE23-aFE1
reg zeros_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg zeros_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg zeros_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg zeros_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1





********************************************************************
********************************************************************
* robustness to sample with similar initial quality estimates
preserve
keep if US==0
gen temp1=0
replace temp1=lnd if age==1
bysort product: egen lnd1EU=total(temp1)
drop if lnd1EU==0
drop temp1
bysort USeventual: su lnd if age==1, detail
keep if lnd1EU>-6.2 & lnd1EU<-4.6 //minUS and maxEU
*keep if lnd1EU>-6.83 //p10US
*keep if lnd1EU<-6.56 //p90EU
bysort USeventual: su lnd if age==1, detail

* recompute sample stats
drop d_mean d_sd d_diff_mean group_m lnd_m lnd_within d_within_mean d_within_sd d_diff_within_mean age_cumsum
bysort age USeventual: egen d_mean = mean(lnd)
bysort age USeventual: egen d_sd = sd(lnd)
bysort age USeventual: egen d_diff_mean = mean(lnd_diff)

bysort USeventual: egen group_m = mean(lnd)
bysort prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m

bysort age USeventual: egen d_within_mean = mean(lnd_within)
bysort age USeventual: egen d_within_sd = sd(lnd_within)
bysort age USeventual: egen d_diff_within_mean = mean(lnd_diff)

* create one observation per age flag for SD
bysort age USeventual: gen age_cumsum = sum(age)

* EU: Trials vs Not, within --- overlapping sample only

twoway (scatter d_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (US trials)" 6 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("E{sub:j}[ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(-8(1)-3,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMean_age1matched.pdf, replace 

twoway (scatter d_within_sd age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if age==age_cumsum & US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci d_within_sd age if age==age_cumsum & US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (US trials)" 6 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("SD{sub:j}[ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(0(.2)1.2,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsSD_age1matched.pdf, replace 

twoway (scatter d_diff_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (US trials)" 6 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("E{sub:j}[{&Delta}{sub:t}ln(s{sub:j}/s{sub:0})]", size(large)) ylabel(0(.2).8,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMeanFirstDiff_age1matched.pdf, replace 

twoway (scatter zeros_within_mean age if age==age_cumsum & US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci zeros_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter zeros_within_mean age if age==age_cumsum & US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci zeros_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (US trials)" 6 "EU (not)") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("Pr[s{sub:j}=0]", size(large)) ylabel(0(.2)1,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsPr0_age1matched.pdf, replace 



* regressions for table below
*mean
reg lnd_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg lnd_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg d_within_sd aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg lnd_diff aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
*zeros
reg zeros_within aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg zeros_within aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
reg zeros_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1
reg zeros_within aFE1-aFE23 aEUtrials_FE1-aEUtrials_FE23 if US==0, noconstant cluster(t)
lincom aEUtrials_FE23-aEUtrials_FE1

restore
********************************************************************





********************************************************************

log close
