* summarize clinical trials data

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"

********************************************************************
* merge data sets

* product entry dates collapse and clean
clear
use data/EUdata_agg
append using data/USdata_agg
keep manufacturer product t j tj enterEU age USeventual enterUS
gen age_enterEU = age if t==enterEU
gen age_enterUS = age if t==enterUS
collapse (min) j enterEU enterUS USeventual age_enterEU age_enterUS, by(manufacturer product)
replace age_enterEU = 1 if age_enterEU==. & enterEU~=.
replace age_enterUS = 1 if age_enterUS==. & enterUS~=.
gen EUentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterEU - age_enterEU)
gen USentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterUS - age_enterUS)
format EUentryDate USentryDate %td
* merge clinical trial data
sort manufacturer product
merge 1:m manufacturer product using "data/ClinicalTrialData", keep(match) nogen
sort j
tempfile temp1    
save "`temp1'"      
* merge Qj from demand estimates
insheet b j Qj Qj1 using "temp/Parameters_QjFE_0.csv", clear
drop b
rename qj Qj
rename qj1 Qj1
sort j
merge 1:m j using "`temp1'" , keep(match) nogen
*


********************************************************************
* summary of trials completed by EU and US approval

sort manufacturer product date
gen preEU = (date<EUentryDate)
gen preUS = (date<USentryDate)

preserve
collapse (max) NpTreatment FollowUp Tfu PrimaryFU , by(manufacturer product Trial preEU preUS)
collapse (sum) NpTreatment PrimaryFU (mean) FollowUp Tfu (count) Trials=NpTreatment , by(manufacturer product preEU preUS)
collapse Trials NpTreatment PrimaryFU FollowUp Tfu (count) N=NpTreatment , by(preEU preUS)
export excel "output/ClinicalTrials_sum.xlsx", firstrow(variables) replace
restore


********************************************************************
* figure Qj vs. Trial outcomes
drop if j==131

rename Qj Qj_preUS
rename Qj1 Qj_preEU
tab Tfu, gen(fuFE)
gen Tfu2=Tfu^2
*
foreach outcome in MACE_V MACE_L TVR TLR LL {
replace `outcome' = log(`outcome')
egen `outcome'_mean = mean(`outcome')
/*
areg `outcome' Tfu, a(j)
predict `outcome'_d, d
replace `outcome' = exp(`outcome'_d+`outcome'_mean)
*/
reg `outcome' fuFE1-fuFE4 fuFE6-fuFE9
predict `outcome'_r, r
replace `outcome' = exp(`outcome'_r+_b[_cons])
/*
reg `outcome' Tfu Tfu2
predict `outcome'_r, r
replace `outcome' = exp(`outcome'_r+_b[_cons]+(_b[Tfu]+_b[Tfu2])*12)
*/
*
foreach var in preEU preUS {
preserve
keep if `var'==1
collapse Qj_`var' MACE_V MACE_L TVR TLR LL (max) NpTreatment FollowUp Tfu PrimaryFU , by(manufacturer product Trial)
collapse Qj_`var' MACE_V MACE_L TVR TLR LL FollowUp Tfu (sum) NpTreatment PrimaryFU (count) Trials=NpTreatment , by(manufacturer product)
*
replace Qj_`var' = 4744*log(1+exp(Qj_`var')) //* (1+exp(Qj_`var'))/exp(Qj_`var')
*
reg Qj_`var' `outcome'
twoway (lfitci Qj_`var' `outcome', lcolor(navy) ciplot(rline) blcolor(navy) blpattern(-)) (scatter Qj_`var' `outcome', mcolor(navy) msymbol(Oh)) ///
	, legend(off) graphregion(color(white)) ///
	ytitle("Estimated ATE(Qj_`var') ($)") ///
	xtitle("`outcome' rate from Clinical Trial Data") 
graph export "output/fig_Qj_`var'_`outcome'.pdf", replace 
restore
}
}








