version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global table_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Tables" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;



global strformat "%8.3f";
global strformat_2 "%8.1f";
global strformat_3 "%8.2f";

capture program drop sig_p;
program sig_p;
   args obj_var point_est_var point_sd_var p_val row_id_var row_num;
   local point_est `point_est_var';
   local point_sd `point_sd_var';
   if `p_val' > 0.1 {;
      replace `obj_var' = string(`point_est', "$strformat")+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.05 & `p_val' <= 0.1  {;
      replace `obj_var' = string(`point_est', "$strformat")+"*"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' > 0.01 & `p_val' <= 0.05  {;
      replace `obj_var' = string(`point_est', "$strformat")+"**"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   if `p_val' <= 0.01 {;
      replace `obj_var' = string(`point_est', "$strformat")+"***"+" [" + string(`point_sd', "$strformat") + "]" if `row_id_var' == `row_num';
      };
   end;


   
foreach var of varlist 
	hh_head_literate hh_head_age total_land_inherited caste_non_marginal {;
	
	gen cm_`var' = `var';
	replace cm_`var' = 0 if `var' == .;
	
	gen msng_`var' = (`var' == .);
	
};


global hh_head_controls 
	"cm_hh_head_literate cm_hh_head_age cm_total_land_inherited cm_caste_non_marginal
	msng_hh_head_literate msng_hh_head_age msng_total_land_inherited msng_caste_non_marginal"; 
   
   

generate row_num = _n;


local row = 4;
forvalues i=0(1)25 {;
	generate col`i' = "";
};

order col*;
sort row_num;


foreach var of varlist 
	hh_head_hindu caste_non_marginal hh_head_male hh_head_age hh_head_literate 
	hh_head_edu_none hh_head_edu_prmry hh_head_edu_middle hh_head_edu_scndry {;

	replace col0 = "`var'" if row_num == `row';
	
	reghdfe bw_total_drilled `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col2 _b[`var'] _se[`var'] r(p) row_num `row';

	
	reghdfe ln_first_bw_depth `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col4 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe ln_first_bw_cost `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col5 _b[`var'] _se[`var'] r(p) row_num `row';
		
	reghdfe first_bw_flow `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col6 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe first_bw_immfailed `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col7 _b[`var'] _se[`var'] r(p) row_num `row';


	
	local row = `row' + 2;
	
};


local row = `row' + 1;


foreach var of varlist 
	num_children_6_11 num_children_12_18 num_hh_mem_adult_sons {;

	replace col0 = "`var'" if row_num == `row';
	
	reghdfe bw_total_drilled `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col2 _b[`var'] _se[`var'] r(p) row_num `row';

	
	reghdfe ln_first_bw_depth `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col4 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe ln_first_bw_cost `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col5 _b[`var'] _se[`var'] r(p) row_num `row';
		
	reghdfe first_bw_flow `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col6 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe first_bw_immfailed `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col7 _b[`var'] _se[`var'] r(p) row_num `row';


	
	local row = `row' + 2;
	
};


local row = `row' + 1;

foreach var of varlist 
	pre_1stBW_asset_* total_land_inherited {;

	replace col0 = "`var'" if row_num == `row';
	
	reghdfe bw_total_drilled `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col2 _b[`var'] _se[`var'] r(p) row_num `row';

	
	reghdfe ln_first_bw_depth `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col4 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe ln_first_bw_cost `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col5 _b[`var'] _se[`var'] r(p) row_num `row';
		
	reghdfe first_bw_flow `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col6 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe first_bw_immfailed `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col7 _b[`var'] _se[`var'] r(p) row_num `row';

	
	local row = `row' + 2;
	
};	

local row = `row' + 1;

foreach var of varlist 
	pre_1stBW_cashcrops_grown
	pre_1stBW_any_irrigation {;

	replace col0 = "`var'" if row_num == `row';
	
	reghdfe bw_total_drilled `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col2 _b[`var'] _se[`var'] r(p) row_num `row';

	
	reghdfe ln_first_bw_depth `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col4 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe ln_first_bw_cost `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col5 _b[`var'] _se[`var'] r(p) row_num `row';
		
	reghdfe first_bw_flow `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col6 _b[`var'] _se[`var'] r(p) row_num `row';

	reghdfe first_bw_immfailed `var' 
		if bw_never ~= 1 & household_level == 1 [pw=hh_weight_norm], absorb(villcode first_bw_ydrilled)  cluster(villcode);
	test `var';
	sig_p col7 _b[`var'] _se[`var'] r(p) row_num `row';


	
	local row = `row' + 2;
	
};



order col0-col25;
sort row_num;
outsheet col0-col7 using "$table_dir/_TableA1 balance by borewell characteristics (AER).csv" if
	row_num < `row', comma replace;
