version 14
#delimit;
set more off;


global data_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study" //put your directory here;
global figure_dir "/Users/davidsblakeslee/Dropbox/Karnataka Water Depletion Study/Figures" // put your directory here;


use "$data_dir/final_data_AER.dta", clear;




	
graph twoway
	(connected disag_pnl_bw_any_operational years_post_failure_v 
		if first_bw_failed == 0 & (years_post_failure_v <= 8 & years_post_failure_v >= -10), sort msize(small) msymbol(circle_hollow))
	(connected disag_pnl_bw_any_operational years_post_failure_v 
		if first_bw_failed == 1 & (years_post_failure_v <= 8 & years_post_failure_v >= -10), sort msize(small) msymbol(diamond)),
	scheme(s2mono)
	bgcolor(white) graphregion(color(white))
	legend(order(1 "first bw operational" 2 "first bw failed"))
	xline(0)
	xscale(range(-10 8))
	xlabel(-10(2)8)
	xtitle("years since first BW failed")
	ytitle("any borewell operational");	
capture: graph save Graph "$figure_dir/_Figure4_operational_borewell.gph", replace;
graph export "$figure_dir/_Figure4_operational_borewell.pdf", replace;	






