load Estim_uvs_calib_results
load uvymassqu_data

qv_mod_LL = oo_.SmoothedVariables.Median.qv;
qu_mod_LL = oo_.SmoothedVariables.Median.m-oo_.SmoothedVariables.Median.UR;
alpha = 0.5;
qv_mod_std=alpha*(UR_obs(1:end-1)-v_obs(1:end-1));
qu_mod_std = (1-alpha)*(v_obs(1:end-1)-UR_obs(1:end-1));
a_mod_LL = oo_.SmoothedVariables.Median.a;
m_mod_LL = oo_.SmoothedVariables.Median.m;
s_mod_LL = oo_.SmoothedVariables.Median.s;
m_mod_std = alpha*(UR_obs(1:end-1))+(1-alpha)*v_obs(1:end-1);
qv_mod_std_s = alpha*(UR_obs(1:end-1)+s_alt_obs(1:end-1)-v_obs(1:end-1));
qu_mod_std_s = (1-alpha)*(v_obs(1:end-1)-UR_obs(1:end-1)-s_alt_obs(1:end-1));
m_mod_std_s = alpha*(s_alt_obs(1:end-1)+UR_obs(1:end-1))+(1-alpha)*v_obs(1:end-1);

qv_obs = m_obs(1:end-1) - v_obs(1:end-1);  % JOLTS starts from Dec 2000
qu_obs = m_obs(1:end-1) - UR_obs(1:end-1);

% Correlations:
corr_am = corr(a_mod_LL(402:end), m_mod_LL(402:end));
disp(' ');
disp({'Correlations: recruiting intensity and hiring'});
disp({'Data', 'Model'});
disp([0.82, corr_am]);


dates=1967+7/12:1/12:2017+7/12;  % sample from July 1967 to July 2017

% Plot job filling rate and job finding rate

qv_obs = qv_obs-qv_obs(402);  % normalized by Dec 2000 observation, start of JOLTS
m_obs = m_obs-m_obs(402);
s_obs = s_alt_obs-s_alt_obs(402);
qv_mod_std = qv_mod_std-qv_mod_std(402);
m_mod_std = m_mod_std-m_mod_std(402);

qv_mod_std_s = qv_mod_std_s-qv_mod_std_s(402);
m_mod_std_s = m_mod_std_s-m_mod_std_s(402);

qv_mod_LL = qv_mod_LL-qv_mod_LL(402);
m_mod_LL = m_mod_LL - m_mod_LL(402);


RMSE_qv_LL = sqrt(mean((qv_mod_LL(402:end)-qv_obs(402:end))).^2);
RMSE_qv_std = sqrt(mean((qv_mod_std(402:end)-qv_obs(402:end))).^2);
RMSE_qv_std_s = sqrt(mean((qv_mod_std_s(402:end)-qv_obs(402:end))).^2);

disp(' ');
disp('RMSE for job filling rate')
disp({'Standard model', 'Std model with s', 'Benchmark model'})
disp([RMSE_qv_std, RMSE_qv_std_s, RMSE_qv_LL])

dates_short = dates(402:end);

figure;
plot(dates_short, qv_obs(402:end), '-b', dates_short, qv_mod_std(402:end), '--r',dates_short, qv_mod_LL(402:end), '-.m')
legend('Data', 'Standard model', 'Benchmark model');
title('Job filling rate')
print -dpdf outfig_qv_uvs_calib_short.pdf


figure;
plot(dates, qv_obs, '-b', dates, qv_mod_std, '--r',dates, qv_mod_LL, '-.m')
legend('Data', 'Standard model', 'Benchmark model');
title('Job filling rate')
print -dpdf outfig_qv_uvs_calib_long.pdf

