// dynare code for estimating the DSGE model in Leduc and Liu: "The Slow Job Recovery in a Macro Model with Search and Recruiting Intensity" (2016)


//--- Declare variables: 21 endogenous variables, 4 exogenous variables, and 4 innovations
var C, r, Y, m, u, v, qu, qv, N, UR, JF, w, Lambda, wNash, vu, ne, a, s, Omega, JV, qUR,
Z, theta, delta;
varexo ez, etheta, edelta; 


parameters beta, phi, alpha, rho_o, kappa0, kappa1, kappa2, h1, h2, K, b, gamma, xi,
sep, Css, rss, Yss, mss, uss, vss, quss, qvss, Nss, URss, JFss, wss, Lambdass, ness, ass, sss, JVss, 
Zbar, mubar, chibar, deltabar, 
rho_z, rho_theta, rho_delta, stderr_ez, stderr_etheta, stderr_edelta; 


//--- Parameter values (10 structural parameters, 25 shock parameters)
beta = 0.99^(1/3);  //subjective discount factor
phi = 0.25;   //flow unemployment benefit
alpha = 0.5;  //elasticity of matching with respect to u
b = 0.5;      //bargaining weight
gamma= 0.95;   //Sticky wage parameter
xi = 1;  //curvature parameter for vacancy creation cost function
Zbar = 1;       //mean value of technology shock

K = 3.8888;      //vacancy creation cost 
//kappa2 = 5.8751;      //curvature of job advertising cost function
//h2 = 0.9928;          //curvature of search cost function
kappa2=0;
h2=0;

rho_z = 0.9953;    //persistence of technology shock
rho_theta = 0.9932;	//persistence of discount factor shock
rho_delta = 0.8360;     //persistence of separation shock
stderr_ez= 0.0182;
stderr_etheta = 0.0302;
stderr_edelta =0.1865;

//-- Steady-state values
rss = 1/beta;  
URss = 0.055;  //unemployment rate 
qvss = 0.6415; //vacancy filling rate, based on Davis et al. (2013)
Nss = 1-URss;
sep = 0.034;   //steady-state job separation rate (from JOLTS)
mss = Nss*sep;
uss = URss+mss;
vss = mss/qvss;
quss = mss/uss;
ne_N = 0.02;  
ness = ne_N*Nss;
rho_o = (sep*Nss/vss+ness/vss-qvss)/((1-qvss)+Nss/vss);
deltabar = (sep-rho_o)/(1-rho_o);
JVss = K*ness^(1/xi);
Yss = Zbar*Nss;
kappa0voY=0.01; //0.02;
kappa0 = kappa0voY*Yss/vss;
Css = Yss*(1-kappa0voY-(xi/(1+xi))*ness*JVss/Yss);
Lambdass = 1/Css;
JFss = kappa0/qvss +(1-beta*(1-qvss)*(1-rho_o))*JVss/qvss;
ass =1; 
sss = 1;
mubar = mss/((sss*uss)^alpha*(ass*vss)^(1-alpha));
kappa1=qvss*(JFss-beta*(1-rho_o)*JVss)/ass;
h1 = quss*(b/(1-b))*(JFss-JVss)/sss;
wss = Zbar-(1-beta*(1-deltabar)*(1-rho_o))*JFss+beta*deltabar*(1-rho_o)*JVss; 
chibar = Lambdass*(wss-phi-(b/(1-b))*((1-beta*(1-deltabar)*(1-rho_o)*(1-quss))*(JFss-JVss)));




//-----------------------------------------------------------------------------------------------------------------------------------------------
model;

//Eq (1): Household bond Euler equation:
1=exp(theta(+1)+Lambda(+1)-Lambda+r);

//Eq (2): Marginal utility
Lambda=-C;

//Eq (3): Search intensity
//h1+h2*sss*(exp(s)-1) = (quss*exp(qu)/sss*exp(s))*((b/(1-b))*(JFss*exp(JF)-JVss*exp(JV))+wss*(exp(w)-exp(wNash))-
//(h1*sss*(exp(s)-1)+(h2*sss^2/2)*(exp(s)-1)^2)/(1-quss*exp(qu)));
s=0;

//Eq (4): Matching function
m = alpha*(s+u)+(1-alpha)*(a+v);

//Eq (5): Job finding rate
qu = m-u;

//Eq (6): Vacancy filling rate
qv = m-v;


//Eq (7): Employment dynamics
exp(N)=(1-rho_o)*(1-deltabar*exp(delta))*exp(N(-1))+(mss/Nss)*exp(m);

//Eq (8): Searching workers
uss*exp(u) = 1-(1-rho_o)*(1-deltabar*exp(delta))*Nss*exp(N(-1));
//uss*exp(u) = URss*exp(UR)-mss*exp(m);

//Eq (9): Unemployment rate
URss*exp(UR) = 1-Nss*exp(N);

//Eq (10): Vacancies
//vss*exp(v) = (1-rho_o)*(1-qvss*exp(qv(-1)))*vss*exp(v(-1)) + deltabar*exp(delta)*(1-rho_o)*Nss*exp(N(-1))+ness*exp(ne);
ne=0;

//Eq (11): Aggregate production function
Y = Z+N;

//Eq (12): Resource constraint
(Css/Yss)*exp(C-Y) +((h1*sss*(exp(s)-1)+(h2*sss^2/2)*(exp(s)-1)^2)*(uss/Yss))*exp(u-Y)+(kappa0+kappa1*ass*(exp(a)-1)+(kappa2*ass^2/2)*(exp(a)-1)^2)*(vss/Yss)*exp(v-Y) + (xi/(1+xi))*(JVss*ness/Yss)*exp(ne+JV-Y) =1;

//Eq (13): Value of vacancy:
JVss*exp(JV) = -(kappa0+kappa1*ass*(exp(a)-1)+(kappa2*ass^2/2)*(exp(a)-1)^2)+qvss*JFss*exp(qv+JF)+(1-qvss*exp(qv))*(1-rho_o)*beta*JVss*exp(theta(+1)+Lambda(+1)-Lambda+JV(+1));

//Eq (14): Recruiting intensity
//kappa1+kappa2*ass*(exp(a)-1) = (qvss/ass)*exp(qv-a)*(JFss*exp(JF)-(1-rho_o)*beta*JVss*exp(theta(+1)+Lambda(+1)-Lambda+JV(+1)));
a=0;


//Eq (15): Match value
JFss*exp(JF)=Zbar*exp(Z)-wss*exp(w)+
beta*exp(theta(+1)+Lambda(+1)-Lambda)*(1-rho_o)*((1-deltabar*exp(delta(+1)))*JFss*exp(JF(+1))+
deltabar*exp(delta(+1))*JVss*exp(JV(+1)));

//Eq (16): Nash bargaining wage
(b/(1-b))*(JFss*exp(JF)-JVss*exp(JV)) = wss*exp(wNash)-phi-(chibar/Lambdass)*exp(-Lambda)+ (h1*sss*(exp(s)-1)+(h2*sss^2/2)*(exp(s)-1)^2)/(1-quss*exp(qu))+
beta*(1-rho_o)*exp(theta(+1)+Lambda(+1)-Lambda)*(1-deltabar*exp(delta(+1)))*(1-quss*exp(qu(+1)))*(b/(1-b))*
(JFss*exp(JF(+1))-JVss*exp(JV(+1)));

//Eq (17): actual wage (sticky wage)
w = gamma*w(-1) + (1-gamma)*wNash;

//Eq (18): labor market tightness (v-u ratio)
vu = v-u;

//Eq (19): Beveridge curve shifter (Omega)
Omega = -(alpha*s+(1-alpha)*a);

//Eq (20): JV
//ne = xi*JV;
JV=0;

//Eq (21): qUR
qUR = m-UR;

//---Shocks

// Technology shock
Z = rho_z*Z(-1) + ez;

// discount factor shock
theta = rho_theta*theta(-1)+etheta;

// separation shock
delta = rho_delta*delta(-1) + edelta;


end;

//-----------------------------------------------------------------------------------------------------------------------------------------------


shocks;
var ez; stderr stderr_ez;
var etheta; stderr stderr_etheta;
var edelta; stderr stderr_edelta;
end;

steady;
check;


stoch_simul(order=1,nograph,irf=24,conditional_variance_decomposition =[12 24 36 48]);
