set scheme s1color
set more off
global directory /path
capture log close
log using $directory/create5pct053112.log, replace


use $directory/old_newf20pct, clear

gen eSuperID = ""
forvalues e = 1/10{
replace eSuperID = eSuperID + sein`e'
}

sort pik year

by pik: gen changeEmployer = eSuperID != eSuperID[_n+1]

by pik: replace changeEmployer=. if eSuperID[_n+1]==""

by pik: gen dEarnings = (yearlyEarnings[_n+1]-yearlyEarnings)/yearlyEarnings

egen emps = rowtotal(eTag)
by pik: gen dEmps = emps[_n+1]-emps
by pik: gen sample = (_n!=_N)&(year==year[_n+1]-1)

list pik sein* year changeEmployer dEmps emps eSuperID sample in 1/5

keep if sample&real_distance>=-10000&real_distance<=10000

gen dEmpsSD = dEmps
gen changeEmployerSD = changeEmployer
gen count =1

save $directory/temp, replace
use $directory/temp, clear


#delimit cr
display 5
capture gen realDistanceRound = round(real_distance, 500)
capture replace realDistanceRound = round(real_distance, 500)


gen dEarningsSD=dEarnings



collapse (mean) dEarnings (sd) dEarningsSD (sum) count, by(age realDistanceRound)


gen dEarningsLower = dEarnings - 1.96*dEarningsSD/sqrt(count)
gen dEarningsUpper = dEarnings + 1.96*dEarningsSD/sqrt(count)

sum dEarningsUpper if age==69
local max = ceil(r(max)*100)/100
sum dEarningsLower if age==69
local min = min(floor(r(min)*100)/100, 0)
local step = floor(100*(`max'/3))/100


#delimit;

twoway
(line dEarnings realDistanceRound if age == 69, sort lcolor(navy))    
(line dEarningsUpper realDistanceRound if age==69, sort lcolor(cranberry) lpattern(dash)) 
(line dEarningsLower realDistanceRound if age==69, sort lcolor(cranberry) lpattern(dash)), 
legend(off) 
title("Expected % Change in Earnings from Age 69 to Age 70") 
xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10") 
xtitle("Earnings at age 69") 
ylabel(`min'(`step')`max') ;



graph export $directory/dEarnings_69_9098_lehd_`bw'new.eps, replace fontface(Times-Roman) orientation(landscape);
graph save $directory/dEarnings_69_9098_lehd_`bw'new.gph, replace;




use $directory/old_newf20pct, clear

gen eSuperID = ""
forvalues e = 1/10{
replace eSuperID = eSuperID + sein`e'
}

sort pik year

by pik: gen changeEmployer = eSuperID != eSuperID[_n+1]

by pik: replace changeEmployer=. if eSuperID[_n+1]==""

by pik: gen dEarnings = (yearlyEarnings[_n+1]-yearlyEarnings)/yearlyEarnings

egen emps = rowtotal(eTag)
by pik: gen dEmps = emps[_n+1]-emps
by pik: gen sample = (_n!=_N)&(year==year[_n+1]-1)

list pik sein* year changeEmployer dEmps emps eSuperID sample in 1/5

keep if sample&real_distance>=-10000&real_distance<=10000

gen dEmpsSD = dEmps
gen changeEmployerSD = changeEmployer
gen count =1

save $directory/temp, replace
use $directory/temp, clear


#delimit cr
display 5
capture gen realDistanceRound = round(real_distance, 500)
capture replace realDistanceRound = round(real_distance, 500)


gen dEarningsSD=dEarnings



collapse (mean) dEarnings (sd) dEarningsSD (sum) count, by(age realDistanceRound)


gen dEarningsLower = dEarnings - 1.96*dEarningsSD/sqrt(count)
gen dEarningsUpper = dEarnings + 1.96*dEarningsSD/sqrt(count)

sum dEarningsUpper if age==70
local max = ceil(r(max)*100)/100
sum dEarningsLower if age==70
local min = min(floor(r(min)*100)/100, 0)
local step = floor(100*(`max'/3))/100


#delimit;

twoway
(line dEarnings realDistanceRound if age == 70, sort lcolor(navy))    
(line dEarningsUpper realDistanceRound if age==70, sort lcolor(cranberry) lpattern(dash)) 
(line dEarningsLower realDistanceRound if age==70, sort lcolor(cranberry) lpattern(dash)), 
legend(off) 
title("Expected % Change in Earnings from Age 70 to Age 71") 
xlabel(-10000 "-10" -5000 "-5" 0 "0" 5000 "5" 10000 "10") 
xtitle("Earnings at age 69") 
ylabel(`min'(`step')`max') ;



graph export $directory/dEarnings_70_9098_lehd_`bw'new.eps, replace fontface(Times-Roman) orientation(landscape);
graph save $directory/dEarnings_70_9098_lehd_`bw'new.gph, replace;


log close     

