%% f_gmm_inert
%
% compute GMM obj for the bunching problem.
% 

function r_obj = calcGmmNoAC(params, data, wMat)
    
    % pull out parameters
    e = params(1);
    
    % find highest person to bunch, pre-period
    upperZ = data.zStar.*( (1-data.t0)./(1-data.t1) ).^e;
    
    % find simulated bunching
    bSim = calcBFromZ(data.zStar, upperZ,data);
    
    % calculate objective as weighted inner product
    r_obj = 1/length(data.bunch)*(bSim - data.bunch)'*wMat*(bSim-data.bunch);
    
    
end