********************
*** Tables 5 & 6 ***
********************

set more off

* 1. Separate regressions [columns 1-7]

foreach v in NPE_portfolio nonnpe NPE_litigated litigated_v2 {

foreach x in pcwordcount pcindepclaim accept ///
 r101 r102 r103 r112b {

cd "$db\Examiner Effect Juristat"
use examiner_effect_dataset_v2, clear
* keep IT patents only (units highlighted by Simcoe)
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369 

* compute baseline rate in restricted sample
sum `v', d
gen `v'_baseline=r(mean)

* bring in leave-one-out examiner effects
merge 1:1 application using `x'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)
bysort examiner_id: gen grantn=[_N]

* bring in corresponding signal SD 
merge m:1 examiner using `x'_examiner_effect, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

* standardized coeffs
gen loo_shrunk_examiner_effect_sd=loo_shrunk_examiner_effect/x_signal_sd*`v'_baseline

* weighted regression
clear matrix
areg `v' loo_shrunk_examiner_effect_sd [aw=grantn], absorb(year_artunit) cluster(examiner_id)
matrix b=e(b) 
gen coeff_sd_w=b[1,1]
matrix v=e(V) 
gen se_sd_w=sqrt(v[1,1])
gen t_sd_w=coeff_sd_w/se_sd_w
gen N_sd_w=e(N)

* now save to tables 
cd "$db\Final Tables\"

if "`v'"=="NPE_portfolio" local table "Table4_PanelA"
if "`v'"=="nonnpe" local table "Table4_PanelB"
if "`v'"=="NPE_litigated" local table "Table5_PanelA"
if "`v'"=="litigated_v2" local table "Table5_PanelB"

if "`x'"=="pcwordcount" local coeff "B4"
if "`x'"=="pcwordcount" local se "B5"
if "`x'"=="pcwordcount" local N "B18"
if "`x'"=="pcwordcount" local t "B4"

if "`x'"=="pcindepclaim" local coeff "C6"
if "`x'"=="pcindepclaim" local se "C7"
if "`x'"=="pcindepclaim" local N "C18"
if "`x'"=="pcindepclaim" local t "C6"

if "`x'"=="accept" local coeff "D8"
if "`x'"=="accept" local se "D9"
if "`x'"=="accept" local N "D18"
if "`x'"=="accept" local t "D8"

if "`x'"=="r101" local coeff "E10"
if "`x'"=="r101" local se "E11"
if "`x'"=="r101" local N "E18"
if "`x'"=="r101" local t "E10"

if "`x'"=="r102" local coeff "F12"
if "`x'"=="r102" local se "F13"
if "`x'"=="r102" local N "F18"
if "`x'"=="r102" local t "F12"

if "`x'"=="r103" local coeff "G14"
if "`x'"=="r103" local se "G15"
if "`x'"=="r103" local N "G18"
if "`x'"=="r103" local t "G14"

if "`x'"=="r112b" local coeff "H16"
if "`x'"=="r112b" local se "H17"
if "`x'"=="r112b" local N "H18"
if "`x'"=="r112b" local t "H16"

putexcel set IT_PAE_tables_juristat, sheet("`table'") modify
putexcel `coeff'=coeff_sd_w 
putexcel `se'=se_sd_w
putexcel `N'=N_sd_w

** save t statistics 
putexcel set IT_PAE_tables_juristat_t, sheet("`table'") modify
putexcel `t'=t_sd_w
}

* also run regression on "own" coefficient 
use examiner_effect_dataset_v2, clear
* keep IT patents only (units highlighted by Simcoe)
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369 


* compute baseline rate in restricted sample
sum `v', d
gen `v'_baseline=r(mean)

* bring in leave-one-out examiner effects
merge 1:1 application using `v'_effect_loo
keep if _merge==3
drop _merge
egen examiner_id=group(examiner)
bysort examiner_id: gen grantn=[_N]

* bring in corresponding signal SD 
merge m:1 examiner using `v'_examiner_effect, keepusing(x_signal_sd)
keep if _merge==3
drop _merge

* standardized coeffs
gen loo_shrunk_examiner_effect_sd=loo_shrunk_examiner_effect/x_signal_sd*`v'_baseline

* weighted regression
clear matrix
areg `v' loo_shrunk_examiner_effect_sd [aw=grantn], absorb(year_artunit) cluster(examiner_id)
matrix b=e(b) 
gen coeff_sd_w=b[1,1]
matrix v=e(V) 
gen se_sd_w=sqrt(v[1,1])
gen t_sd_w=coeff_sd_w/se_sd_w
gen N_sd_w=e(N)

* now save to tables 
cd "$db\Final Tables\"

if "`v'"=="NPE_portfolio" local table "Table4_PanelA"
if "`v'"=="nonnpe" local table "Table4_PanelB"
if "`v'"=="NPE_litigated" local table "Table5_PanelA"
if "`v'"=="litigated_v2" local table "Table5_PanelB"

local coeff "B21"
local se "B22"
local t "B23"
local N "B24"

putexcel set IT_PAE_tables_juristat, sheet("`table'") modify
putexcel `coeff'=coeff_sd_w 
putexcel `se'=se_sd_w
putexcel `t'=t_sd_w
putexcel `N'=N_sd_w

}



* 2. Horse race based on blocking actions [column 8]
* we run this only with the standardized variable and the weights

foreach v in NPE_portfolio nonnpe NPE_litigated litigated_v2 {

cd "$db\Examiner Effect Juristat"
use examiner_effect_dataset_v2, clear
* keep IT patents only (units highlighted by Simcoe)
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369 


* compute baseline rate in restricted sample
sum `v', d
gen `v'_baseline=r(mean)

foreach x in r101 r102 r103 r112b {

		merge 1:1 application using `x'_effect_loo
		rename loo_shrunk_examiner_effect loo_shrunk_`x'_effect
		keep if _merge==3
		drop _merge
		
		* bring in corresponding signal SD 
		merge m:1 examiner using `x'_examiner_effect, keepusing(x_signal_sd)
		keep if _merge==3
		drop _merge
		
		* gen standardized variable
		gen loo_shrunk_`x'_effect_sd=loo_shrunk_`x'_effect/x_signal_sd*`v'_baseline
		drop x_signal_sd	
	}
	
egen examiner_id=group(examiner)
bysort examiner_id: gen grantn=[_N]

cd "$db\Patent outcomes and examiner behavior"

* standardized and weighted 
eststo: quietly areg `v' loo_shrunk_r101_effect_sd loo_shrunk_r102_effect_sd loo_shrunk_r103_effect_sd loo_shrunk_r112b_effect_sd [aw=grantn], absorb(year_artunit) cluster(examiner_id)
esttab using `v'_horserace1_sd_w_juristat.csv, con r2 se label replace keep(loo_shrunk_r101_effect_sd loo_shrunk_r102_effect_sd loo_shrunk_r103_effect_sd loo_shrunk_r112b_effect_sd)
eststo clear

* store coefficients in table 
cd "$db\Final Tables\"

matrix b=e(b) 
gen coeff_101=b[1,1]
gen coeff_102=b[1,2]
gen coeff_103=b[1,3]
gen coeff_112=b[1,4]

matrix v=e(V) 
gen se_101=sqrt(v[1,1])
gen se_102=sqrt(v[2,2])
gen se_103=sqrt(v[3,3])
gen se_112=sqrt(v[4,4])

matrix table=r(table)
gen t_101=coeff_101/se_101
gen t_102=coeff_102/se_102
gen t_103=coeff_103/se_103
gen t_112=coeff_112/se_112

gen N_sd_w=e(N)

if "`v'"=="NPE_portfolio" local table "Table4_PanelA"
if "`v'"=="nonnpe" local table "Table4_PanelB"
if "`v'"=="NPE_litigated" local table "Table5_PanelA"
if "`v'"=="litigated_v2" local table "Table5_PanelB"

* store everything but t stats
putexcel set IT_PAE_tables_juristat, sheet("`table'") modify
putexcel I10=coeff_101
putexcel I11=se_101
putexcel I12=coeff_102
putexcel I13=se_102
putexcel I14=coeff_103
putexcel I15=se_103
putexcel I16=coeff_112
putexcel I17=se_112
putexcel I18=N_sd_w
* store t stats
putexcel set IT_PAE_tables_juristat_t, sheet("`table'") modify
putexcel I10=t_101
putexcel I12=t_102
putexcel I14=t_103
putexcel I16=t_112
}

* 3. Horse race using all variables [column 9]
foreach v in NPE_portfolio nonnpe NPE_litigated litigated_v2 {

cd "$db\Examiner Effect Juristat"
use examiner_effect_dataset_v2, clear
* keep IT patents only (units highlighted by Simcoe)
gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369 


* compute baseline rate in restricted sample
sum `v', d
gen `v'_baseline=r(mean)

foreach x in pcwordcount pcindepclaim accept ///
 r101 r102 r103 r112a r112b {

		merge 1:1 application using `x'_effect_loo
		rename loo_shrunk_examiner_effect loo_shrunk_`x'_effect
		keep if _merge==3
		drop _merge
		
		* bring in corresponding signal SD 
		merge m:1 examiner using `x'_examiner_effect, keepusing(x_signal_sd)
		keep if _merge==3
		drop _merge
		
		* gen standardized variable
		gen loo_shrunk_`x'_sd=loo_shrunk_`x'_effect/x_signal_sd*`v'_baseline
		drop x_signal_sd	
	}
	
egen examiner_id=group(examiner)
bysort examiner_id: gen grantn=[_N]

cd "$db\Patent outcomes and examiner behavior"
* standardized and weighted 
eststo: quietly areg `v' loo_shrunk_pcwordcount_sd loo_shrunk_pcindepclaim_sd loo_shrunk_accept_sd loo_shrunk_r101_sd loo_shrunk_r102_sd loo_shrunk_r103_sd loo_shrunk_r112b_sd [aw=grantn], absorb(year_artunit) cluster(examiner_id)
esttab using `v'_horserace2_sd_w_juristat.csv, con r2 se label replace keep(loo_shrunk_pcwordcount_sd loo_shrunk_pcindepclaim_sd loo_shrunk_accept_sd loo_shrunk_r101_sd loo_shrunk_r102_sd loo_shrunk_r103_sd loo_shrunk_r112b_sd)
eststo clear

predict `v'_hat, xb 
keep appl_id `v'_hat
gen specification = "all main regressors, standardized and weighted"
save `v'_linear_predictor_juristat, replace

* save coeffs to table 
cd "$db\Final Tables\"

matrix b=e(b) 
gen coeff_words=b[1,1]
gen coeff_claims=b[1,2]
gen coeff_grant=b[1,3]
gen coeff_101=b[1,4]
gen coeff_102=b[1,5]
gen coeff_103=b[1,6]
gen coeff_112=b[1,7]

matrix v=e(V) 
gen se_words=sqrt(v[1,1])
gen se_claims=sqrt(v[2,2])
gen se_grant=sqrt(v[3,3])
gen se_101=sqrt(v[4,4])
gen se_102=sqrt(v[5,5])
gen se_103=sqrt(v[6,6])
gen se_112=sqrt(v[7,7])

gen t_words=coeff_words/se_words
gen t_claims=coeff_claims/se_claims
gen t_grant=coeff_grant/se_grant
gen t_101=coeff_101/se_101
gen t_102=coeff_102/se_102
gen t_103=coeff_103/se_103
gen t_112=coeff_112/se_112

gen N_sd_w=e(N)

if "`v'"=="NPE_portfolio" local table "Table4_PanelA"
if "`v'"=="nonnpe" local table "Table4_PanelB"
if "`v'"=="NPE_litigated" local table "Table5_PanelA"
if "`v'"=="litigated_v2" local table "Table5_PanelB"

* store everything but t stats
putexcel set IT_PAE_tables_juristat, sheet("`table'") modify

putexcel J4=coeff_words
putexcel J5=se_words
putexcel J6=coeff_claims
putexcel J7=se_claims
putexcel J8=coeff_grant
putexcel J9=se_grant
putexcel J10=coeff_101
putexcel J11=se_101
putexcel J12=coeff_102
putexcel J13=se_102
putexcel J14=coeff_103
putexcel J15=se_103
putexcel J16=coeff_112
putexcel J17=se_112
putexcel J18=N_sd_w
* store t stats
putexcel set IT_PAE_tables_juristat_t, sheet("`table'") modify
putexcel J4=t_words
putexcel J6=t_claims
putexcel J8=t_grant
putexcel J10=t_101
putexcel J12=t_102
putexcel J14=t_103
putexcel J16=t_112
}
