***************
*** Table 9 ***
***************


*** Repeat previous analysis with other controls/sample restrictions

* Row A) Baseline as in Table 2

* Row B) Assignee fixed effects
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if `x' == .

* control for assignee fixed effect
areg `x' i.assignee_num, absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_assigneeFE, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_assigneeFE, replace
}

* Row C) Exclude Intellectual Ventures
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if `x' == .
drop if Intellectual_Ventures==1

* control for assignee fixed effect
areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_noIV, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_noIV, replace
}

* Row D) Only Intellectual Ventures
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if `x' == .
keep if Intellectual_Ventures==1

* control for assignee fixed effect
areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_onlyIV, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_onlyIV, replace
}

* Row E) PAE list from Cotropial et al. (2014)
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if missing(NPE_portfolio_Cotropia)
replace NPE_portfolio = NPE_portfolio_Cotropia

* control for assignee fixed effect
areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_cotropia, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_cotropia, replace
}

* Row F) Small PAEs
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if missing(NPE_portfolio_small)
replace NPE_portfolio = NPE_portfolio_small

* control for assignee fixed effect
areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_small, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_small, replace
}

* Row G) PAEs purchasing from small entities/unassigned
foreach x in NPE_portfolio {

use examiner_effect_dataset, clear

drop if missing(NPE_portfolio_smallpurchase)
replace NPE_portfolio = NPE_portfolio_smallpurchase

* control for assignee fixed effect
areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_smallpurchase, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_table_smallpurchase, replace
}
