
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" /*unclean data, but not raw*/
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"




use $temdir/aca_CENCOL_withwages_rr, clear



		
	********************
	*Regressions
	**********************
	
	global racevar "age_at  race_H race_A race_OBX"
	global acadvar "gpa_prelot1   "
	global empvar "hemp_anypre emp_pre "	
	global finvar "sfa_bog sfa_pel  sfa_cal "	

	
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	

	keep if ESAMPLE57==1
*************************************************************
	*Create Dummies for balanced panel: first do a decoy regression
	ivreg logwage0 (awa=lot_adm)   			   if lotnum<5 & int57==1, cluster(ssn)      
		gen asdf=e(sample)
		egen zop=tag(ssn) if asdf==1
		bysort ssn: egen balpan_logwage0=total(zop)
			replace balpan_logwage0=balpan_logwage0>0
gen poste=yearqtr>classof 
	replace poste=0 if poste==.
gen posta=yearqtr>awa_minterm_123010_5
	replace posta=0 if posta==.	
gen posta2=yearqtr>awa_minterm_123010
	replace posta2=0 if posta2==.
	label var poste "Start Program"
	label var posta "Finish Program"
	label var posta2 "Finish Any ADN"
keep if balpan==1




gen ys1=yearqtr-mlot1_term
gen ys2=yearqtr-mlot2_term if mlot2_term  !=.
gen ys3=yearqtr-mlot3_term if mlot3_term  !=.
gen ys4=yearqtr-mlot4_term if mlot4_term  !=.
gen ys5=yearqtr-mlot5_term if mlot5_term  !=.

gen yw1=yearqtr-mlot1_term if mlot1_adm==1  
gen yw2=yearqtr-mlot2_term if mlot2_adm==1 & mlot2_term  !=.
gen yw3=yearqtr-mlot3_term if mlot3_adm==1 & mlot3_term  !=.
gen yw4=yearqtr-mlot4_term if mlot4_adm==1 & mlot4_term  !=.
gen yw5=yearqtr-mlot5_term if mlot5_adm==1 & mlot5_term  !=.

foreach g in ys yw{
	foreach w in 1 2 3 4 5{
		gen dpr_`g'`w'=`g'`w'<0
		gen d01_`g'`w'=`g'`w'>=0 & `g'`w'<2
		gen d24_`g'`w'=`g'`w'>=2 & `g'`w'<5
		gen d57_`g'`w'=`g'`w'>=5 & `g'`w'<5.4
		}
	gen dpr_`g'=(dpr_`g'1==1|dpr_`g'2==1|dpr_`g'3==1|dpr_`g'4==1)
	gen d01_`g'=(d01_`g'1==1|d01_`g'2==1|d01_`g'3==1|d01_`g'4==1)
	gen d24_`g'=(d24_`g'1==1|d24_`g'2==1|d24_`g'3==1|d24_`g'4==1)
	gen d57_`g'=(d57_`g'1==1|d57_`g'2==1|d57_`g'3==1|d57_`g'4==1)
	gen d27_`g'=d24_`g'==1|d57_`g'==1
}


gen ye=yearqtr-classof_st12301 if enr==1
	gen dpr_ye=ye<0
	gen d01_ye=ye>=0 & ye<2
	gen d24_ye=ye>=2 & ye<5
	gen d57_ye=ye>=5 & ye<5.4
	gen d27_ye=ye>=2 & ye<5.4
	




keep if lotnum==1
bysort ssn: egen maxy=max(ys1)
replace maxy=maxy>=8
qui tab ys1, gen(ys1fe)
	


	
*Regression
foreach g in e{
eststo d`g'3: ivreg2 logwage0  lot1fe*  agfe*   yfe* qfe*  enrolled  d01_ys d24_ys d57_ys   (d01_y`g' d24_y`g' pre=d01_yw d24_yw d57_yw) flot if ys1<=5.4 & ys1>=0,  cluster(ssn)
				estimates save "$temdir/rronestep2`g'iv" , replace

}
}