
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"
set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"



use $temdir/aca_CENCOL_withwages_rr, clear



	
	
***********************************************
*Outcomes
***********************************************

	eststo clear

gen wages0_cen=wages0 if wages0<=30000		
	
foreach g in 1 2 3 4 5 6 7 8 9{
		gen int`g'=rys==`g'
		gen nint`g'=rys==(-1*`g')
		}
		gen int0=rys==0		


		
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	

		
		local covars4="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre sfa_bog sfa_pel sfa_cal missfin "	
		
*Regressions

		mat z=.,.,.,.,.,.,.,.,.
		mat w=.,.,.,.
		forvalues inti=0/37{
		
			qui reg logwage0 lot_adm  flot  loofe* if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
				mat a=_b[lot_adm], _se[lot_adm], `inti'

			qui ivreg2 logwage0 (enrn=lot_adm)  enrolled  	`covars4'    flot loofe*      gap if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
					mat d=_b[enrn], _se[enrn]

					
			qui ivreg2 hemp (enrn=lot_adm)  enrolled  	`covars4'    flot loofe*      gap if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
					mat f=_b[enrn], _se[enrn]

			qui ivreg2 emp (enrn=lot_adm)  enrolled  	`covars4'    flot loofe*      gap if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
					mat h=_b[enrn], _se[enrn]


			qui ivreg2 wages0 (enrn=lot_adm)  enrolled  	`covars4'    flot loofe*      gap if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
					mat j=_b[enrn], _se[enrn]

			qui ivreg2 wages0_cen (enrn=lot_adm)  enrolled  	`covars4'    flot loofe*      gap if lotnum==1 & qys==`inti' & ESAMPLE5==1, cluster(ssn)  
					mat l=_b[enrn], _se[enrn]

										
				mat g`inti'=a,d, f, h
				mat w`inti'=j,l
				mat z=z\g`inti'
				mat w=w\w`inti'
				mat list z
				mat list w
			}

			
			preserve
			clear
			svmat z
			rename z3 years
			gen b1=z1
			gen c1=z4
			gen d1=z6
			gen e1=z8
			
			gen u1=b1+1.96*z2
			gen l1=b1-1.96*z2

			gen cu1=c1+1.96*z5
			gen cl1=c1-1.96*z5
			
			gen du1=d1+1.96*z7
			gen dl1=d1-1.96*z7
			
			gen eu1=e1+1.96*z9
			gen el1=e1-1.96*z9
									
			
			sort years
			replace years=years-17
			save $temdir/data_for_earntraj, replace
			use $temdir/data_for_earntraj, clear
			*************


*************
*Create graphs
*************			
			twoway scatter b1 u1 l1 years if years>0, ylab(, nogrid)  connect( l l l)  `figbacks' yline(0, lcolor(black))  lpattern(solid dash dash) msymbol(o none none) mcolor(navy) lcolor(navy navy navy) xtitle("Quarters Since Lottery") ytitle("Log Earnings Effect") xscale(r(0(4)21)) xlabel(0(4)21) legend(off)
						graph export  "$outdir/rr/reg_byq_r1_p.eps", replace

				
			twoway scatter c1 cu1 cl1 years  if years>0, ylab(, nogrid)  connect( l l l)  `figbacks' yline(0, lcolor(black))  lpattern(solid dash dash) msymbol(o none none) mcolor(navy) lcolor(navy navy navy) xtitle("Quarters Since Lottery") ytitle("Log Earnings Effect") xscale(r(0(4)21)) xlabel(0(4)21) legend(off)
						graph export  "$outdir/rr/reg_byq_enrn1_p.eps", replace

						
								
			twoway scatter d1 du1 dl1 years  if years>0, ylab(, nogrid)  connect( l l l)  `figbacks' yline(0, lcolor(black))  lpattern(solid dash dash) msymbol(o none none) mcolor(navy) lcolor(navy navy navy) xtitle("Quarters Since Lottery") ytitle("Employment Effect") xscale(r(0(4)21)) xlabel(0(4)21) legend(off)
						graph export  "$outdir/rr/reg_byq_enrnhemp1_p.eps", replace

						
			twoway scatter e1 eu1 el1 years  if years>0, ylab(, nogrid)  connect( l l l)  `figbacks' yline(0, lcolor(black))  lpattern(solid dash dash) msymbol(o none none) mcolor(navy) lcolor(navy navy navy) xtitle("Quarters Since Lottery") ytitle("Employment Effect") xscale(r(0(4)21)) xlabel(0(4)21) legend(off)
						graph export  "$outdir/rr/reg_byq_enrnemp1_p.eps", replace

											

