
*EU Countries*

insheet using "${cbt_datadir}\Other\eu_country.csv", name clear
save "${cbt_datadir}\Other\eu_country", replace


*GDP per Capita*

insheet using "${cbt_datadir}\Control\gdp_capita.csv", name clear
ren time year
ren geo country_name
drop  indic_na unit
ren value gdp_capita

merge m:1 country_name using "${cbt_datadir}\Other\eu_country"
keep if _merge==3
drop _merge
destring gdp_capita, replace
qui save "${cbt_datadir}\Control\gdp_percapita", replace

*Population*

insheet using "${cbt_datadir}\Control\pop_eustat.csv", name clear
ren time year
ren geo country_name
drop age sex
ren value pop
label var pop "Population"
destring pop, replace force
replace country_name="Germany" if country_name=="Germany (until 1990 former territory of the FRG)"

merge m:1 country_name using "${cbt_datadir}\Other\eu_country"
keep if _merge==3
drop _merge
qui save "${cbt_datadir}\Control\pop", replace

*Inflation*

insheet using "${cbt_datadir}\Control\inflation.csv", name clear
ren time year
ren geo country_name
drop  infotype coicop
ren value price_index
label var price_index ""
replace country_name="Germany" if country_name=="Germany (until 1990 former territory of the FRG)"

merge m:1 country_name using "${cbt_datadir}\Other\eu_country"
keep if _merge==3
drop _merge
qui save "${cbt_datadir}\Control\price_index", replace

*Unemployment*

insheet using "${cbt_datadir}\Control\unemploy.csv", name clear
ren time year
ren geo country_name
drop s_adj age sex flagandfootnotes
ren value unemp
label var unemp""
replace country_name="Germany" if country_name=="Germany (until 1990 former territory of the FRG)"

merge m:1 country_name using "${cbt_datadir}\Other\eu_country"
keep if _merge==3
drop _merge
qui save "${cbt_datadir}\Control\unemp", replace

*Combine all the control variables*

use "${cbt_datadir}\Control\unemp", clear
merge 1:1 country year using "${cbt_datadir}\Control\price_index"
drop _merge
merge 1:1 country year using "${cbt_datadir}\Control\pop"
drop _merge
merge 1:1 country year using "${cbt_datadir}\Control\gdp_percapita"
keep if _merge==3
drop _merge
merge 1:1 country year using "${cbt_datadir}\Other\eu_rate"
keep if _merge==3
drop _merge

qui save "${cbt_datadir}\Control\controls", replace

qui use "${cbt_datadir}\Control\controls", clear

gen uo_ctry=country
gen uo_cpi=price_index
gen uo_pop=pop
gen uo_gdp=gdp_capita
gen uo_unemp=unemp

qui save "${cbt_datadir}\Control\controls", replace


*world bank data*

qui insheet using "${cbt_datadir}\Control\WDI_Data.csv", clear name

drop v5-v49
ren v50 year2005
ren v51 year2006
ren v52 year2007
ren v53 year2008
ren v54 year2009
ren v55 year2010
ren v56 year2011

drop v57 v58

keep if indicatorname=="Exports of goods and services (% of GDP)" |	///
indicatorname=="Exports of goods and services (BoP, current US$)" | ///
indicatorname=="GDP (current US$)" | ///
indicatorname=="GDP growth (annual %)" | ///
indicatorname=="GDP per capita (current US$)" | ///
indicatorname=="CPIA transparency, accountability, and corruption in the public sector rating (1=low to 6=high)" | ///
indicatorname=="Long-term unemployment (% of total unemployment)" | ///
indicatorname=="CPIA business regulatory environment rating (1=low to 6=high)"

egen group = group(indicatorcode), label

gen a3=countrycode

merge m:1 a3 using "${cbt_datadir}\Other\country_code"
keep if _merge==3
drop countryname countrycode _merge uo_ctryname a3

forv i=1/8 {
preserve
keep if group==`i'
keep uo_ctry indicatorname indicatorcode year*
save "${cbt_datadir}\Control\uoctry_macro`i'", replace
restore
}


*Export*
use "${cbt_datadir}\Control\uoctry_macro1", clear
forv j=2005/2011 {
ren year`j' uo_export`j'
}
drop indicatorname indicatorcode
reshape long uo_export, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro1", replace

*Export value*
use "${cbt_datadir}\Control\uoctry_macro2", clear
forv j=2005/2011 {
ren year`j' uo_breg`j'
}
drop indicatorname indicatorcode
reshape long uo_breg, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro2", replace

*GDP*
use "${cbt_datadir}\Control\uoctry_macro3", clear
forv j=2005/2011 {
ren year`j' uo_trans`j'
}
drop indicatorname indicatorcode
reshape long uo_trans, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro3", replace

*GDP Growth*
use "${cbt_datadir}\Control\uoctry_macro4", clear
forv j=2005/2011 {
ren year`j' uo_exportgrowth`j'
}
drop indicatorname indicatorcode
reshape long uo_exportgrowth, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro4", replace

*GDP Per Capita*
use "${cbt_datadir}\Control\uoctry_macro5", clear
forv j=2005/2011 {
ren year`j' uo_gdp`j'
}
drop indicatorname indicatorcode
reshape long uo_gdp, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro5", replace

*Transparency*
use "${cbt_datadir}\Control\uoctry_macro6", clear
forv j=2005/2011 {
ren year`j' uo_gdpgrowth`j'
}
drop indicatorname indicatorcode
reshape long uo_gdpgrowth, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro6", replace

*Unemployment*
use "${cbt_datadir}\Control\uoctry_macro7", clear
forv j=2005/2011 {
ren year`j' uo_gdppcap`j'
}
drop indicatorname indicatorcode
reshape long uo_gdppcap, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro7", replace

*Business environment*
use "${cbt_datadir}\Control\uoctry_macro8", clear
forv j=2005/2011 {
ren year`j' uo_unemp`j'
}
drop indicatorname indicatorcode
reshape long uo_unemp, i(uo_ctry) j(year)
save "${cbt_datadir}\Control\uoctry_macro8", replace


*Combine all data*

use "${cbt_datadir}\Control\uoctry_macro1", clear
forv i=2/8 {
append using "${cbt_datadir}\Control\uoctry_macro`i'"
}


drop uo_exportgrowth

drop if uo_export==. &  uo_breg ==. & uo_trans ==. & uo_gdp ==. ///
& uo_gdpgrowth ==. & uo_gdppcap ==. & uo_unemp ==.
count


collapse  uo_export uo_breg uo_trans uo_gdp uo_gdpgrowth uo_gdppcap uo_unemp, ///
by(uo_ctry year)

save "${cbt_datadir}\Control\uoctry_macroclean", replace





