**************************Data Cleanup**********************

qui use "S:\Li Liu\FAME Downloads\Incorporation\incorporation_n2", clear

qui drop v26 

*create id
qui replace mark = mark[_n-1] if missing(mark) 


*incorporation date
qui gen incorp_date = date(incorporationdate, "DMY")
qui drop incorporationdate
qui bysort mark: replace incorp_date = incorp_date[_n-1] if missing(incorp_date) 

qui gen incorp_year=year(incorp_date)
qui bysort mark: replace incorp_year = incorp_year[_n-1] if missing(incorp_year) 

*registered number
qui ren  registerednumber CRN
qui ren  bvdepidnumber bvd_id

*number of subs
qui ren noofrecordedsubsidiaries no_subsrecorded
qui ren numberofsubsidiaries no_subs
qui replace no_subsrecorded = no_subsrecorded[_n-1] if missing(no_subsrecorded) 
qui replace no_subs = no_subs[_n-1] if missing(no_subs)

*domestic owners
qui ren domesticuobvdepidnumber uodomestic_bvd
qui ren domesticuocountryisocode uodomestic_country
qui ren domesticuotype uodomestic_type
tab uodomestic_country
qui drop uodomestic_country

qui bysort mark: replace uodomestic_bvd = uodomestic_bvd[_n-1] if missing(uodomestic_bvd)
qui bysort mark: replace uodomestic_type = uodomestic_type[_n-1] if missing(uodomestic_type)

*global ultimate owner
qui ren  globaluobvdepidnumber uoglobal_bvd
qui ren globaluocountryisocode uoglobal_country
qui ren globaluotype uoglobal_type

tab uoglobal_country

qui bysort mark: replace uoglobal_bvd = uoglobal_bvd[_n-1] if missing(uoglobal_bvd)
qui bysort mark: replace uoglobal_country = uoglobal_country[_n-1] if missing(uoglobal_country)
qui bysort mark: replace uoglobal_type = uoglobal_type[_n-1] if missing(uoglobal_type)

*Subsidiaries

qui ren subsidiaryregisterednumber sub_crn
qui ren relationshiptype relation_type
qui ren relationshiplevel relation_level

qui ren subsidiarybvdepidno sub_bvdid
qui ren subsidiarycountryisocode sub_country
qui ren subsidiarytype sub_type
qui ren subsidiarylevel sub_level


*consolidation code

forv year=2001/2009 {
	qui ren conscode`year' cons_code`year'
	}
	
forv year=2001/2009 {
	qui drop if cons_code`year'=="C"
	}
	
qui drop cons_code*
	
******Identifying Ownership *****************

*Stand-alone, domestic, independent companies: no ultimate owner and no subs

qui gen stand_alone= (no_subs==0 & no_subsrecorded==0) & ///
(uodomestic_bvd=="" & uoglobal_bvd=="")

*UK parent: no ultimate owner; with subsidaries
qui gen uk_parent= (no_subs!=0 | no_subsrecorded!=0) & ///
(uodomestic_bvd=="" & uoglobal_bvd=="")

*Indicator for all UK subs:
qui bysort mark: gen sub_uk=(sub_country=="GB")
qui bysort mark: egen allsub_uk=min(sub_uk)
qui drop sub_uk

*Ownership structure
qui keep if bvd_id!=""
qui drop  sub_crn relation_type relation_level sub_bvdid sub_country sub_type sub_level

*Save a dataset to be merged at the UO level*

preserve
keep bvd_id allsub_uk
rename bvd_id  uoglobal_bvd
rename allsub_uk uoallsub_uk
collapse (mean)uoallsub_uk, by (uoglobal_bvd)
save "${cbt_datadir}\allsub_uk", replace
restore

merge m:1 uoglobal_bvd using "${cbt_datadir}\allsub_uk"

drop if _merge==2
drop _merge


qui save "${cbt_datadir}\etpf_owernship", replace
