qui use "${cbt_datadir}\Other\eu_rate", clear

drop statu_low2005 statu_low2011

keep if year==2011

drop year corp_rate statu_rate corp_uk statu_uk 
gen NUTS_id=country

replace NUTS_id="UK" if NUTS_id=="GB"
replace NUTS_id="EL" if NUTS_id=="GR"

qui save "${cbt_datadir}\Other\eu_low", replace

*alternative database*

qui use "${cbt_datadir}\Other\eu_rate", clear

merge m:1 country using "${cbt_datadir}\Other\eu_country"

drop _merge

keep if year==2005 | year==2011

drop statu_rate corp_uk statu_uk 

reshape wide corp_rate, i(country) j(year)

qui save "${cbt_datadir}\Other\myeu_low", replace

*map prep for UK Subs*

use "${cbt_datadir}\Exemption_MNE", replace

gen ones=1
keep if uo_ctry=="GB"

collapse (sum)ones, by (country) 
ren ones uk_subs

save "${cbt_datadir}\uk_subs_clean", replace

clear 
exit
