function [ss] = solveSS(par,func,glob,comp)
th0 = 0.5;
errTight = 1;
iterTight = 0;

xiGr = zeros(glob.nXi,1);
xiGr(end) = par.xiBad;
glob.xiGrid = xiGr;

Pxi = eye(glob.nXi);

Pxi(1,end) = par.pBad;
Pxi(1,end-1) = (1-par.pBad);

Pxi(end,end-1) = par.pGood;
Pxi(end,end) = (1 - par.pGood);

glob.Pxi = Pxi;

glob.masterP    = kron(glob.Pz,glob.Pxi);
glob.disutil    = kron(ones(glob.nZ,1),glob.xiGrid);

while errTight > comp.tolerTight && iterTight < comp.maxIterTight
    
    f0 = func.f_theta(th0,par.eta,par.mu);
    q0 = func.q_theta(th0,par.eta,par.mu);

    %% Solve Bellman Equations
    [S,V,s_u,s_e] = solveSurplus(par,func,glob,comp,f0,q0);
    quit = 1*(S<0); % quit decision
    sE = s_e;   % employed search effort
    sU = s_u(1:glob.nXi:end)'; % unemployed search effort
    
    %% Compute Steady State Worker Distribution
    [u, e, EE, EU] = computeSSWorkerDistribution(sE, sU, f0, par, glob, quit, comp);
    
    effectiveSearch = (sU*u + par.lambda*sE'*e);
    v = th0*effectiveSearch;
    vOld = (1-par.delta) * (1 - (1-par.s) * q0) * v;
    %% Check Free Entry
    S0_xi_min = dprod(S(glob.selection),glob.onesnXi)';

    thSyst = @(n) -((1-par.beta*(1-par.delta)).*func.k_n(n + par.gamma * ( EE + EU ) + vOld , par.k1 , par.k2, n + par.gamma * ( EE + EU ) + vOld) ...
        + par.kappa...
        - par.beta*(1-par.delta)*(1-par.s)*(1-par.phi)*S0_xi_min(1)*func.q_theta((n + par.gamma * ( EE + EU ) + vOld)/effectiveSearch , par.eta, par.mu )).^2;
    
    
      n = goldenx(thSyst,comp.thLB,comp.thUB);
      th1 = (n + par.gamma * ( EE + EU ) + vOld)/effectiveSearch;
     
    %% Update
    errTight = 100 * abs(th1-th0);
    iterTight = iterTight +1 ;
    th0 = comp.omega * th0 + (1-comp.omega) * th1;
end


ss.S = S;
ss.V = V;
ss.quit = quit;
ss.s_u = s_u(1:glob.nXi:end)';
ss.s_e = s_e;
ss.v = v;
ss.n = v - par.gamma * ( EE + EU ) - vOld;
ss.vOld = vOld;
ss.th = th0;
ss.thObs = v/u;
ss.e = e;
ss.emp = sum(e);
ss.EE = EE;
ss.EU = EU;
ss.f = f0;
ss.q = q0;

% model moments for calibration: worker side
ss.u = u; % unemployment rate
ss.ueRate = (1-par.delta) * (1-par.s) * ss.s_u * ss.f; % job finding rate for unemployed workers
ss.jjRate = (1-par.s) * ss.EE/ss.emp; % job-to-job rate
ss.euRate = par.delta + (par.s * ss.EE + EU)/ss.emp; % employment to unemployment rate

% model moments for calibration: firm side
ss.vfr = (1-par.delta) * (1-par.s) * ss.q; % vacancy filling rate for firms
ss.repVacShare = par.gamma*(ss.EE+ss.EU)/(par.gamma*(ss.EE+ss.EU)+ss.n); % share of replacement vacancies in total vacancies

vPQrt = ([1 0 0 ; ...
    par.delta (1-par.delta)*(1-(1-par.s)*ss.q) (1-par.delta)*(1-par.s)*ss.q; ...
    par.delta + (1-par.delta)*(par.s+(1-par.s)*par.lambda*ss.f)*(1-par.gamma) (1-par.delta)*(par.s+(1-par.s)*par.lambda*ss.f)*par.gamma (1-par.delta)*(1-par.s)*(1-par.lambda*ss.f)])^3;
ss.jdr_qrt = vPQrt(3,1)+vPQrt(3,2); % quarterly job destruction rate

ss.xiBadShare = e(end); 
ss.searchCostU = func.c_s(ss.s_u,par.A,par.psi);

end