function [S0,V0,s_u,s_e] = solveSurplus(par,func,glob,comp,f0,q0)

% VFI on match surplus and vacancy value
S0 = glob.output - glob.disutil - par.b + par.kappa;
V0 = -par.kappa*ones(glob.nXi*glob.nZ,1);

errVFI = 1;
iterVFI = 0;

while errVFI > comp.tolerVFI && iterVFI < comp.maxIterVFI
    
    [S1,V1,s_u,s_e] = iterateSurplus(S0,V0,par,func,glob,f0,q0);
    
    errSMat = abs(S1-S0);
    errVMat = abs(V1-V0);
    errVFI = max([errSMat(:);errVMat(:)]);
    iterVFI = iterVFI + 1;
    S0 = S1;
    V0 = V1;
    
end
end