function [S1,V1,s_u,s_e] = iterateSurplus(S0,V0,par,func,glob,f_th,q_th)

beta = par.beta;
delta = par.delta;
lambda = par.lambda;
phi = par.phi;
gamma = par.gamma;
s = par.s;

S0_xi_min = dprod(S0(glob.selection),glob.onesnXi)';

% search effort
s_u = func.c_sprime_inv(beta*(1-delta)*(1-s)*phi*f_th.*(glob.masterPz*S0_xi_min),par.A,par.psi);
c_u = func.c_s(s_u,par.A,par.psi);

s_e = func.c_sprime_inv(beta*(1-delta)*(1-s)*lambda*phi*f_th.*(glob.masterPz*S0_xi_min-glob.masterP*max(S0,0)),par.A,par.psi);
c_e = func.c_s(s_e,par.A,par.psi);


% update match surplus
S1 = glob.output - glob.disutil - par.b ...
    - (c_e - c_u) ...
    + par.kappa ...
    + beta*(1-delta)*(...
    (1-s)*(...
    (1-lambda*s_e.*f_th).*glob.masterP*max(S0,0) ...
    + ((lambda*s_e - s_u).*f_th*phi - q_th*(1-phi)).*(glob.masterPz*S0_xi_min)...
    ) ...
    + (gamma*s + gamma*(1-s)*lambda*s_e.*f_th - 1 + (1-s)*(1-lambda*s_e.*f_th) ).*(glob.masterPz*V0) ...
    + (gamma-1)*(1-s)*(1-lambda*s_e.*f_th).*(glob.masterPz*((S0<=0).*V0))...
    );

% update vacancy value
V1 = -par.kappa + beta*(1-delta)* ...
    (q_th * (1-phi) * (1-s) * (glob.masterPz*S0_xi_min) + glob.masterPz*V0);

end


