function [residual, g1, g2, g3] = Ramsey_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 45, 1);

%
% Model equations
%

T17 = params(23)^(-1);
T28 = 1/y(3);
T37 = 1/(1-params(7));
T38 = params(6)^T37;
T45 = (-(T38*(-(1-params(10)))/params(8)));
T55 = params(2)*(-(1-y(8)))/(y(3)*y(3));
T57 = (-(T55/T28));
T67 = params(2)*((1-y(8))/y(3)+y(8)/y(4));
T68 = (-1)/(y(3)*y(3));
T86 = (-((1-y(9))*1/y(4)));
T93 = (-(params(2)*(-y(8))/(y(4)*y(4))/T28));
T105 = (-(params(20)/(1-params(4))*getPowerDeriv(y(5),1-params(4),1)));
T110 = getPowerDeriv(1,(-params(4)),1);
T129 = y(7)^(params(7)/(1-params(7)));
T141 = (1+y(16))^params(14);
T142 = params(15)*T141;
T152 = params(15)*(1+y(16))^(params(14)-1);
T160 = getPowerDeriv(y(7),params(7)/(1-params(7)),1);
T193 = params(2)*(1/y(4)+(-1)/y(3));
T214 = (1-y(9)*(1-params(9)))^params(7);
T217 = (y(9)-y(9)*(1-params(9)))/T214;
T218 = getPowerDeriv(T217,T37,1);
T225 = (-(exp(y(22))/y(15)-y(3)));
T236 = (-(1-params(9)))*getPowerDeriv(1-y(9)*(1-params(9)),params(7),1);
T242 = (-(T218*(T214*(-(1-params(9)))-(y(9)-y(9)*(1-params(9)))*T236)/(T214*T214)));
T259 = (-(T38*(1-params(10))*exp(y(22))/params(8)));
T260 = y(29)*T259;
T269 = (-((1-params(15))*getPowerDeriv(y(12),(-params(14)),1)));
T276 = (-((1-params(15))*getPowerDeriv(y(12),1-params(14),1)));
T286 = (-(params(14)*(1-params(16))/(y(14)*(params(14)-1))));
T300 = (-((-((params(14)-1)*y(13)*params(14)*(1-params(16))))/(y(14)*(params(14)-1)*y(14)*(params(14)-1))));
T313 = (-(y(9)*(-exp(y(22)))/(y(15)*y(15))));
T314 = y(27)*T313;
T323 = getPowerDeriv(1+y(16),params(14),1);
T330 = (-(params(15)*getPowerDeriv(1+y(16),(-(1-params(14))),1)));
T335 = (-(y(2)*(1+y(1))))/((1+y(16))*(1+y(16)));
T346 = params(15)*getPowerDeriv(1+y(16),params(14)-1,1);
T380 = (y(21)/params(3))^(-1);
T389 = params(3)^params(19);
T393 = (-(T389*getPowerDeriv(y(21),1-params(19),1)));
T399 = 1/params(3)*getPowerDeriv(y(21)/params(3),(-1),1);
T413 = (-(T38*(1-params(10))*exp(y(22))*y(11)/params(8)));
T416 = (-(y(9)*exp(y(22))/y(15)));
T419 = y(42)*(-(y(9)*exp(y(22))))+y(29)*T413+y(27)*T416;
residual(1) = y(25)*y(2)/(1+y(16));
residual(2) = y(26)+T17*y(25)*(1+y(1))/(1+y(16));
residual(3) = y(43)*(-(y(9)*T28))+y(41)+y(29)*T45+y(9)*y(27)+y(26)*T57+y(24)*(-params(1))+params(23)*y(26)*(-((-(T67*T68))/(T28*T28)));
residual(4) = y(43)*T86+y(24)+y(26)*T93;
residual(5) = y(43)*T105+y(28)*(-(params(2)*1/y(5)*T110))+y(27)+params(23)*y(28)*(-(params(2)*T110*(-y(5))/(y(5)*y(5))));
residual(6) = y(28)+T17*y(29)*(-(T129*(1-params(9))))+T17*y(34)*(-(y(13)*T142))+T17*y(35)*(-(y(14)*T152));
residual(7) = y(39)*(-(params(8)*T160/T38))+y(31)*(-(1-y(9)))+params(9)*y(30)+y(29)*T160+T17*y(29)*(-(T160*(1-params(9))*y(6)))+T17*y(38)*(-(y(19)*(-params(2))));
residual(8) = T17*y(38)*(-(y(19)*(-params(2))))+y(9)*y(31)+y(30)+y(26)*(-(T193/T28));
residual(9) = y(43)*(-(log(y(3))-log(y(4))))+y(42)*(-exp(y(22)))+y(32)*(-(1/T214*T218))+y(31)+y(27)*T225+params(23)*y(31)*(-(1-y(8)-y(7)))+params(23)*y(32)*T242;
residual(10) = y(32)+params(8)*y(27);
residual(11) = y(34)*(-y(17))+T260;
residual(12) = y(37)*T269+y(33)+y(36)*T276;
residual(13) = y(34)+y(33)*T286+T17*y(34)*(-(T142*y(6)));
residual(14) = y(35)+y(33)*T300+T17*y(35)*(-(T152*y(6)));
residual(15) = y(42)*y(17)+y(37)+T314+params(23)*y(37)*(-T142);
residual(16) = y(37)*(-(params(15)*y(15)*T323))+y(36)*T330+T17*y(25)*T335+T17*y(34)*(-(y(13)*y(6)*params(15)*T323))+T17*y(35)*(-(y(14)*y(6)*T346));
residual(17) = y(42)*y(15)+(-y(35))+y(34)*(-y(11));
residual(18) = 1+y(43);
residual(19) = y(40)*1/params(17)+y(38)+T17*y(38)*(-(params(2)*(1-y(8)-y(7))));
residual(20) = y(39)+y(40)*(-(T380*1/params(18)));
residual(21) = y(41)*T393+y(40)*(-(y(20)/params(18)*T399));
residual(22) = y(44)+T419+params(23)*y(44)*(-params(21));
residual(23) = y(45)+y(29)*T45+params(23)*y(45)*(-params(22));
residual(24) = y(4)-y(3)*params(1);
residual(25) = y(2)*(1+y(1))/(1+y(16))-1;
residual(26) = y(2)-T67/T28;
residual(27) = y(5)-(y(9)*(exp(y(22))/y(15)-y(3))-params(8)*y(10)+params(5));
residual(28) = y(6)-params(2);
residual(29) = T129-(T38*(1-params(10))*(exp(y(22))*y(11)-y(3)+params(11)-y(23))/params(8)+T129*(1-params(9))*y(6));
residual(30) = y(8)-params(9)*(1-y(7));
residual(31) = y(9)-(y(9)*(1-y(8))+(1-y(9))*y(7));
residual(32) = y(10)-T217^T37;
residual(33) = y(12)-y(13)*params(14)*(1-params(16))/(y(14)*(params(14)-1));
residual(34) = y(13)-(y(17)*y(11)+y(13)*T142*y(6));
residual(35) = y(14)-(y(17)+y(14)*T152*y(6));
residual(36) = 1-((1-params(15))*y(12)^(1-params(14))+params(15)*(1+y(16))^(-(1-params(14))));
residual(37) = y(15)-((1-params(15))*y(12)^(-params(14))+T141*params(15)*y(15));
residual(38) = y(19)-((-log(params(1)))+y(19)*params(2)*(1-y(8)-y(7)));
residual(39) = y(20)-params(8)*T129/T38;
residual(40) = y(19)/params(17)-T380*y(20)/params(18);
residual(41) = y(3)-T389*y(21)^(1-params(19));
residual(42) = y(15)*y(17)-y(9)*exp(y(22));
residual(43) = y(18)-(y(9)*log(y(3))+(1-y(9))*log(y(4))+params(20)/(1-params(4))*y(5)^(1-params(4)));
residual(44) = y(22)-(y(22)*params(21)-x(1));
residual(45) = y(23)-(params(22)*y(23)+x(2));
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(45, 45);

  %
  % Jacobian matrix
  %

T564 = T55*T68;
T590 = y(26)*(-((-(T68*params(2)*(-y(8))/(y(4)*y(4))))/(T28*T28)));
T625 = y(26)*(-(params(2)*(-1)/(y(4)*y(4))/T28));
T668 = getPowerDeriv(y(7),params(7)/(1-params(7)),2);
T701 = (T214*(1-(1-params(9)))-(y(9)-y(9)*(1-params(9)))*T236)/(T214*T214)*getPowerDeriv(T217,T37,2);
T754 = y(33)*(-((-((params(14)-1)*params(14)*(1-params(16))))/(y(14)*(params(14)-1)*y(14)*(params(14)-1))));
T783 = getPowerDeriv(1+y(16),params(14),2);
  g1(1,2)=y(25)*1/(1+y(16));
  g1(1,16)=y(25)*(-y(2))/((1+y(16))*(1+y(16)));
  g1(1,25)=y(2)/(1+y(16));
  g1(2,1)=T17*y(25)*1/(1+y(16));
  g1(2,16)=T17*y(25)*(-(1+y(1)))/((1+y(16))*(1+y(16)));
  g1(2,25)=T17*(1+y(1))/(1+y(16));
  g1(2,26)=1;
  g1(3,3)=y(43)*(-(y(9)*T68))+y(26)*(-((T28*params(2)*(-((-(1-y(8)))*(y(3)+y(3))))/(y(3)*y(3)*y(3)*y(3))-T564)/(T28*T28)))+params(23)*y(26)*(-((T28*T28*(-(T564+T67*(y(3)+y(3))/(y(3)*y(3)*y(3)*y(3))))-(-(T67*T68))*(T28*T68+T28*T68))/(T28*T28*T28*T28)));
  g1(3,4)=params(23)*T590;
  g1(3,8)=y(26)*(-(params(2)*1/(y(3)*y(3))/T28))+params(23)*y(26)*(-((-(T68*T193))/(T28*T28)));
  g1(3,9)=y(27)+y(43)*(-T28);
  g1(3,24)=(-params(1));
  g1(3,26)=T57+params(23)*(-((-(T67*T68))/(T28*T28)));
  g1(3,27)=y(9);
  g1(3,29)=T45;
  g1(3,41)=1;
  g1(3,43)=(-(y(9)*T28));
  g1(4,3)=T590;
  g1(4,4)=y(43)*(-((1-y(9))*(-1)/(y(4)*y(4))))+y(26)*(-(params(2)*(-((-y(8))*(y(4)+y(4))))/(y(4)*y(4)*y(4)*y(4))/T28));
  g1(4,8)=T625;
  g1(4,9)=y(43)*1/y(4);
  g1(4,24)=1;
  g1(4,26)=T93;
  g1(4,43)=T86;
  g1(5,5)=y(43)*(-(params(20)/(1-params(4))*getPowerDeriv(y(5),1-params(4),2)))+y(28)*(-(params(2)*T110*(-1)/(y(5)*y(5))))+params(23)*y(28)*(-(params(2)*T110*((-(y(5)*y(5)))-(-y(5))*(y(5)+y(5)))/(y(5)*y(5)*y(5)*y(5))));
  g1(5,27)=1;
  g1(5,28)=(-(params(2)*1/y(5)*T110))+params(23)*(-(params(2)*T110*(-y(5))/(y(5)*y(5))));
  g1(5,43)=T105;
  g1(6,7)=T17*y(29)*(-((1-params(9))*T160));
  g1(6,13)=T17*y(34)*(-T142);
  g1(6,14)=T17*y(35)*(-T152);
  g1(6,16)=T17*y(34)*(-(y(13)*params(15)*T323))+T17*y(35)*(-(y(14)*T346));
  g1(6,28)=1;
  g1(6,29)=T17*(-(T129*(1-params(9))));
  g1(6,34)=T17*(-(y(13)*T142));
  g1(6,35)=T17*(-(y(14)*T152));
  g1(7,6)=T17*y(29)*(-((1-params(9))*T160));
  g1(7,7)=y(39)*(-(params(8)*T668/T38))+y(29)*T668+T17*y(29)*(-((1-params(9))*y(6)*T668));
  g1(7,9)=y(31);
  g1(7,19)=T17*params(2)*y(38);
  g1(7,29)=T160+T17*(-(T160*(1-params(9))*y(6)));
  g1(7,30)=params(9);
  g1(7,31)=(-(1-y(9)));
  g1(7,38)=T17*(-(y(19)*(-params(2))));
  g1(7,39)=(-(params(8)*T160/T38));
  g1(8,3)=y(26)*(-((T28*params(2)*1/(y(3)*y(3))-T68*T193)/(T28*T28)));
  g1(8,4)=T625;
  g1(8,9)=y(31);
  g1(8,19)=T17*params(2)*y(38);
  g1(8,26)=(-(T193/T28));
  g1(8,30)=1;
  g1(8,31)=y(9);
  g1(8,38)=T17*(-(y(19)*(-params(2))));
  g1(9,3)=y(27)+y(43)*(-T28);
  g1(9,4)=y(43)*1/y(4);
  g1(9,7)=params(23)*y(31);
  g1(9,8)=params(23)*y(31);
  g1(9,9)=y(32)*(-(T218*(-T236)/(T214*T214)+1/T214*T701))+params(23)*y(32)*(-((T214*(-(1-params(9)))-(y(9)-y(9)*(1-params(9)))*T236)/(T214*T214)*T701+T218*(T214*T214*((-(1-params(9)))*T236-(T236*(1-(1-params(9)))+(y(9)-y(9)*(1-params(9)))*(-(1-params(9)))*(-(1-params(9)))*getPowerDeriv(1-y(9)*(1-params(9)),params(7),2)))-(T214*(-(1-params(9)))-(y(9)-y(9)*(1-params(9)))*T236)*(T214*T236+T214*T236))/(T214*T214*T214*T214)));
  g1(9,15)=y(27)*(-((-exp(y(22)))/(y(15)*y(15))));
  g1(9,22)=y(42)*(-exp(y(22)))+y(27)*(-(exp(y(22))/y(15)));
  g1(9,27)=T225;
  g1(9,31)=1+params(23)*(-(1-y(8)-y(7)));
  g1(9,32)=(-(1/T214*T218))+params(23)*T242;
  g1(9,42)=(-exp(y(22)));
  g1(9,43)=(-(log(y(3))-log(y(4))));
  g1(10,27)=params(8);
  g1(10,32)=1;
  g1(11,17)=(-y(34));
  g1(11,22)=T260;
  g1(11,29)=T259;
  g1(11,34)=(-y(17));
  g1(12,12)=y(37)*(-((1-params(15))*getPowerDeriv(y(12),(-params(14)),2)))+y(36)*(-((1-params(15))*getPowerDeriv(y(12),1-params(14),2)));
  g1(12,33)=1;
  g1(12,36)=T276;
  g1(12,37)=T269;
  g1(13,6)=T17*y(34)*(-T142);
  g1(13,14)=T754;
  g1(13,16)=T17*y(34)*(-(y(6)*params(15)*T323));
  g1(13,33)=T286;
  g1(13,34)=1+T17*(-(T142*y(6)));
  g1(14,6)=T17*y(35)*(-T152);
  g1(14,13)=T754;
  g1(14,14)=y(33)*(-((-((-((params(14)-1)*y(13)*params(14)*(1-params(16))))*((params(14)-1)*y(14)*(params(14)-1)+(params(14)-1)*y(14)*(params(14)-1))))/(y(14)*(params(14)-1)*y(14)*(params(14)-1)*y(14)*(params(14)-1)*y(14)*(params(14)-1))));
  g1(14,16)=T17*y(35)*(-(y(6)*T346));
  g1(14,33)=T300;
  g1(14,35)=1+T17*(-(T152*y(6)));
  g1(15,9)=y(27)*(-((-exp(y(22)))/(y(15)*y(15))));
  g1(15,15)=y(27)*(-(y(9)*(-((-exp(y(22)))*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15))));
  g1(15,16)=params(23)*y(37)*(-(params(15)*T323));
  g1(15,17)=y(42);
  g1(15,22)=T314;
  g1(15,27)=T313;
  g1(15,37)=1+params(23)*(-T142);
  g1(15,42)=y(17);
  g1(16,1)=T17*y(25)*(-y(2))/((1+y(16))*(1+y(16)));
  g1(16,2)=T17*y(25)*(-(1+y(1)))/((1+y(16))*(1+y(16)));
  g1(16,6)=T17*y(34)*(-(y(13)*params(15)*T323))+T17*y(35)*(-(y(14)*T346));
  g1(16,13)=T17*y(34)*(-(y(6)*params(15)*T323));
  g1(16,14)=T17*y(35)*(-(y(6)*T346));
  g1(16,15)=y(37)*(-(params(15)*T323));
  g1(16,16)=y(37)*(-(params(15)*y(15)*T783))+y(36)*(-(params(15)*getPowerDeriv(1+y(16),(-(1-params(14))),2)))+T17*y(25)*(-((-(y(2)*(1+y(1))))*(1+y(16)+1+y(16))))/((1+y(16))*(1+y(16))*(1+y(16))*(1+y(16)))+T17*y(34)*(-(y(13)*y(6)*params(15)*T783))+T17*y(35)*(-(y(14)*y(6)*params(15)*getPowerDeriv(1+y(16),params(14)-1,2)));
  g1(16,25)=T17*T335;
  g1(16,34)=T17*(-(y(13)*y(6)*params(15)*T323));
  g1(16,35)=T17*(-(y(14)*y(6)*T346));
  g1(16,36)=T330;
  g1(16,37)=(-(params(15)*y(15)*T323));
  g1(17,11)=(-y(34));
  g1(17,15)=y(42);
  g1(17,34)=(-y(11));
  g1(17,35)=(-1);
  g1(17,42)=y(15);
  g1(18,43)=1;
  g1(19,7)=T17*params(2)*y(38);
  g1(19,8)=T17*params(2)*y(38);
  g1(19,38)=1+T17*(-(params(2)*(1-y(8)-y(7))));
  g1(19,40)=1/params(17);
  g1(20,21)=y(40)*(-(1/params(18)*T399));
  g1(20,39)=1;
  g1(20,40)=(-(T380*1/params(18)));
  g1(21,20)=y(40)*(-(1/params(18)*T399));
  g1(21,21)=y(41)*(-(T389*getPowerDeriv(y(21),1-params(19),2)))+y(40)*(-(y(20)/params(18)*1/params(3)*1/params(3)*getPowerDeriv(y(21)/params(3),(-1),2)));
  g1(21,40)=(-(y(20)/params(18)*T399));
  g1(21,41)=T393;
  g1(22,9)=y(42)*(-exp(y(22)))+y(27)*(-(exp(y(22))/y(15)));
  g1(22,11)=T260;
  g1(22,15)=T314;
  g1(22,22)=T419;
  g1(22,27)=T416;
  g1(22,29)=T413;
  g1(22,42)=(-(y(9)*exp(y(22))));
  g1(22,44)=1+params(23)*(-params(21));
  g1(23,29)=T45;
  g1(23,45)=1+params(23)*(-params(22));
  g1(24,3)=(-params(1));
  g1(24,4)=1;
  g1(25,1)=y(2)/(1+y(16));
  g1(25,2)=(1+y(1))/(1+y(16));
  g1(25,16)=T335;
  g1(26,2)=1;
  g1(26,3)=(-((T28*T55-T67*T68)/(T28*T28)));
  g1(26,4)=T93;
  g1(26,8)=(-(T193/T28));
  g1(27,3)=y(9);
  g1(27,5)=1;
  g1(27,9)=T225;
  g1(27,10)=params(8);
  g1(27,15)=T313;
  g1(27,22)=T416;
  g1(28,6)=1;
  g1(29,3)=T45;
  g1(29,6)=(-(T129*(1-params(9))));
  g1(29,7)=T160-T160*(1-params(9))*y(6);
  g1(29,11)=T259;
  g1(29,22)=T413;
  g1(29,23)=T45;
  g1(30,7)=params(9);
  g1(30,8)=1;
  g1(31,7)=(-(1-y(9)));
  g1(31,8)=y(9);
  g1(31,9)=1-(1-y(8)-y(7));
  g1(32,9)=(-(T218*(T214*(1-(1-params(9)))-(y(9)-y(9)*(1-params(9)))*T236)/(T214*T214)));
  g1(32,10)=1;
  g1(33,12)=1;
  g1(33,13)=T286;
  g1(33,14)=T300;
  g1(34,6)=(-(y(13)*T142));
  g1(34,11)=(-y(17));
  g1(34,13)=1-T142*y(6);
  g1(34,16)=(-(y(13)*y(6)*params(15)*T323));
  g1(34,17)=(-y(11));
  g1(35,6)=(-(y(14)*T152));
  g1(35,14)=1-T152*y(6);
  g1(35,16)=(-(y(14)*y(6)*T346));
  g1(35,17)=(-1);
  g1(36,12)=T276;
  g1(36,16)=T330;
  g1(37,12)=T269;
  g1(37,15)=1-T142;
  g1(37,16)=(-(params(15)*y(15)*T323));
  g1(38,7)=(-(y(19)*(-params(2))));
  g1(38,8)=(-(y(19)*(-params(2))));
  g1(38,19)=1-params(2)*(1-y(8)-y(7));
  g1(39,7)=(-(params(8)*T160/T38));
  g1(39,20)=1;
  g1(40,19)=1/params(17);
  g1(40,20)=(-(T380*1/params(18)));
  g1(40,21)=(-(y(20)/params(18)*T399));
  g1(41,3)=1;
  g1(41,21)=T393;
  g1(42,9)=(-exp(y(22)));
  g1(42,15)=y(17);
  g1(42,17)=y(15);
  g1(42,22)=(-(y(9)*exp(y(22))));
  g1(43,3)=(-(y(9)*T28));
  g1(43,4)=T86;
  g1(43,5)=T105;
  g1(43,9)=(-(log(y(3))-log(y(4))));
  g1(43,18)=1;
  g1(44,22)=1-params(21);
  g1(45,23)=1-params(22);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],45,2025);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],45,91125);
end
end
end
end
