function [config_binary_new0, config_full_new0, profit_iter, flag_iter, carrier_ind_iter, ...
    oem_ind_iter, q_iter, fc_mean_iter, p_iter, w_iter, ...
    share_iter, cons_surplus_iter, cons_surplus_no_error, expmu, carrier_profit_iter,...
    p_sim_iter, w_sim_iter, share_sim_iter]...
    ...
    = prod_equi_swap(...
    ...
    config_binary_init, binary_prod, config_full_init, full_prod, fixed_prod, ...
    x_rand, firm_seq, sim_pcoeff, sim_qcoeff, sim_rand,  ...
    mc_param_q, nfc, n_carrier, max_iter_count, n_top_gap, setup, starting_point_option)

n_oem = size(config_binary_init,1);

if ismember(setup.counterfactual, {'product_decision_simultaneous_1iter'})
    max_iter_count = 1;
end

% delete firm who has no potential products, i.e., not considered
for no = 1:n_oem
    if isempty(cell2mat(config_binary_init(no,:)'))
        firm_seq(firm_seq == no) = [];
    end
end

if setup.merge && length(setup.merge_id)>1
    merged_firms = intersect(firm_seq, setup.merge_id);
    if length(merged_firms)>1
        firm_seq(ismember(firm_seq, merged_firms(2:end))) = [];
    end
end

config_binary_start0 = config_binary_init;
config_full_start0 = config_full_init;

% best response of firm 1: check all the one step deviation
% 1. if no product is there, try adding one
% 2. if thre are some products, but #<max_k, try adding one
% 3. with 2, also try dropping one
if isequal(setup.BR_method, 'one_product') % for each firm, find best-response using one-product-swamp
    config_changed = true;
    iter_count_Jacobi = 0;
    
    
    while config_changed && iter_count_Jacobi<max_iter_count
        d_profit_all = -1*ones(length(firm_seq), 1);
        
        config_binary_start = config_binary_start0; % in the case of merge_2_firms_simultaneous, config_binary_start and config_binary_start0 are always identical
        config_full_start = config_full_start0;% in the case of merge_2_firms_simultaneous, config_full_start and config_full_start0 are always identical
        
        config_binary_new0 = config_binary_init;
        config_full_new0 = config_full_init;

        for n_iter = 1:length(firm_seq)
            n = firm_seq(n_iter);

            config_binary_n_start = config_binary_start;
            config_full_n_start = config_full_start;

            if isequal(starting_point_option, 'full')
                if setup.merge && ismember(n, setup.merge_id)
                    for nnr = setup.merge_id
                        config_binary_n_start{nnr} = ones(size(config_binary_n_start{nnr}));
                        config_binary_n_start{nnr} = ones(size(config_binary_n_start{nnr}));
                    end
                else
                    config_binary_n_start{n} = ones(size(config_binary_n_start{n}));
                    config_binary_n_start{n} = ones(size(config_binary_n_start{n}));
                end
            elseif isequal(starting_point_option, 'null')
                if setup.merge && ismember(n, setup.merge_id)
                    for nnr = setup.merge_id
                        config_binary_n_start{nnr} = zeros(size(config_binary_n_start{nnr}));
                        config_binary_n_start{nnr} = zeros(size(config_binary_n_start{nnr}));
                    end
                else
                    config_binary_n_start{n} = zeros(size(config_binary_n_start{n}));
                    config_binary_n_start{n} = zeros(size(config_binary_n_start{n}));
                end
            end

            d_profit = 1;
            iter_count = 0;


            [oem_profit_start, ~, ~, ~, ~, ~, ~,...
                cons_surplus_start, ~, ~, carrier_profit_start, ~, ...
                ~, ~, prod_profit_binary_start, prod_profit_full_start]...
                = equi_ind(config_binary_n_start, binary_prod, ...
                config_full_n_start, full_prod, fixed_prod, ...
                setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                sim_pcoeff, ...
                sim_qcoeff, sim_rand, mc_param_q);

            if setup.merge && ismember(n, setup.merge_id)
                n_tmp = setup.merge_id;
            else
                n_tmp = n;
            end

            [fc_start, prod_fc_binary_start, prod_fc_full_start]...
                = compute_fc(config_binary_n_start, binary_prod, ...
                config_full_n_start, full_prod, n_top_gap, nfc);

            oem_profit_fc_start = sum(oem_profit_start(n_tmp)) - sum(fc_start(n_tmp));


            prod_profit_fc_binary_start = cell(n_oem, 1);
            prod_profit_fc_full_start = cell(n_oem, 1);

            for no = 1 : n_oem

                n_binary = length(config_binary_n_start{no});

                ppfbs_no = nan(n_binary, 1);
                for nb = 1 : n_binary
                    if config_binary_n_start{no}(nb)==1
                        ppfbs_no(nb) = prod_profit_binary_start{no}(nb)-...
                            prod_fc_binary_start{no}(nb);
                    else
                        ppfbs_no(nb) = 0;
                    end
                end

                prod_profit_fc_binary_start{no} = ppfbs_no;


                if ~isempty(full_prod{no})
                    ppffs_no = nan(n_top_gap, 1);
                    for ntg = 1 : n_top_gap
                        if config_full_n_start{no}(ntg)>0
                            ppffs_no(ntg) = prod_profit_full_start{no}(ntg)-...
                                prod_fc_full_start{no}(ntg);
                        else
                            ppffs_no(ntg) = 0;
                        end
                    end
                else
                    ppffs_no = zeros(n_top_gap, 1);
                end

                prod_profit_fc_full_start{no} = ppffs_no;
            end

            if any(isnan(oem_profit_start))
                error('unknown error in pricing equilibrium calculation');
            end

            config_considered0.binary = config_binary_n_start;
            config_considered0.full = config_full_n_start;
            config_considered = {config_considered0};
            % config that have been considered and are dominated

            while d_profit>0 && iter_count<max_iter_count
                disp(['iter_Jacobi=', num2str(iter_count_Jacobi) ', n_iter=' num2str(n_iter) ', oem=' num2str(n) ', iter_count=' num2str(iter_count)]);

                [config_binary_n_new, config_full_n_new, ...
                    config_considered_updated, ...
                    oem_profit_fc_new, d_profit] = ...
                    one_product_swap_BR(config_binary_n_start, ...
                    binary_prod, config_full_n_start, full_prod, ...
                    oem_profit_fc_start, prod_profit_fc_binary_start, ...
                    prod_profit_fc_full_start, config_considered, n, ...
                    sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q,...
                    fixed_prod, n_carrier, n_top_gap, nfc, ...
                    x_rand, setup);

                if setup.merge && ismember(n, setup.merge_id)
                    tmp1 = config_binary_n_start(setup.merge_id,:); tmp1 = tmp1(:); tmp1 = cell2mat(tmp1)';
                    tmp2 = config_binary_n_new(setup.merge_id,:); tmp2 = tmp2(:); tmp2 = cell2mat(tmp2)';
                    tmp3 = config_full_n_start(setup.merge_id, :); tmp3 = tmp3(:); tmp3 = cell2mat(tmp3); tmp3 = tmp3(:)';
                    tmp4 = config_full_n_new(setup.merge_id, :); tmp4 = tmp4(:); tmp4 = cell2mat(tmp4); tmp4 = tmp4(:)';
                else
                    tmp1 = config_binary_n_start(n,:); tmp1 = tmp1(:); tmp1 = cell2mat(tmp1)';
                    tmp2 = config_binary_n_new(n,:); tmp2 = tmp2(:); tmp2 = cell2mat(tmp2)';
                    tmp3 = config_full_n_start(n, :); tmp3 = tmp3(:); tmp3 = cell2mat(tmp3); tmp3 = tmp3(:)';
                    tmp4 = config_full_n_new(n, :); tmp4 = tmp4(:); tmp4 = cell2mat(tmp4); tmp4 = tmp4(:)';
                end
                disp('[config_init; config_new]='); disp([[tmp1, tmp3]; [tmp2, tmp4]]);

                config_binary_n_start = config_binary_n_new;
                config_full_n_start = config_full_n_new;
                oem_profit_fc_start = oem_profit_fc_new;


                iter_count = iter_count + 1;
                config_considered = config_considered_updated;
                d_profit_all(n_iter) = d_profit;
            end

            if ismember(setup.counterfactual, {'merge_2_firms_seq1',...
                    'merge_2_firms_seq2','no_cannibalization'})
                config_binary_start = config_binary_n_new;
                config_full_start = config_full_n_new;

                config_binary_new0 = config_binary_n_new;
                config_full_new0 = config_full_n_new;
            elseif ismember(setup.counterfactual, ...
                    {'merge_2_firms_simultaneous', 'no_cannibalization_simultaneous'})
                if ismember(n, setup.merge_id)
                    for nnr = setup.merge_id
                        config_binary_new0{nnr} = config_binary_n_new{nnr};
                        config_full_new0{nnr} = config_full_n_new{nnr};
                    end
                else
                    config_binary_new0{n} = config_binary_n_new{n};
                    config_full_new0{n} = config_full_n_new{n};
                end
            end

        end

        iter_count_Jacobi = iter_count_Jacobi + 1;
        config_changed = ...
            ~isequal(config_binary_new0, config_binary_start0) |...
            ~isequal(config_full_new0, config_full_start0);
        
        % display
        disp(['Jacobi iteration ', num2str(iter_count_Jacobi), ' finished']);
        for no = 1 : n_oem
            
            n_prod_diff = sum(config_binary_start0{no})...
                - sum(config_binary_new0{no});
            
            if n_prod_diff>0
                disp(['OEM ', num2str(no), ' dropped ',...
                    num2str(n_prod_diff), ' products']);
            elseif n_prod_diff<0
                disp(['OEM ', num2str(no), ' added ',...
                    num2str(-n_prod_diff), ' products']);
            end
            
            if ~isempty(config_full_new0{no})
                for ntg = 1 : n_top_gap
                    if config_full_start0{no}(ntg)~=config_full_new0{no}(ntg)
                        disp(['OEM ', num2str(no), ' switched from ',...
                            num2str(config_full_start0{no}(ntg)), ' to ', ...
                            num2str(config_full_new0{no}(ntg)), ' at new quality ', ...
                            num2str(ntg)]);
                    end
                end
            end
        end
        
        % update
        config_binary_start0 = config_binary_new0;
        config_full_start0 = config_full_new0;
        
    end
    
    if ismember(setup.counterfactual, {'merge_2_firms_seq1',...
            'merge_2_firms_seq2', 'no_cannibalization', ...
            'merge_2_firms_simultaneous', 'no_cannibalization_simultaneous'})
        d_profit_max = max(d_profit_all);
    else
        d_profit_max = -1;
    end
elseif isequal(setup.BR_method, 'test_two_prod_deviations')
    
    
    % profit at the starting point
    oem_profit_start = ...
        equi_ind(config_binary_init, binary_prod, ...
        config_full_init, full_prod, fixed_prod, ...
        setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
        sim_pcoeff, ...
        sim_qcoeff, sim_rand, mc_param_q);
    
    for n_iter = 1 : length(firm_seq)
        no = firm_seq(n_iter);
        
        if setup.merge && ismember(no, setup.merge_id)
            n_tmp = setup.merge_id;
        else
            n_tmp = no;
        end
        
        fc_start ...
            = compute_fc(config_binary_init, binary_prod, ...
            config_full_init, full_prod, n_top_gap, nfc);
        
        oem_profit_fc_start = sum(oem_profit_start(n_tmp)) - sum(fc_start(n_tmp));
        
        config_binary_n = config_binary_init;
        config_full_n = config_full_init;
        
        % binary binary
        n_binary = length(config_binary_n{no});
        for nb1 = 1 : n_binary-1
            for nb2 = nb1+1 : n_binary
                config_binary_n_full2 = config_binary_n;
                config_binary_n_full2{no}(nb1) = 1 - config_binary_n_full2{no}(nb1);
                config_binary_n_full2{no}(nb2) = 1 - config_binary_n_full2{no}(nb2);
                
                oem_profit_f2 = ...
                    equi_ind(config_binary_n_full2, binary_prod, ...
                    config_full_init, full_prod, fixed_prod, ...
                    setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                    sim_pcoeff, ...
                    sim_qcoeff, sim_rand, mc_param_q);
                
                fc_f2 ...
                    = compute_fc(config_binary_n_full2, binary_prod, ...
                    config_full_init, full_prod, n_top_gap, nfc);
                
                oem_profit_fc_tmp = sum(oem_profit_f2(n_tmp)) - sum(fc_f2(n_tmp));
                
                if oem_profit_fc_tmp>oem_profit_fc_start
                    
                    config_binary_new0 = config_binary_n_full2;
                    config_full_new0 = config_full_init;
                    
                    return;
                end
            end
        end
        
        
        % binary full
        for nb1 = 1 : n_binary
            for ntg = 1 : n_top_gap
                for ic = 0 : n_carrier
                    config_binary_n_fb = config_binary_n;
                    config_full_n_fb = config_full_n;
                    
                    config_binary_n_fb{no}(nb1) = 1-config_binary_n_fb{no}(nb1);
                    
                    if config_full_n_fb{no}(ntg) ~=ic
                        config_full_n_fb{no}(ntg) = ic;
                        
                        oem_profit_fb = ...
                            equi_ind(config_binary_n_fb, binary_prod, ...
                            config_full_n_fb, full_prod, fixed_prod, ...
                            setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                            sim_pcoeff, ...
                            sim_qcoeff, sim_rand, mc_param_q);
                        
                        fc_fb ...
                            = compute_fc(config_binary_n_fb, binary_prod, ...
                            config_full_n_fb, full_prod, n_top_gap, nfc);
                        
                        oem_profit_fc_tmp = sum(oem_profit_fb(n_tmp)) - sum(fc_fb(n_tmp));
                        
                        if oem_profit_fc_tmp>oem_profit_fc_start
                            
                            config_binary_new0 = config_binary_n_fb;
                            config_full_new0 = config_full_n_fb;
                            
                            return;
                        end
                        
                    end
                    
                end
            end
        end
        
        % full full
        for ntg1 = 1 : n_top_gap-1
            for ntg2 = ntg1+1 : n_top_gap
                for ic1 = 0 : n_carrier
                    for ic2 = 0 : n_carrier
                        
                        config_full_n_f2 = config_full_n;
                        
                        if config_full_n_f2{no}(ntg1) ~=ic1 && config_full_n_f2{no}(ntg2) ~=ic2
                            config_full_n_f2{no}(ntg1) = ic1;
                            config_full_n_f2{no}(ntg2) = ic2;
                            
                            oem_profit_f2 = ...
                                equi_ind(config_binary_n, binary_prod, ...
                                config_full_n_f2, full_prod, fixed_prod, ...
                                setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
                                sim_pcoeff, ...
                                sim_qcoeff, sim_rand, mc_param_q);
                            
                            fc_f2 ...
                                = compute_fc(config_binary_n, binary_prod, ...
                                config_full_n_f2, full_prod, n_top_gap, nfc);
                            
                            oem_profit_fc_tmp = sum(oem_profit_f2(n_tmp)) - sum(fc_f2(n_tmp));
                            
                            if oem_profit_fc_tmp>oem_profit_fc_start
                                
                                config_binary_new0 = config_binary_n;
                                config_full_new0 = config_full_n_f2;
                                
                                return;
                            end
                        end
                    end
                end
            end
        end
        
        
    end
    
    config_binary_new0 = config_binary_init;
    config_full_new0 = config_full_init;
    
end

if ~isequal(setup.BR_method, 'test_two_prod_deviations')
    
    [profit_iter, carrier_ind_iter, ...
        oem_ind_iter, q_iter, p_iter, w_iter, share_iter, ...
        cons_surplus_iter, cons_surplus_no_error, expmu, carrier_profit_iter,...
        p_sim_iter, w_sim_iter, share_sim_iter] ...
        = equi_ind(config_binary_new0, binary_prod, ...
        config_full_new0, full_prod, fixed_prod, ...
        setup, n_top_gap, n_carrier, setup.n_draws, x_rand, ...
        sim_pcoeff, ...
        sim_qcoeff, sim_rand, mc_param_q);
    
    fc_mean_iter = compute_fc(config_binary_new0, binary_prod, ...
        config_full_new0, full_prod, n_top_gap, nfc);
    
    if d_profit_max>0
        flag_iter = -1;
    elseif d_profit_max==0
        flag_iter = 0;
    else
        flag_iter = 1;
    end
    
    if iter_count_Jacobi>=max_iter_count-1
        flag_iter = -2;
    end
end