/*

This file reshapes and links data sets together.

*/

* Open firm level tax data
use "W:\stata\yritykset_s_2005.dta", clear
 gen year=2005 
 compress
 append using "W:\stata\yritykset_s_2006.dta"
 replace year=2006 if year==.
 compress
 append using "W:\stata\yritykset_s_2007.dta"
 replace year=2007 if year==.
 compress
 append using "W:\stata\yritykset_s_2008.dta"
 replace year=2008 if year==.
 compress
 append using "W:\stata\yritykset_s_2009.dta"
 replace year=2009 if year==.
 compress
 append using "W:\stata\yritykset_s_2010.dta"
 replace year=2010 if year==.
 compress
 append using "W:\stata\yritykset_s_2011.dta"
 replace year=2011 if year==.
 compress
 append using "W:\stata\yritykset_s_2012.dta"
 replace year=2012 if year==.
 compress
 append using "W:\stata\yritykset_s_2013.dta"
 replace year=2013 if year==.
 compress
 append using "W:\stata\yritykset_s_2014.dta", force
 replace year=2014 if year==.
 compress
 append using "W:\stata\yritykset_s_2015.dta", force
 replace year=2015 if year==.

 compress
 sort yritys_id year
 order yritys_id year
 compress
 order yritys_id verovuosi aslaji laani romyht xtilintarkast xkirjpvoitto opotulos uusikulu uusitulo vomyht komyht rom* vom* opoyht nettovarall kuntanro  kuluera1 kuluera2 palkkakulu elakekulut henkilokulumuu henkkulutyht kulukiint uusikulu elakekulu henklkm_r kuntanro oikmuoto talakoodi osingonjako osinkomaara  nostamatta henklkm_r yhtvero nettovarall nettovarall_ed lukumaara lunastettulkm liikevaihto valitonvero nostamatta vastattavayht  pysaineettyht pysijoituksetyht muuttuotot liikevoittotap tilikvoittotap vpaaomayht vraharvopapyht romyht tvlarvopaperi tvlkiinteisto tvlosakaslaina tvlmuu tvlyht hkvuokratuotto hkosinkotuotto
 keep yritys_id verovuosi aslaji laani romyht xtilintarkast xkirjpvoitto opotulos uusikulu uusitulo vomyht komyht rom* vom* opoyht nettovarall kuntanro kuluera1 kuluera2 palkkakulu elakekulut henkilokulumuu henkkulutyht kulukiint uusikulu elakekulu henklkm_r kuntanro oikmuoto talakoodi osingonjako osinkomaara  nostamatta henklkm_r yhtvero nettovarall nettovarall_ed lukumaara lunastettulkm liikevaihto valitonvero  nostamatta vastattavayht   vvaihtoomyht  pysaineettyht pysijoituksetyht muuttuotot liikevoittotap tilikvoittotap vpaaomayht romyht tvlarvopaperi tvlkiinteisto tvlosakaslaina tvlmuu tvlyht hkvuokratuotto hkosinkotuotto vraharvopapyht matemarvo1 matemarvo2 pyorva1 pyorva2 lukumaara lunastettulkm nettovarall sulnettovarall  vvaihtoomyht  pysaineettyht pysijoituksetyht tavarloppu varastomuutos2 pysaineellyht vpankkisaamiset verotvarelt pysmaajavesi pysrakennukset pyskoneetkalus pysmuuthyodykk vvvalmtuotteet vraharvopapyht vrahat varatyht kiinteisto konekalu komarvopaperi komyht romraha romarvopaperi romsiirtosaam rompankki rommuu romyht romyht
 duplicates tag yritys_id verovuosi, gen(tag)
 tab tag
save "W:\Data\yritykset_s_2005_2015_sample.dta", replace

clear

use "W:\Data\yritykset_s_2005_2015_sample.dta", clear
 br if tag>0
 tab tag aslaji
 keep if aslaji=="S"
 drop tag
 duplicates tag yritys_id verovuosi, gen(tag)
 tab tag
 gen vuosi=verovuosi
save "W:\Data\yritykset_s_2005_2015_sample_oyt.dta", replace


* Reshapes the insurance data for Y insured - first data source
use "W:\stata\inscomp_a_s_2008.dta", clear
 gen year=2008 
 append using "W:\stata\inscomp_a_s_2009.dta"
 replace year=2009 if year==.
 append using "W:\stata\inscomp_a_s_2010.dta"
 replace year=2010 if year==.
 append using "W:\stata\inscomp_a_s_2011.dta"
 replace year=2011 if year==.
 append using "W:\stata\inscomp_a_s_2012.dta"
 replace year=2012 if year==.
 append using "W:\stata\inscomp_a_s_2013.dta"
 replace year=2013 if year==.
 gen SJ_PAATPVM1=date(SJ_PAATPVM, "DMY##")
 gen VJ_PAATPVM1=date(VJ_PAATPVM, "DMY##")
 drop SJ_PAATPVM VJ_PAATPVM
 ren SJ_PAATPVM1 SJ_PAATPVM
 ren VJ_PAATPVM1 VJ_PAATPVM
 destring SJ_PAATSYY VJ_PAATSYY, replace force
 format SJ_PAATPVM %td
 format VJ_PAATPVM %td
save "W:\Data\inscomp_a_s_2008_2013.dta", replace

 use "W:\stata\inscomp_a_s_2000.dta", clear
 gen year=2000
 append using "W:\stata\inscomp_a_s_2001.dta"
 replace year=2001 if year==.
 append using "W:\stata\inscomp_a_s_2002.dta"
 replace year=2002 if year==.
 append using "W:\stata\inscomp_a_s_2003.dta"
 replace year=2003 if year==.
 append using "W:\stata\inscomp_a_s_2004.dta"
 replace year=2004 if year==.
 append using "W:\stata\inscomp_a_s_2005.dta"
 replace year=2005 if year==.
 append using "W:\stata\inscomp_a_s_2006.dta"
 replace year=2006 if year==.
 append using "W:\stata\inscomp_a_s_2007.dta"
 replace year=2007 if year==.
 append using "W:\Data\inscomp_a_s_2008_2013.dta"
 replace SJ_PAATSYY=SJ_PAATPVM1 if year==2002
 drop SJ_PAATPVM1
 sort Tk_tutnro vakuutus_id year
 order Tk_tutnro vakuutus_id year
 compress
save "W:\Data\inscomp_a_s_2000_2013.dta", replace

use "W:\stata\inscomp_a_jaksot_s.dta", clear
 drop if Tk_tutnro==""|vakuutus_id=="" 
 duplicates drop Tk_tutnro Suhdejakso_alkamisp_iv_ Vakuutusjakson_alk_ Vakuutusjakson_p__t_ Ty_tulojakson_alk Ty_tulojakson_p__t_ Vahvistettu_ty_tulo Indeksivuosi Vakuutuksen_tila p__ttymissyy edellinen_el_keyhti_, force
 sort Tk_tutnro vakuutus_id 
 order Tk_tutnro vakuutus_id
 gen jakso_alkaa=year(Ty_tulojakson_alk)
 gen jakso_loppuu=year(Ty_tulojakson_p__t_)
 gen jakso_alkaa_kk=month(Ty_tulojakson_alk)
 gen jakso_loppuu_kk=month(Ty_tulojakson_p__t_)
 gen YM_alku=ym(jakso_alkaa,jakso_alkaa_kk)
 gen YM_loppu=ym(jakso_loppuu,jakso_loppuu_kk)
 format YM_alku YM_loppu %tm
 egen group=group(Tk_tutnro)
 
 replace jakso_loppuu=2015 if jakso_loppuu==.
 gen vuodenvaihde="31122000" if jakso_alkaa==2000
 replace vuodenvaihde="31122001" if jakso_alkaa==2001
 replace vuodenvaihde="31122002" if jakso_alkaa==2002
 replace vuodenvaihde="31122003" if jakso_alkaa==2003
 replace vuodenvaihde="31122004" if jakso_alkaa==2004
 replace vuodenvaihde="31122005" if jakso_alkaa==2005
 replace vuodenvaihde="31122006" if jakso_alkaa==2006
 replace vuodenvaihde="31122007" if jakso_alkaa==2007
 replace vuodenvaihde="31122008" if jakso_alkaa==2008
 replace vuodenvaihde="31122009" if jakso_alkaa==2009
 replace vuodenvaihde="31122010" if jakso_alkaa==2010
 replace vuodenvaihde="31122011" if jakso_alkaa==2011
 replace vuodenvaihde="31122012" if jakso_alkaa==2012
 replace vuodenvaihde="31122013" if jakso_alkaa==2013
 replace vuodenvaihde="31122014" if jakso_alkaa==2014
 replace vuodenvaihde="31122015" if jakso_alkaa==2015

 gen vuodenvaihde_alku=date(vuodenvaihde, "DMY")
 drop vuodenvaihde
 gen vuodenvaihde="31121999" if jakso_loppuu==2000
 replace vuodenvaihde="31122000" if jakso_loppuu==2001
 replace vuodenvaihde="31122001" if jakso_loppuu==2002
 replace vuodenvaihde="31122002" if jakso_loppuu==2003
 replace vuodenvaihde="31122003" if jakso_loppuu==2004
 replace vuodenvaihde="31122004" if jakso_loppuu==2005
 replace vuodenvaihde="31122005" if jakso_loppuu==2006
 replace vuodenvaihde="31122006" if jakso_loppuu==2007
 replace vuodenvaihde="31122007" if jakso_loppuu==2008
 replace vuodenvaihde="31122008" if jakso_loppuu==2009
 replace vuodenvaihde="31122009" if jakso_loppuu==2010
 replace vuodenvaihde="31122010" if jakso_loppuu==2011
 replace vuodenvaihde="31122011" if jakso_loppuu==2012
 replace vuodenvaihde="31122012" if jakso_loppuu==2013
 replace vuodenvaihde="31122013" if jakso_loppuu==2014
 replace vuodenvaihde="31122014" if jakso_loppuu==2015

 gen vuodenvaihde_loppu=date(vuodenvaihde, "DMY")
 drop vuodenvaihde
 gen pvm_lkm_alk=vuodenvaihde_alku - Ty_tulojakson_alk
 gen pvm_lkm_lop=Ty_tulojakson_p__t_ - vuodenvaihde_loppu
 sort Tk_tutnro vakuutus_id Ty_tulojakson_alk Ty_tulojakson_p__t_
 gen työtulo_pvm=Vahvistettu_ty_tulo/365
 
 egen henk_vak_id=group(Tk_tutnro vakuutus_id)
 duplicates tag henk_vak_id jakso_alkaa, gen(tag)
 br if tag>1
 replace pvm_lkm_alk=Ty_tulojakson_p__t_ - Ty_tulojakson_alk if tag>1&jakso_alkaa==jakso_loppuu

 by Tk_tutnro, sort: gen jakso_alkaa1=jakso_alkaa+1 if jakso_loppuu[_n-1]==jakso_alkaa
 replace jakso_alkaa=jakso_alkaa1 if jakso_alkaa1!=.&Ty_tulojakson_p__t_!=.&jakso_alkaa!=jakso_loppuu
 gen muutettu_jakso_alkaa=1 if jakso_alkaa1!=.&Ty_tulojakson_p__t_!=.&jakso_alkaa!=jakso_loppuu
 duplicates tag henk_vak_id jakso_alkaa, gen(tag1)
 tab tag1
 br if tag1==1

 by henk_vak_id jakso_alkaa, sort: egen pvm_lkm_alk1=max(pvm_lkm_alk)
 drop if tag1==1&Ty_tulojakson_p__t_!=.&jakso_alkaa==jakso_loppuu&pvm_lkm_alk1!=pvm_lkm_alk
 drop if tag1==1&Ty_tulojakson_p__t_!=.&jakso_alkaa==jakso_loppuu&pvm_lkm_alk1!=pvm_lkm_alk
 replace jakso_alkaa=Indeksivuosi if tag1==1&Ty_tulojakson_p__t_!=.&jakso_alkaa==jakso_loppuu
 drop if tag1==1&Ty_tulojakson_p__t_!=.&jakso_alkaa==jakso_loppuu

 drop tag1
 replace jakso_alkaa=jakso_alkaa1 if jakso_alkaa1!=.&Ty_tulojakson_p__t_!=.&jakso_alkaa!=jakso_loppuu
 duplicates tag henk_vak_id jakso_alkaa, gen(tag1)
 tab tag1
 br if tag1==1
 drop if tag1==1&Ty_tulojakson_p__t_!=.&jakso_alkaa==jakso_loppuu

 drop tag1
 duplicates tag henk_vak_id jakso_alkaa, gen(tag1)
 tab tag1

 sort henk_vak_id Ty_tulojakson_p__t_
 by henk_vak_id, sort: gen lkm=_n
  by henk_vak_id, sort: egen maxlkm=max(lkm)
 drop if tag1>0&maxlkm!=lkm
  drop tag1
 duplicates tag henk_vak_id jakso_alkaa, gen(tag1)
 tab tag1
 
 by Tk_tutnro, sort: gen työtulo_lask=työtulo_pvm*pvm_lkm_lop + työtulo_pvm*pvm_lkm_alk[_n+1] if pvm_lkm_lop!=.&pvm_lkm_alk==.
 replace työtulo_lask=työtulo_pvm*pvm_lkm_lop if työtulo_lask==.&jakso_loppuu!=2015
 
 drop jakso_alkaa1 lkm maxlkm tag1 työtulo_pvm pvm_lkm_lop pvm_lkm_alk vuodenvaihde_loppu vuodenvaihde_alku
 
 forvalues i=2000(1)2015 {
 gen Vahvistettu_työtulo`i'=Vahvistettu_ty_tulo if jakso_alkaa<=`i'&jakso_loppuu>=`i'
 gen työtulo_lask`i'=työtulo_lask if jakso_alkaa<=`i'&jakso_loppuu>=`i'
 }
   by henk_vak_id, sort: gen ttulo1511=Vahvistettu_työtulo2015[_n+1] if jakso_loppuu[_n+1]==jakso_loppuu
   replace Vahvistettu_työtulo2015=. if ttulo1511!=.
  drop ttulo1511
  
  foreach var of varlist Vahvistettu_työtulo2000-työtulo_lask2015 {
  by henk_vak_id, sort: egen `var'm=min(`var')
  replace `var'=`var'm
  drop `var'm
  }
  duplicates drop henk_vak_id, force
  drop tag group
  drop työtulo_lask
 reshape long  Vahvistettu_työtulo työtulo_lask, i(Tk_tutnro vakuutus_id) j(vuosi)

save "W:\Data\inscomp_a_jaksot_s_2.dta", replace


use "W:\stata\inscomp_a_maksut_s.dta", clear
 drop if Tk_tutnro==""|vakuutus_id=="" 
 gen vuosi=Maksun_kohdevuosi
 merge m:1 Tk_tutnro vakuutus_id using "W:\Data\inscomp_a_yel_s_2.dta"
 ren _merge merge_yel_s
 drop if vuosi==.
 save  "W:\Data\inscomp_a_maksut_yel_s.dta", replace

 use "W:\Data\inscomp_a_jaksot_s_2.dta", clear
 sum Vahvistettu_työtulo työtulo_lask
 gen runko=1
 merge 1:1 Tk_tutnro vakuutus_id vuosi using "W:\Data\inscomp_a_maksut_yel_s.dta"
 ren _merge merge_maksut_yel
 sum Vahvistettu_työtulo työtulo_lask
 sum Vahvistettu_työtulo työtulo_lask if merge_maksut_yel==3
 keep if runko==1
 foreach var of varlist Vahvistettu_työtulo työtulo_lask Maksu {
 by Tk_tutnro vuosi, sort: egen sum`var'=sum(`var')
 replace `var'=sum`var'
 drop sum`var'
 }
 duplicates drop Tk_tutnro vuosi, force
 gen inscomp_a=1
save  "W:\Data\inscomp_a_jaksot_maksut_yel.dta", replace


* Reshapes the insurance data for Y insured - second data source
use "W:\stata\inscomp_b_yel.dta", clear
 drop if Tk_tutnro=="" | kohdevuosi==.
 gen työtulo_päät=date(tt_paatpvm,"DMY")
 format työtulo_päät %td
 duplicates tag kohdevuosi Tk_tutnro, gen(tag)
 tab tag
 order Tk_tutnro kohdevuosi työtulo_päät
 sort Tk_tutnro kohdevuosi työtulo_päät
 br if tag>0
 by Tk_tutnro kohdevuosi, sort: gen lkm=_n
 by Tk_tutnro kohdevuosi, sort: egen Yelmaksu=sum(yelmaksu)
 by Tk_tutnro kohdevuosi, sort: egen max=max(lkm)
 drop if tag>0&lkm!=max
 gen vuosi=kohdevuosi
 gen inscomp_b=1
save "W:\Data\inscomp_b_jaksot_maksut_yel.dta", replace


* links social insurance contributions to owner- and firm-level data.
 * Open owner-level tax data
use "W:\stata\shareholder_panel_2000_2015_s.dta", clear
 gen vuosi=nostovuosi
 drop if Tk_tutnro==""|vuosi==.
 order Tk_tutnro vuosi
 gen core=1
 sort Tk_tutnro vuosi
 duplicates tag Tk_tutnro vuosi, gen(tag)
 tab tag
 gen no_firms=tag+1
 foreach var of varlist osinkoyht_yr palkka_omasta - nettoeltulos {
 by Tk_tutnro vuosi, sort: egen `var's=sum(`var')
 replace `var'=`var's
 }
 duplicates drop Tk_tutnro vuosi, force
 merge m:1 yritys_id vuosi using "W:\Data\yritykset_s_2005_2015_sample_oyt.dta"
 keep if core==1
 ren _merge merge_yritykset

 merge 1:1 Tk_tutnro vuosi using "W:\Data\inscomp_a_jaksot_maksut_yel.dta"
 keep if core==1
 gen YEL=1 if _merge==3
 ren _merge merge_inscomp_a
 merge 1:1 Tk_tutnro vuosi using "W:\Data\inscomp_b_jaksot_maksut_yel.dta"
 keep if core==1
 replace YEL=1 if _merge==3
 ren _merge merge_inscomp_b
 tab yelmyel_vakuutettu YEL
 tab vuosi YEL
 tab vuosi yelmyel_vakuutettu
 tab vuosi
save  "W:\Data\shareholder_yritykset_inscomp_a_inscomp_b.dta", replace


* private pensions savings from one company
use "W:\stata\inscomp_c_elakkeet.dta", clear
 drop if Tk_tutnro=="" 
 order Tk_tutnro
 sort Tk_tutnro
 duplicates tag Tk_tutnro, gen(tag)
 tab tag
 foreach var of varlist Maksut_2000- Maksut_2015 Kaikki_maksut Vakuutuss__st_Yht {
 by Tk_tutnro, sort: egen m`var'=sum(`var')
 replace `var'=m`var'
 drop m`var'
 }
 drop Viim__suunn__muk__maksupv tag Maksusuunnitelma  Alkup_iv_ Asiakastyyppi Tila Tuote
 duplicates drop Tk_tutnro, force
 reshape long Maksut_, i(Tk_tutnro) j(vuosi)
 ren Maksut_ Maksut_eläke
 ren Kaikki_maksut Kaikki_eläke
 ren Vakuutuss__st_Yht Vakuutus_eläke_yht
 drop VUEl_kkeen_alkupvm VUEl_kkeen_kesto_v1 VUEl_kkeen_kesto_kk1 VUEl_kkeen_kesto_v2 VUEl_kkeen_kesto_kk2
save  "W:\Data\inscomp_c_elakkeet_muokatut.dta", replace

 
* private insurances from one company
use "W:\stata\inscomp_c_saasto.dta", clear
 drop if Tk_tutnro=="" 
 order Tk_tutnro
 sort Tk_tutnro
 duplicates tag Tk_tutnro, gen(tag)
 tab tag
  foreach var of varlist Maksut_2000- Maksut_2015 Kaikki_maksut Vakuutuss__st_Yht {
 by Tk_tutnro, sort: egen m`var'=sum(`var')
 replace `var'=m`var'
 drop m`var'
 }
 drop Viim__suunn__muk__maksupv tag Maksusuunnitelma P__ttymisp_iv_ Alkup_iv_ Asiakastyyppi Tila Tuote
 duplicates drop Tk_tutnro, force
 reshape long Maksut_, i(Tk_tutnro) j(vuosi)
 ren Maksut_ Maksut_säästö
 ren Kaikki_maksut Kaikki_säästö
 ren Vakuutuss__st_Yht Vakuutus_säästö_yht
 save  "W:\Data\inscomp_c_säästöt_muokatut.dta", replace

 
* links social security contribution, owner- and firm-level data sets together
use "W:\Data\shareholder_yritykset_inscomp_a_inscomp_b.dta", clear
 merge 1:1 Tk_tutnro vuosi using "W:\Data\inscomp_c_elakkeet_muokatut.dta"
 ren _merge merge_eläke
 merge 1:1 Tk_tutnro vuosi using "W:\Data\inscomp_c_säästöt_muokatut.dta"
 ren _merge merge_säästö
save  "W:\Data\shareholder_yritykset_inscomp_a_inscomp_b_vapeht_säästö.dta", replace


* cleans the data set and defines the ownershipshare for entrepreneurs
use "W:\Data\shareholder_yritykset_inscomp_a_inscomp_b_vapeht_säästö.dta", clear

* keep only individual owners
keep if osakastyyppi=="H"

* calculate the owhernshipshare for each owner
gen double ownership=osakkeidenlkm/lukumaara
gen ownershipshare=osinko/osinkoyht_yr
replace ownershipshare=1 if ownershipshare>1&ownershipshare!=.
order YEL owners*
replace ownership=ownershipshare if ownership==.&ownershipshare!=.&ownershipshare!=0
replace ownership=1 if ownership>1&ownership!=.

gen yel=1 if YEL==1
replace yel=0 if yelmyel_vakuutettu==0&yel!=1

replace Vahvistettu_työtulo=tt_vuotuinen/100 if inscomp_b==1
replace Maksu=Yelmaksu/100 if inscomp_b==1

replace Vahvistettu_työtulo=. if Vahvistettu_työtulo==0&yel==1
replace Vahvistettu_työtulo=. if Vahvistettu_työtulo==0

gen ilm_tt=Vahvistettu_työtulo 
replace ilm_tt=lpalkat if yel!=1
replace ilm_tt=. if ilm_tt==0

gen telmaksu=tyel_pros*lpalkat 
gen ownrshp=round(ownership, 0.001)
gen dummy=1 if Maksu!=.
replace dummy=0 if Maksu==.

gen dummy2=1 if Maksu!=.
replace dummy2=0 if yelmyel_vakuutettu==0
replace dummy2=. if yelmyel_vakuutettu==1&(Maksu==.|Maksu==0)
replace dummy2=1 if yelmyel_vakuutettu==1&Maksu!=0

gen vakmaksut=telmaksu if dummy2==0
replace vakmaksut=Maksu if dummy2==1

egen ID=group(Tk_tutnro)
tsset ID vuosi

*keep only years after 2004
drop if vuosi<2005

* log sales
gen llv=log(liikevaihto)

save "W:\Data\final_data.dta", replace
