/*

This file plots Figure A4 in the Appendix.

*/

use "W:\Data\final_data.dta", clear
set matsize 2999
 
gen tr2=1 if ownership>0.30&ownership<=0.50&no_firms==1
replace tr2=0 if ownership>0.50&ownership<=0.7&no_firms==1

gen tr2_2=1 if ownership>0.30&ownership<=0.50&no_firms==1 & vuosi==2010
replace tr2_2=0 if ownership>0.50&ownership<=0.7&no_firms==1 & vuosi==2010
gen dtr2_2=D.tr2_2 

gen changer=1 if dtr2_2!=0 & vuosi<2011 & dtr2_2!=.
by ID, sort: egen Changer=min(changer)

gen tr2_3=1 if ownership>0.30&ownership<=0.50&no_firms==1 
replace tr2_3=0 if ownership>0.50&ownership<=0.7&no_firms==1 
gen dtr2_3=D.tr2_3 

drop changer Changer
gen changer=1 if dtr2_3!=0 & dtr2_3!=.
by ID, sort: egen Changer=min(changer)

gen payment_pros=vakmaksut/Vahvistettu_työtulo
local x=tyel_pros

gen downership=D.ownership
gen nosto=1 if downership>.01&downership!=.
gen lasku=1 if downership<-.01&downership!=.
gen sama=1 if abs(downership)<=.01&downership!=.

foreach var of varlist nosto lasku sama {
replace `var'=0 if `var'==.&abs(downership)<=.01&downership!=.
}

preserve
gen alle=1 if ownership<=0.30&no_firms==1&ownership!=.
gen yli=1 if ownership>0.30&no_firms==1&ownership!=.
tsset ID vuosi
gen ylittää=1 if L.alle==1&yli==1
replace ylittää=0 if no_firms==1&ownership!=.&ylittää!=1
by vuosi, sort: egen mylittää=mean(ylittää)
replace mylittää=mylittää*100
duplicates drop vuosi if no_firms==1&mylittää!=., force
scatter mylittää vuosi if vuosi>2005, xline(2010.5) ylabel(0(0.5)2) scheme(s2mono) graphr(c(white)) xtitle(Year) xlabel(2006(1)2015) ytitle("%") legend(cols(2) pos(6) order(1)  /*
*/lab(1 "Below 30% ownership")) subtitle("Changes from <30% to >30% ownership") name(change_Y_T, replace)
graph export "W:\Kuvat\Final\changes_30_ownershipshare.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\changes_30_ownershipshare.eps", replace 
restore

preserve
gen alle=1 if ownership<=0.50&no_firms==1&ownership!=.
gen yli=1 if ownership>0.50&no_firms==1&ownership!=.
tsset ID vuosi
gen ylittää=1 if L.alle==1&yli==1
replace ylittää=0 if no_firms==1&ownership!=.&ylittää!=1
by vuosi, sort: egen mylittää=mean(ylittää)
replace mylittää=mylittää*100
duplicates drop vuosi if no_firms==1&mylittää!=., force
scatter mylittää vuosi if vuosi>2005, xline(2010.5) ylabel(0(0.5)2) scheme(s2mono) graphr(c(white)) xtitle(Year) xlabel(2006(1)2015) ytitle("%") legend(cols(2) pos(6) order(1)  /*
*/lab(1 "Below 30% ownership")) subtitle("Changes from <50% to >50% ownership") name(change_Y_T2, replace)
graph export "W:\Kuvat\Final\changes_50_ownershipshare.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\changes_50_ownershipshare.eps", replace 
restore

preserve
gen alle=1 if ownership<=0.50&no_firms==1&ownership!=.
gen yli=1 if ownership>0.50&no_firms==1&ownership!=.
tsset ID vuosi
gen ylittää=1 if alle==1&L.yli==1
replace ylittää=0 if no_firms==1&ownership!=.&ylittää!=1
by vuosi, sort: egen mylittää=mean(ylittää)
replace mylittää=mylittää
replace mylittää=mylittää*100
duplicates drop vuosi if no_firms==1&mylittää!=., force
scatter mylittää vuosi if vuosi>2005, xline(2010.5) ylabel(0(0.5)2) scheme(s2mono) graphr(c(white)) xtitle(Year) xlabel(2006(1)2015) ytitle("%") legend(cols(2) pos(6) order(1)  /*
*/lab(1 "Below 30% ownership")) subtitle("Changes from >50% to <50% ownership") name(change_Y_T3, replace)
graph export "W:\Kuvat\Final\changes_50_ownershipshare_snd.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\changes_50_ownershipshare_snd.eps", replace 
restore


