/*

This file plots Figure A7.

*/

* Open the Statistics Finland firm data 
use "W:\Data\tilyr_88_16.dta" , clear
gen syrtun_maktun=syrtun
gen verovuosi=vuosi
gen aloitusaika=substr(aloaika, 1,6)
gen aloitusvuosi=substr(aloaika, 1,4)
gen lopetusaika=substr(lopaika, 1,6)
gen lopetusvuosi=substr(lopaika, 1,4)
destring aloitusvuosi aloitusaika lopetusaika lopetusvuosi, replace
foreach var of varlist aloitusvuosi aloitusaika lopetusaika lopetusvuosi {
by syrtun, sort: egen min`var'=min(`var')
replace `var'=min`var'
drop min`var'
}
preserve
duplicates drop syrtun, force
keep syrtun_maktun aloitusvuosi aloitusaika lopetusaika lopetusvuosi aloaika lopaika
save "W:\Data\firm_birth_dates.dta", replace
restore

duplicates drop syrtun_maktun verovuosi, force
merge 1:m syrtun_maktun verovuosi using "W:\Data\shareholder_panel_1997_2016_sample.dta" 

merge m:1 syrtun_maktun using "W:\Data\firm_birth_dates.dta", gen(Merge) update

keep if _merge==3 | Merge==4

gen ownershipshare=omistusosuus
replace ownershipshare=omistusosuus2 if ownershipshare==.
replace ownershipshare=1 if ownershipshare>1&ownershipshare!=.

gen treat=1 if ownershipshare>0.3&ownershipshare<=0.5
replace treat=0 if ownershipshare>0.5&ownershipshare<=0.7

gen post=1 if verovuosi>2010 & verovuosi!=.
replace post=0 if verovuosi<=2010 & verovuosi!=.

preserve
by verovuosi treat, sort: egen no_firms=count(verovuosi)
duplicates drop syrtun_maktun aloitusvuosi, force
tab aloitusvuosi if treat==1
tab aloitusvuosi if treat==0
by aloitusvuosi treat, sort: egen no_aloittaneet=count(vuosi)
by aloitusvuosi treat, sort: egen no_firms_t=min(no_firms)
keep treat no_firms no_aloittaneet no_firms_t vuosi aloitusvuosi post
duplicates drop aloitusvuosi treat, force
save "W:\Data\no_firms_entry.dta", replace
restore

preserve
by verovuosi treat, sort: egen No_firms=count(verovuosi)
duplicates drop syrtun_maktun lopetusvuosi, force
tab lopetusvuosi if treat==1
tab lopetusvuosi if treat==0
by lopetusvuosi treat, sort: egen no_lopettaneet=count(vuosi)
by lopetusvuosi treat, sort: egen No_firms_t=min(No_firms)
keep treat No_firms no_lopettaneet No_firms_t vuosi lopetusvuosi post
duplicates drop lopetusvuosi treat, force
save "W:\Data\no_firms_exit.dta", replace
restore

preserve
use "W:\Data\no_firms_entry.dta", clear

keep if aloitusvuosi>2004&aloitusvuosi<2014
replace aloitusvuosi=aloitusvuosi+1
scatter no_aloittaneet aloitusvuosi if treat==1, ms(circle) mc(gs4) || scatter no_aloittaneet aloitusvuosi if treat==0, ms(diamond) || /*
*/ line no_aloittaneet aloitusvuosi if treat==1, lp(shortdash) || line no_aloittaneet aloitusvuosi if treat==0, lp(dash) graphr(c(white)) scheme(s2mono) /*
*/ legend(cols(2) order(1 2) lab(1 "Treatment") lab(2 "Control") pos(6)) xline(2010.8, lp(dash)) ytitle("") xtitle("") subtitle(Number of new firms) ylabel(0(300)1200)/*
*/ name(no_new_firms, replace)
graph export "W:\Kuvat\Final\no_new_firms.png", replace width(1600) height(1200)

gen share_firms=no_aloittaneet/no_firms

scatter share_firms aloitusvuosi if treat==1, ms(circle) mc(gs4) || scatter share_firms aloitusvuosi if treat==0, ms(diamond) || /*
*/ line share_firms aloitusvuosi if treat==1, lp(shortdash) || line share_firms aloitusvuosi if treat==0, lp(dash) graphr(c(white)) scheme(s2mono) /*
*/ legend(cols(2) order(1 2) lab(1 "Treatment") lab(2 "Control") pos(6)) xline(2010.8, lp(dash)) ytitle("Entry rate") xtitle("") subtitle("Entry rates over time") ylabel(0(0.02)0.1)/*
*/ name(share_new_firms, replace)
graph export "W:\Kuvat\Final\share_new_firms.png", replace width(1600) height(1200)

xi: reg share_firms i.post*treat

use "W:\Data\no_firms_exit.dta", clear

keep if lopetusvuosi>2004&lopetusvuosi<2014
replace lopetusvuosi=lopetusvuosi+1
scatter no_lopettaneet lopetusvuosi if treat==1, ms(circle) mc(gs4) || scatter no_lopettaneet lopetusvuosi if treat==0, ms(diamond) || /*
*/ line no_lopettaneet lopetusvuosi if treat==1, lp(shortdash) || line no_lopettaneet lopetusvuosi if treat==0, lp(dash) graphr(c(white)) scheme(s2mono) /*
*/ legend(cols(2) order(1 2) lab(1 "Treatment") lab(2 "Control") pos(6)) xline(2010.8, lp(dash)) ytitle("") xtitle("") subtitle(Number of exiting firms) ylabel(0(100)400)/*
*/ name(no_died_firms, replace)
graph export "W:\Kuvat\Final\no_died_firms.png", replace width(1600) height(1200)

gen share_firms=no_lopettaneet/No_firms

scatter share_firms lopetusvuosi if treat==1, ms(circle) mc(gs4) || scatter share_firms lopetusvuosi if treat==0, ms(diamond) || /*
*/ line share_firms lopetusvuosi if treat==1, lp(shortdash) || line share_firms lopetusvuosi if treat==0, lp(dash) graphr(c(white)) scheme(s2mono) /*
*/ legend(cols(2) order(1 2) lab(1 "Treatment") lab(2 "Control") pos(6)) xline(2010.8, lp(dash)) ytitle("Exit rate") xtitle("") subtitle("Exit rates over time") ylabel(0(0.02)0.1)/*
*/ name(share_died_firms, replace)
graph export "W:\Kuvat\Final\share_died_firms.png", replace width(1600) height(1200)

drop post
gen post=1 if lopetusvuosi>2010 & lopetusvuosi!=.
replace post=0 if lopetusvuosi<=2010 & lopetusvuosi!=.

xi: reg share_firms i.post*treat

restore
*
