/*
*
This file produces most of the figures and tables in the paper and in the appendix.
 * Figures 1-3 and A5.
 * Tables 1-2, A4 and A6.
*/

* Open data
use "W:\Data\final_data.dta", clear
 set matsize 2999
 
* define treatment status
gen tr2=1 if ownership>0.30&ownership<=0.50&no_firms==1
replace tr2=0 if ownership>0.50&ownership<=0.7&no_firms==1

foreach var of varlist palkkakulu konekalu tvlarvopaperi kuluera1 kokotulo lpalkat osinko male ika liikevaihto varatyht velkayht opoyht henklkm_r {
replace `var'=0 if `var'==. & (tr2==0|tr2==1)
}

* log sales
* gen llv=log(liikevaihto)
* log wage sum
gen lpalkkakulu=log(palkkakulu)
* log variable costs
gen lkuluera1=log(kuluera1)
* log number of employees
gen lhenklkm_r=log(henklkm_r)

* Post period
gen post=1 if vuosi>2010
replace post=0 if vuosi>2005&vuosi<2011

* round ownershipshare 
 gen wnrsp=round(ownership, 0.01)
 by ID, sort: egen min_ownrsp=min(wnrsp)

* log investments 
 gen lkonekalu=log(konekalu)

 foreach var of varlist llv lkuluera1 lpalkkakulu lnettoeltulos lkokotulo llpalkat ltvlyht ltvlarvopaperi lkonekalu lopoyht lhenklkm_r{
 gen miss_d_`var'=1 if `var'==0 | `var'==.
 replace miss_d_`var'=0 if miss_d_`var'==.
 replace `var'=0 if `var'==.
 }

 * Municipality code
 gen KUNTANRO=kuntanro
 destring KUNTANRO, replace force
 by ID, sort: egen KuntaNro=min(KUNTANRO)
 
* industry codes
 gen eka_tala=substr(talakoodi, 1,1)
 destring eka_tala, replace
 by ID, sort: egen Eka_tala=min(eka_tala)
 
* Heterogeneity by age of the firm -- by young (5 years) vs old
by yritys_id, sort: egen minimi_vuosi=min(vuosi)
gen age_firm=vuosi-minimi_vuosi
by yritys_id, sort: egen AGE=max(age_firm)
gen young=1 if tr2!=. & AGE<=5
by yritys_id, sort: egen Young=min(young)
gen old=1 if tr2!=. & AGE>5
by yritys_id, sort: egen Old=min(old)
replace Young=0 if tr2!=. & Old==1
replace Young=2 if tr2!=. & Young==.
replace young=0 if tr2!=. & AGE>5

* descriptive statistics - Table 1
 * also by young and old firms 
tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==0, stat(mean median N) 
tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==1, stat(mean median N)

tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==0 & Young==1, stat(mean median N) 
tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==1 & Young==1, stat(mean median N)

tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==0 & Young==0, stat(mean median N) 
tabstat vakmaksut liikevaihto palkkakulu konekalu tvlarvopaperi kuluera1 henklkm_r if vuosi>=2006 & vuosi<=2010 & tr2==1 & Young==0, stat(mean median N)

gen eff1=.
gen eff1up=.
gen eff1lo=.
gen eff2=.
gen eff2up=.
gen eff2lo=.
gen xaxs=_n
sort xaxs
********
*******
******
*****
****
***
**
*

* Figure 1
xi: reg lvvakmaksut i.vuosi if tr2==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lvvakmaksut i.vuosi if tr2==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2015 || line eff1 eff2 xaxs if xaxs>2005&xaxs<2015, fxsize(60)/*
*/ note("") ylabel(-0.2(0.1)0.2) xlabel(2006(2)2014) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle("All firms") scheme(s2mono) name(ppps_dd, replace)

sort xaxs
xi: reg lvvakmaksut i.vuosi if tr2==1 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lvvakmaksut i.vuosi if tr2==0 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2015  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2015, /*
*/ note("") xlabel(2006(2)2014) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Young firms) scheme(s2mono) name(pps_young_firm, replace)

sort xaxs
xi: reg lvvakmaksut i.vuosi if tr2==1 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lvvakmaksut i.vuosi if tr2==0 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2015  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2015, /*
*/ note("") ylabel(-0.2(0.1)0.2) xlabel(2006(2)2014) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Old firms) scheme(s2mono) name(pps_old_firm, replace)

* Figure 1
grc1leg pps_young_firm pps_old_firm, scheme(s2mono) graphr(c(white)) name(both, replace) iscale(1) graphr(margin(zero))
grc1leg ppps_dd both, scheme(s2mono) graphr(c(white)) name(both3, replace) cols(1) note("") subtitle("Change in social insurance contributions") 
graph export "W:\Kuvat\Final\Figure_1.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\Figure_1.eps", replace


*****************************************************************************

* Appendix Figure A5
xi: reg llv i.vuosi if tr2==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg llv i.vuosi if tr2==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016 || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle("Sales") scheme(s2mono) name(loglv_dd, replace)

xi: reg lpalkkakulu i.vuosi if tr2==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lpalkkakulu i.vuosi if tr2==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}

twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016 || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle("Labor costs") scheme(s2mono) name(wagecosts_dd, replace)


xi: reg lkonekalu i.vuosi if tr2==1 
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lkonekalu i.vuosi if tr2==0 
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Investments in machines and equipment) scheme(s2mono) name(real_invest_dd, replace)

xi: reg ltvlarvopaperi i.vuosi if tr2==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg ltvlarvopaperi i.vuosi if tr2==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016 || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Stock holdings) scheme(s2mono) name(logtvlarvopaperi_dd, replace)

* online appendix fig 2: all
grc1leg loglv_dd wagecosts_dd real_invest_dd logtvlarvopaperi_dd, scheme(s2mono) graphr(c(white)) note("") 
graph export "W:\Kuvat\Final\Appendix_Fig_2.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\Appendix_Fig_2.eps", replace


*****************************************************************************

* Figure 2
sort xaxs
xi: reg llv i.vuosi if tr2==1 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg llv i.vuosi if tr2==0 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Sales) scheme(s2mono) name(llv_young_firm, replace)

xi: reg lpalkkakulu i.vuosi if tr2==1 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lpalkkakulu i.vuosi if tr2==0 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Labor costs) scheme(s2mono) name(wagecosts_young_firm, replace)

xi: reg lkonekalu i.vuosi if tr2==1 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lkonekalu i.vuosi if tr2==0 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Investments in machines and equipment) scheme(s2mono) name(real_invest_young_firm, replace)


xi: reg ltvlarvopaperi i.vuosi if tr2==1 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg ltvlarvopaperi i.vuosi if tr2==0 & Young==1
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Stock holdings) scheme(s2mono) name(stocks_young_firm, replace)

* Figure 2: Young
grc1leg llv_young_firm wagecosts_young_firm real_invest_young_firm stocks_young_firm, scheme(s2mono) graphr(c(white)) subtitle(Young firms) note("")
graph export "W:\Kuvat\Final\Figure_2.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\Figure_2.eps", replace

*****************************************************************************

* Figure 3
xi: reg llv i.vuosi if tr2==1 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg llv i.vuosi if tr2==0 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) ylabel(0(0.1)0.4) subtitle(Sales) scheme(s2mono) name(llv_old_firm, replace)

xi: reg lpalkkakulu i.vuosi if tr2==1 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lpalkkakulu i.vuosi if tr2==0 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Labor costs) scheme(s2mono) name(wagecosts_old_firm, replace)

xi: reg lkonekalu i.vuosi if tr2==1 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg lkonekalu i.vuosi if tr2==0 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Investments in machines and equipment) scheme(s2mono) name(real_invest_old_firm, replace)


xi: reg ltvlarvopaperi i.vuosi if tr2==1 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff1=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff1up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff1lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
xi: reg ltvlarvopaperi i.vuosi if tr2==0 & Young==0
forvalues i = 2006(1)2015 {
qui{
local c=`i'
replace eff2=_b[_Ivuosi_`i']-_b[_Ivuosi_2010] in `c'
replace eff2up=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]+1.96*_se[_Ivuosi_`i'] in `c'
replace eff2lo=_b[_Ivuosi_`i']-_b[_Ivuosi_2010]-1.96*_se[_Ivuosi_`i'] in `c'
}
}
twoway scatter eff1 eff2 xaxs if xaxs>2005&xaxs<2016  || line eff1 eff2 xaxs if xaxs>2005&xaxs<2016, /*
*/ note("") xlabel(2006(2)2015) xline(2010.5, lp(dash)) xtitle("") ytitle("") legend(cols(2) pos(6) order(1 2) /*
*/ lab(1 "Treatment") lab(2 "Control")) graphr(c(white)) subtitle(Stock holdings) scheme(s2mono) name(stocks_old_firm, replace)

* Figure 3: Old
grc1leg llv_old_firm wagecosts_old_firm real_invest_old_firm stocks_old_firm, scheme(s2mono) graphr(c(white)) subtitle(Old firms)  note("")
graph export "W:\Kuvat\Final\Figure_3.png", replace width(1600) height(1200)
graph export "W:\Kuvat\Final\Figure_3.eps", replace

*****************************************************************************

* Table 2 - all
* without controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_13052019.xls", append

* Table 2 -- Young
* without controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_13052019.xls", append

* Table 2 -- Old
* without controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_13052019.xls", append

* Do p test for coefficient difference between young and old
 log using "W:\Kuvat\Final\test_dd.log", replace
putexcel set "W:\Kuvat\Final\p_test.xlsx", replace
putexcel a2="Estimate"
putexcel a3="se"
putexcel a4="T stat"
putexcel a5="p value"

xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel b1="lvvakmaksut"
putexcel b2=(r(estimate))
putexcel b3=(r(se))
putexcel b4=(r(z))
putexcel b5=(r(p))

xi: reg llv i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg llv i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel c1="llv"
putexcel c2=(r(estimate))
putexcel c3=(r(se))
putexcel c4=(r(z))
putexcel c5=(r(p))

xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel d1="lpalkkakulu"
putexcel d2=(r(estimate))
putexcel d3=(r(se))
putexcel d4=(r(z))
putexcel d5=(r(p))

xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg lkonekalu i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel e1="lkonekalu"
putexcel e2=(r(estimate))
putexcel e3=(r(se))
putexcel e4=(r(z))
putexcel e5=(r(p))

xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel f1="ltvlarvopaperi"
putexcel f2=(r(estimate))
putexcel f3=(r(se))
putexcel f4=(r(z))
putexcel f5=(r(p))

xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg lkuluera1 i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel g1="lkuluera1"
putexcel g2=(r(estimate))
putexcel g3=(r(se))
putexcel g4=(r(z))
putexcel g5=(r(p))

xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==1
est store young
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 if Young==0
est store old
suest young old
lincom [young_mean]_IposXtr2_1_1 - [old_mean]_IposXtr2_1_1
putexcel h1="lhenklkm_r"
putexcel h2=(r(estimate))
putexcel h3=(r(se))
putexcel h4=(r(z))
putexcel h5=(r(p))

 log close
 
order yritys_id no_firms ID tr2 Tk_tu*
gen TRe2=1 if ownership>0.30&ownership<=0.50
replace TRe2=0 if ownership>0.50&ownership<=0.7

*****************************************************************************

* Table A4 -- all
 * without controls
  * all firms
xi: reg lvvakmaksut i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", replace
xi: reg llv i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.TRe2, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_all_15052019.xls", append


* Table A4 -- Young
 * without controls
  * all firms
xi: reg lvvakmaksut i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", replace
xi: reg llv i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.TRe2 if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_young_all_15052019.xls", append


* Table A4 -- Old
* without controls
* all firms
xi: reg lvvakmaksut i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", replace
xi: reg llv i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.TRe2 if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_no_controls_old_all_15052019.xls", append


*****************************************************************************

 
* ROBUST
 * Table A6 - all
  * with controls
gen ika2=ika*ika
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_13052019.xls", append


* Table A6 - Young
 * with controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==1, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_young_13052019.xls", append


* Table A6 - Old
 * with controls
xi: reg lvvakmaksut i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", replace
xi: reg llv i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append
xi: reg lpalkkakulu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append
xi: reg lkonekalu i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append
xi: reg ltvlarvopaperi i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append
xi: reg lkuluera1 i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append
xi: reg lhenklkm_r i.vuosi i.post*i.tr2 i.Eka_tala ika ika2 male round_ownership i.KuntaNro if Young==0, robust
outreg2 using "W:\Kuvat\Final\dd_log_controls_robust_old_13052019.xls", append

