******* ANALYSIS  FOR CONSTRAINED SAMPLE

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

use "$work\p1_daycare_muni_ever_yrapproval.dta", clear

label var operating "Any Approved Preschool at Age 3"

****************** REGRESSIONS ***************************

*mainouts
foreach vars of varlist $mainout {

	
	 areg `vars' operating  $style1 , abs(muni) cl(muni)

	estimates store `vars'2
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  $style2 , abs(muni) cl(muni)
			
	estimates store `vars'3
	qui sum `vars'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
	estadd scalar dv=`r(mean)'
	
	

}

/*Creates the table  */
file open myfile using "$results\mainout_p1.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	 			 		\\" _n 
file close myfile
foreach vars of global mainout  {
	estout `vars'* using "$results\mainout_p1.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\mainout_p1.tex", write append
do $dofiles\tabbottom.do


/*Creates the table  */
file open myfile using "$results\indexhc_p1.tex", write replace
file write myfile "\begin{tabular}{p{2in} cc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  				 		\\" _n 
file close myfile
foreach vars of varlist index_hc  surv65 {
	estout `vars'* using "$results\indexhc_p1.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Control mean, dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "\multirow{2}{2in}{${title_`vars'}}" ) ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\indexhc_p1.tex", write append
do $dofiles\tabbottom.do



eststo clear
foreach var in $mainout {
eststo: areg `var' operating nurse_treat daycare_nurse  $style2, abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\mainout_DAY_NURSE_p1.tex", keep(operating nurse_treat daycare_nurse) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Yrs. School" "More than Comp" "Log Wage Inc" "Survival beyond age 65" ) ;
#delimit cr




eststo clear
foreach var of varlist index_hc surv65 {
eststo: areg `var' operating nurse_treat daycare_nurse  $style2, abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\index_DAY_NURSE_p1.tex", keep(operating nurse_treat daycare_nurse) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("Human Capital Index" "Survival beyond age 65" ) ;
#delimit cr


