do "D:\Data\workdata\704665\daycare\dofiles\first.do"
********************************************************************************************************
* makes some maps for the daycare exposure for munis
* the map shows municipalities 
* Figure 1A
********************************************************************************************************

use "$work\analysis_daycare_muni_ever_yrapproval.dta", clear

sort muni year operating
bys muni: egen fstyear_daycare = mean(afstyear)
drop afstyear

*for munis that had daycare by 1933:
replace fstyear_daycare = 1920 if fstyear_daycare==.


keep muni fstyear_daycare

bys muni: keep if _n==1

ren muni ID
sort ID

* map for 1950 muni structure
merge 1:1 ID using "$map\\kommune1950.dta"

* in the 1950 muni structure there is 1 muni with an always open daycare that we cannot find - changes in admin structure over time. 
*daycare map

gen treatment=1 if fstyear_daycare<=1930 
replace treatment=2 if fstyear_daycare>1930 & fstyear_daycare<=1935
replace treatment=3 if fstyear_daycare>1935 & fstyear_daycare<=1940
replace treatment=4 if fstyear_daycare>1940 & fstyear_daycare<=1945
replace treatment=5 if fstyear_daycare>1945 & fstyear_daycare<=1950
replace treatment=6 if fstyear_daycare>1950 & fstyear_daycare<=1955
replace treatment=7 if fstyear_daycare>1955 & fstyear_daycare<=1960
replace treatment=0 if fstyear_daycare==.

label define treatment1  0 "No preschool" 1 "Pre-1930" 2 "1931-1935" 3 "1936-1940" 4 "1941-1945" 5 "1946-1950" 6 "1951-1955" 7 "1956-1960"
label values treatment treatment1

spmap treatment using "$map\kommune_coordinates1950", id(_ID) fcolor(Reds)  legend(position(2)) clm(unique)  saving("$graphs\graphs_may15\map_daycare_munic.png", replace)
graph export "$graphs\graphs_may15\map_daycare_munic.png", replace
