do "D:\Data\workdata\704665\daycare\dofiles\first.do"

*********************************************************************************************************
* finds the population of interest for the prescohool analyses (among the survivors until 1980): 

* next: merges on geographic information on the parish-munic-county codes
* and adds the exposure measure (preschool)
*********************************************************************************************************

use "$work\pop3060.dta", clear
*cohorts born in 1930-1960

gen male=(koen==1)
label var male "Male"
drop koen

* constrain cohorts
keep if fodyear>=1930 & fodyear<=1957

*hardcoding Skanderborg
replace fodreg=9166 if fodreg==8008 /*there is a mistake in the fodreg data we have from digdag - does not match DSTs documentation, Skanderborg is 8008 there*/

* merge on Kommune_ID  
gen year=fodyear
merge m:1 fodreg  using "$work\parish_munic_county.dta"
keep if _merge==3
drop year _merge
compress

*********************************************************************************************************
save "$work\pop_daycare.dta", replace
*********************************************************************************************************

*********************************************************************************************************
****** add daycare data
*********************************************************************************************************

use "$work\pop_daycare.dta", clear

*Merge to daycare data using parish and year of age 3
gen year = fodyear+3
merge m:1 Sognekode_IM year using "$work\daycareslots_byyear_yrapproval_parish.dta", keep(match master)

*replace daycare variables with zero for unmerged parishes
replace numinst = 0 if _merge==1
replace operating = 0 if _merge==1
replace numslots = 0 if _merge==1
replace numasylum = 0 if _merge==1
replace numdaycare = 0 if _merge==1

drop _merge

label var Sognekode_IM "Parish code 1955"
label var Kommune_ID "Muni code 1955"

*** calculate number institutions, slots by municipality x year
preserve
bys Sognekode_IM year: keep if _n==1

*calculate number institutions, slots by municipality x year
sort Kommune_ID year
by Kommune_ID year: egen numinst_muni = total(numinst)
by Kommune_ID year: egen numslots_muni = total(numslots)
by Kommune_ID year: egen operating_muni = max(operating)
by Kommune_ID year: egen numasylum_muni = total(numasylum)
by Kommune_ID year: egen numdaycare_muni = total(numdaycare)

keep Kommune_ID year numinst_muni numslots_muni operating_muni numasylum_muni numdaycare_muni

by Kommune_ID year: keep if _n==1

save "$work\daycareslots_bymuniyear_yrapproval.dta", replace

**** descriptive graph on share of munis with daycare center (ALL munis including those without a daycare center ever)
collapse (sum) numslots numinst (mean) operating, by(year)

line operating year, lwidth(medthick) xtitle(Year) ytitle(Proportion Municipalities with Preschool) xlabel(1933(5)1960)
graph export "$graphs\anyinst_muni_byyear_yrapproval.png", replace

restore

merge m:1 Kommune_ID year using "$work\daycareslots_bymuniyear_yrapproval.dta", keep(match master)
drop _merge

compress

*********************************************************************************************************
save "$work\pop_daycare_exposure_yrapproval.dta", replace
*********************************************************************************************************


* merge on controls
use "$work\pop_daycare_exposure_yrapproval.dta", clear

cap drop _merge
merge m:1 Kommune_ID year using "$work\popsize_munics_reshaped19301960.dta", keep(match master)
keep if _merge==3
drop _merge

gen urbanstring=substr(Kommunenavn, -12,.)
gen rural=(urbanstring=="Sognekommune")
drop urbanstring
label var rural "Rural munics"

foreach var of varlist numinst_muni numslots_muni {
gen `var'_perpop=(`var'/popmunic)*1000
}

label var numinst_muni_perpop "No of institutions in munic per 1000 pop"
label var numslots_muni_perpop "No of daycare slots in munic per 1000 pop"


* plot the measures that are per 1000 pop (with the interpolated pop measure)
preserve

sort Kommune_ID year
by Kommune_ID year: gen help1=_n
keep if help1==1
collapse (mean) numslots_muni_perpop numinst_muni_perpop operating_muni, by(year)

sort year
line numslots_muni_perpop year, lwidth(medthick) xtitle(Year) ytitle(Avg Number Slots per 1000 Pop in Muni) xlabel(1933(5)1960)
graph export "$graphs\numslotspop_bymuniyear_yrapproval.png", replace


line numinst_muni_perpop year, lwidth(medthick) xtitle(Year) ytitle(Avg Number Preschools per 1000 Pop in Muni) xlabel(1933(5)1960)
graph export "$graphs\numinstpop_bymuniyear_yrapproval.png", replace

line operating_muni year, lwidth(medthick) xtitle(Year) ytitle(Operating preschool in municipality) xlabel(1933(5)1960)
graph export "$graphs\operating_munic_yrapproval.png", replace

restore

preserve

sort Kommune_ID year
by Kommune_ID year: gen help1=_n
keep if help1==1
collapse (mean) operating_muni numinst_muni numinst_muni_perpop, by(year rural)
tab rural
line operating_muni year if rural==0 || line operating_muni year if rural==1, lwidth(medthick) xtitle(Year) ytitle(Operating preschool in municipality) xlabel(1933(5)1960)
graph export "$graphs\operating_munic_urbrur.png", replace

line numinst_muni year if rural==0 || line numinst_muni year if rural==1, lwidth(medthick) xtitle(Year) ytitle(No of preschool centers in municipality) xlabel(1933(5)1960)
graph export "$graphs\numinst_munic_urbrur.png", replace


line numinst_muni_perpop year if rural==0 || line numinst_muni_perpop year if rural==1, lwidth(medthick) xtitle(Year) ytitle(No of preschool centers/per 1000 pop in municipality) xlabel(1933(5)1960)
graph export "$graphs\numinstperpop_munic_urbrur.png", replace

restore


*drop parish-level exposure variables
drop operating numinst numslots numasylum numdaycare 

ren operating_muni operating
ren numinst_muni numinst
ren numslots_muni numslots
ren numasylum_muni numasylum
ren numdaycare_muni numdaycare

ren numinst_muni_perpop numinstperpop
ren numslots_muni_perpop numslotsperpop


*********************************************************************************************************
compress
save "$work\pop_daycare_popmunic_yrapproval.dta", replace
*********************************************************************************************************

