do "D:\Data\workdata\704665\daycare\dofiles\first.do"

*************************************************************
* uses raw data on nbr of live births and 1. year mortality for all counties of DK
* to compare our cohort size to those
*************************************************************
******* compare births per year to our population data
******************************************************************

use "$work/births_percounty.dta", clear
merge m:1 year using "$work\posize_national.dta"

keep if idmed==666 // identifies counties - not by urban/rural parts of counties

gen survivors=lb-firstyrmort /*whom should we have in the register data*/
gen missingobs=survivors-borndk /*the difference btw the ones we should have and all DK born individuals irrespective of parish match*/

gen pct_miss = missingobs/survivors

gen share_validparish=validparish/survivors /*share of the 1 yr survivors in our data with a valid parish*/

gen validanddk= validparish/borndk
****** graph of pct_miss by year

line validanddk year , lwidth(medthick) xtitle(Birth Year) ytitle(Percentage with valid parish of all DK births) xlabel(1930(3)1951)
graph export "$graphs\graphs_march2016\pct_validp_borndk_byyearALL.png", replace


* Appendix Figure C1
line pct_miss year , lwidth(medthick) xtitle(Birth Year) ytitle(Pct of Cohort Missing from Pop Data (relative to 1yr survivors)) xlabel(1930(3)1951)
graph export "$graphs\graphs_march2016\pct_miss_byyearALL.png", replace

