****************** Individual level analysis
* Appendix Table A4

do "D:\Data\workdata\704665\daycare\dofiles\first.do"


use "$work\pop_daycare_popmunic_yrapproval_indiv.dta",clear

*** keep a uniform sample with non-missing outcomes for different groups of outcomes

gen nonmissedu = year50!=. & morethanbasic50!=. 

* indiv data results for first and second gen
* combined table

eststo clear
foreach var in $hc {
areg `var' operating  $styleind2  , abs(muni) cl(muni)
estimates store `var'
sum `var'_raw if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)': `var'
}


preserve
use "$work/indiv_kidsdata.dta", clear
dis _N

eststo clear
foreach var in $kidedu25 {
areg `var' operating  $styleind2 , abs(muni) cl(muni)
estimates store `var'
qui sum `e(depvar)' if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)': `var'
}
restore


#delimit ;
esttab index_hc surv65  yrsschool25_kid morethanbasic25_kid gymnasium25_kid  using  "$results\results_intergen\indiv_everD_countytrend.tex", keep(operating) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) b(%9.3f) mgroups("First Generation Outcomes" "Child Outcomes at Age 25", pattern(1 0 1 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span
erepeat(\cmidrule(lr){@span}))
replace booktabs fragment stats(dv N, fmt(%9.3f %9.0f) label("Mean, dept. var." "Observations"))
mtitles ("HC Index" "Survival Beyond Age 65" "Yrs.School" "More than comp. edu." "Gym." ) ;
#delimit cr
