*********************************
/*NOTE:
DESIGNED TO BE SUBMITTED TO COMPUTING GRID AS 12 PARALLEL JOBS
HERE, "LSB_JOBINDEX" INDEXES THE 12 JOBS AND FOCAL DATA IN STORED IN THE "DATA_IN" FOLDER
RESULTS FROM REGRESSIONS ARE STORED AS .DTA FILES 
RESULTING .DTA FILES ARE STORED IN "DATA_OUT" FOLDER
"DATA_OUT" FILES ARE USED TO CONSTRUCT FIGURE 4
*/
*********************************



local KEY : env LSB_JOBINDEX

*********************************
*READ RAW RFA ENTRY DATA & VARIABLE RENAME
*********************************
use data_in/entry2.dta, clear
keep if pmraL1_max != 0 & purse_dol != .
foreach var of varlist collab date_exp_y xic reissue otheract {
	rename `var' rfaFE_`var'
}
egen xxrfa = group(xrfa)
drop xrfa
rename xxrfa xrfa


*********************************
*REGRESSION ADJUST PMRA SCORES
*********************************
gen lg_pmra = log(pmraL1_max)
reg app_pmra_max lg_pmra
	predict a_pmra_hat , xb
drop lg_pmra 
egen z_pmra = std(a_pmra_hat)
rename a_pmra_hat pmra


*********************************
*STANDARDIZE PURSE SIZES
*********************************
rename purse dol
preserve
	keep xrfa dol
	gduplicates drop
	egen z_dol = std(dol)
	su dol
	gen dol_sdpermean = r(sd) / r(mean)
	fastxtile P_dol = dol, nq(44)  /*results in 25*/
	keep xrfa z_dol dol_sdpermean P_dol
	tempfile TP
	save `TP', replace
restore
joinby xrfa using `TP'


*********************************
*SAMPLE ON PMRA SCORE AND BIN PMRA
*********************************
su pmra,d
local pmra_p50 = r(p50)
local pmra_p75 = r(p75)
gen pmra_abv50 = pmra >= `pmra_p50'
gen pmra_abv75 = pmra >= `pmra_p75'
keep if pmra_abv50
drop pmra_abv50
fastxtile P_pmra = pmra if pmra >= `pmra_p75', nq(25)
recode P_pmra .=0
su P_pmra
forval i=0/25 {
	su pmra if P_pmra == `i'
	local loc_pmra_binmean_`i' = r(mean)
}
xi , noomit i.P_pmra
drop _IP_pmra_0
foreach var of varlist _IP* {
	rename `var' I_`var'
	gen Int_`var'_z_dol = I_`var' * z_dol
}
compress


*********************************
*REGRESSIONS
*********************************
nois if `KEY' >= 1 & `KEY' <= 3 {
	*pmra
	local MODEL1 reg app I__IP* i.rfaFE* , vce(cluster xrfa) 
	local MODEL2 areg app I__IP* , a(xpi) vce(cluster xrfa) 
	local MODEL3 areg app I__IP* i.rfaFE* , a(xpi) vce(cluster xrfa) 

	nois di "REG START $S_TIME "
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY''
	nois di "REG END $S_TIME "

	regsave , ci t p
	
	gen meanapp_P0 = `meanapp_P0'
	gen meanapp_all = `meanapp_all'
	gen meanpmra_all = `meanpmra_all'
	
	save data_out/out_`KEY'.dta, replace
}

nois if `KEY' >= 4 & `KEY' <= 6 {
	*pmra zdol
	local MODEL4 reg app I__IP* Int_* i.rfaFE* , vce(cluster xrfa) 
	local MODEL5 areg app I__IP* Int_* , a(xpi) vce(cluster xrfa) 
	local MODEL6 areg app I__IP* Int_* i.rfaFE* , a(xpi) vce(cluster xrfa) 

	nois di "REG START $S_TIME "
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY''
	nois di "REG END $S_TIME "

	regsave , ci t p
	
	gen meanapp_P0 = `meanapp_P0'
	gen meanapp_all = `meanapp_all'
	gen meanpmra_all = `meanpmra_all'
	
	save data_out/out_`KEY'.dta, replace
}

nois if `KEY' >= 7 & `KEY' <= 9 {
	*pmra zdol zcomp
	local MODEL7_1 reg app I__IP* Int_* i.rfaFE* , vce(cluster xrfa) 
	local MODEL8_1 areg app I__IP* Int_* , a(xpi) vce(cluster xrfa) 
	local MODEL9_1 areg app I__IP* Int_* i.rfaFE* , a(xpi) vce(cluster xrfa) 

	nois di "REG 1 START $S_TIME "
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY'_1'
	if `KEY' == 7 {
		predict pr_app, xb
	}
	if `KEY' > 7 {
		predict pr_app, xbd
	}
	nois di "REG 1 END $S_TIME "
		egen sum_pr_app = sum(pr_app), by(xrfa)
		gen sum_pr_app_jk = sum_pr_app - pr_app
		egen z_sum_pr_app_jk = std(sum_pr_app_jk)
		forval i=2/4 {
			gen sum_pr_app_jk_`i' = sum_pr_app_jk^`i'
		}
		drop pr_app sum_pr_app
	
	nois di "REG 2 START $S_TIME "
	local MODEL7_2 reg app I__IP* Int_* i.rfaFE* z_sum_pr_app_jk, vce(cluster xrfa) 
	local MODEL8_2 areg app I__IP* Int_* z_sum_pr_app_jk, a(xpi) vce(cluster xrfa) 
	local MODEL9_2 areg app I__IP* Int_* i.rfaFE* z_sum_pr_app_jk, a(xpi) vce(cluster xrfa) 
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY'_2'
	nois di "REG 2 END $S_TIME "
	
	regsave , ci t p
	
	gen meanapp_P0 = `meanapp_P0'
	gen meanapp_all = `meanapp_all'
	gen meanpmra_all = `meanpmra_all'
	
	save data_out/out_`KEY'.dta, replace	
}

nois if `KEY' >= 10 & `KEY' <= 12 {
	*pmra zdol comp4
	local MODEL10_1 reg app I__IP* Int_* i.rfaFE* , vce(cluster xrfa) 
	local MODEL11_1 areg app I__IP* Int_* , a(xpi) vce(cluster xrfa) 
	local MODEL12_1 areg app I__IP* Int_* i.rfaFE* , a(xpi) vce(cluster xrfa) 

	nois di "REG 1 START $S_TIME "
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY'_1'
	if `KEY' == 10 {
		predict pr_app, xb
	}
	if `KEY' > 10 {
		predict pr_app, xbd
	}
	nois di "REG 1 END $S_TIME "
		egen sum_pr_app = sum(pr_app), by(xrfa)
		gen sum_pr_app_jk = sum_pr_app - pr_app
		egen z_sum_pr_app_jk = std(sum_pr_app_jk)
		forval i=2/4 {
			gen sum_pr_app_jk_`i' = sum_pr_app_jk^`i'
		}
		drop pr_app sum_pr_app
	
	nois di "REG 2 START $S_TIME "
	local MODEL10_2 reg app I__IP* Int_* i.rfaFE* sum_pr_app_jk* , vce(cluster xrfa) 
	local MODEL11_2 areg app I__IP* Int_* sum_pr_app_jk*, a(xpi) vce(cluster xrfa) 
	local MODEL12_2 areg app I__IP* Int_* i.rfaFE* sum_pr_app_jk*, a(xpi) vce(cluster xrfa) 
	nois di "`MODEL`KEY''"
	nois `MODEL`KEY'_2'
	nois di "REG 2 END $S_TIME "
	
	regsave , ci t p
	
	gen meanapp_P0 = `meanapp_P0'
	gen meanapp_all = `meanapp_all'
	gen meanpmra_all = `meanpmra_all'
	
	save data_out/out_`KEY'.dta, replace	
}



*********************************
/*NOTE:
REMAINDER OF DO FILE SHOULD BE RUN AFTER ALL `KEY' JOBS HAVE COMPLETED
*/
*********************************


*********************************
*APPEND ALL RESULTS & PREPARE FOR GRAPHING
*********************************
use data_out/out_1.dta, clear
gen spec = 1
forval i=2/12 {
	append using data_out/out_`i'.dta
	recode spec . = `i'
}
drop if regexm(var , "(rfaFE|cons)")
gen vvar = "pmra" if !regexm(var, "(dol|pr_app)")
replace vvar = "dol" if regexm(var, "(dol)")
replace vvar = var if vvar == ""
drop var
gen n = _n
sort spec vvar n
by spec vvar: gen P = _n

gen meanpmra_P0 = `loc_pmra_binmean_0' if vvar == "pmra"
gen meanpmra_P = .
forval i=1/25 {
	replace meanpmra_P = `loc_pmra_binmean_`i'' if vvar == "pmra" & P == `i'
}
gen meandol = `dol_mean' if vvar == "dol"
gen sddol = `dol_1sd' if vvar == "dol"

foreach var of varlist coef ci_l ci_u {
	gen `var'_dp_dlnx = `var' / (sddol/meandol) if vvar == "dol" 
	replace `var'_dp_dlnx = `var' / ((meanpmra_P - meanpmra_P0)/meanpmra_P0) if vvar == "pmra" 
}
foreach var of varlist coef ci_lower ci_upper {
	gen `var'_dlnp_dlnx = (`var'/ meanapp_all) / (sddol/meandol) if vvar == "dol" 
	replace `var'_dlnp_dlnx = (`var'/ meanapp_all ) / ((meanpmra_P - meanpmra_P0)/meanpmra_P0) if vvar == "pmra" 
}


*********************************
*GRAPHS
*********************************
//FIGURE 4A
tw 	(scatter coef P if vvar == "pmra" & spec == 4 & ci_lower > 0, mcolor(navy%50) m(O) msize(large)) ///
	(scatter coef P if vvar == "pmra" & spec == 4 & ci_lower < 0, mcolor(navy) m(Oh) msize(large)) ///
	(scatter coef P if vvar == "pmra" & spec == 6 & ci_lower > 0, mcolor(maroon%50) m(S) msize(large)) ///
	(scatter coef P if vvar == "pmra" & spec == 6 & ci_lower < 0, mcolor(maroon) m(Sh) msize(large)) ///	
	(scatter coef P if vvar == "pmra" & spec == 9 & ci_lower > 0, mcolor(forest_green%50) m(T) msize(large)) ///
	(scatter coef P if vvar == "pmra" & spec == 9 & ci_lower < 0, mcolor(forest_green) m(Th) msize(large)) ///	
	, yscale(log) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ylabel(0.0001 "0.0001" 0.001 "0.001" 0.01 "0.01" , angle(horiz)) ///
	xlabel(5 "80" 10 "85" 15 "90" 20 "95" 25 "100") ///
	ytitle("Coefficient (Rel. to 50-75{superscript:th})") xtitle("Similarity Percentile") ///
	legend(off) scale(1.4)

//FIGURE 4B
tw 	(scatter coef P if vvar == "dol" & spec == 4 & ci_lower > 0, mcolor(navy%50) m(O) msize(large)) ///
	(scatter coef P if vvar == "dol" & spec == 4 & ci_lower < 0, mcolor(navy) m(Oh) msize(large)) ///
	(scatter coef P if vvar == "dol" & spec == 6 & ci_lower > 0, mcolor(maroon%50) m(S) msize(large)) ///
	(scatter coef P if vvar == "dol" & spec == 6 & ci_lower < 0, mcolor(maroon) m(Sh) msize(large)) ///	
	(scatter coef P if vvar == "dol" & spec == 9 & ci_lower > 0, mcolor(forest_green%50) m(T) msize(large)) ///
	(scatter coef P if vvar == "dol" & spec == 9 & ci_lower < 0, mcolor(forest_green) m(Th) msize(large)) ///	
	, yscale(log) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ylabel(0.0001 "0.0001" 0.001 "0.001" 0.01 "0.01" , angle(horiz)) ///
	xlabel(5 "80" 10 "85" 15 "90" 20 "95" 25 "100") ///
	ytitle("Coefficient (+1 s.d. Purse {c $|})") xtitle("Similarity Percentile") ///
	legend(off) scale(1.4)

//FIGURE 5A
tw 	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 4 & ci_lower > 0, mcolor(navy%50) m(O) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 4 & ci_lower < 0, mcolor(navy) m(Oh) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 6 & ci_lower > 0, mcolor(maroon%50) m(S) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 6 & ci_lower < 0, mcolor(maroon) m(Sh) msize(large)) ///	
	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 9 & ci_lower > 0, mcolor(forest_green%50) m(T) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "pmra" & spec == 9 & ci_lower < 0, mcolor(forest_green) m(Th) msize(large)) ///	
	, yscale(range(0.2 40) log) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ylabel(0.5 2.5 10 40, angle(horiz)) ///
	xlabel(5 "80" 10 "85" 15 "90" 20 "95" 25 "100") ///
	ytitle("Entry Elasticity") xtitle("Similarity Percentile") ///
	legend(off) scale(1.4)

//FIGURE 5B
tw 	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 4 & ci_lower > 0, mcolor(navy%50) m(O) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 4 & ci_lower < 0, mcolor(navy) m(Oh) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 6 & ci_lower > 0, mcolor(maroon%50) m(S) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 6 & ci_lower < 0, mcolor(maroon) m(Sh) msize(large)) ///	
	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 9 & ci_lower > 0, mcolor(forest_green%50) m(T) msize(large)) ///
	(scatter coef_dlnp_dlnx P if vvar == "dol" & spec == 9 & ci_lower < 0, mcolor(forest_green) m(Th) msize(large)) ///	
	, yscale(range(0.2 40) log) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ylabel(0.5 2.5 10 40, angle(horiz)) ///
	xlabel(5 "80" 10 "85" 15 "90" 20 "95" 25 "100") ///
	ytitle("Entry Elasticity") xtitle("Similarity Percentile") ///
	legend(off) scale(1.4)

//FIGURE 5C,5D
su meandol
local MEAN_DOL = r(mean)
preserve
	gen rel_effect = coef_dlnp_dlnx if vvar == "pmra" | vvar == "dol"
	keep spec P rel_effect vvar
	reshape wide rel_effect, i(spec P) j(vvar) string	
	
	gen eos = rel_effectdol / rel_effectpmra
	
	//FIGURE 5C
	tw (scatter eos P if spec == 9, mcolor(forest_green) m(T) msize(large) ) , ///
		graphregion(color(white) lcolor(white)) bgcolor(white) ///
		ytitle("Ratio of Entry Elasticities") xtitle("Similarity Percentile") ///
		xlabel(5 "80" 10 "85" 15 "90" 20 "95" 25 "100") ///
		ylabel(, angle(horiz)) scale(1.4) 
	
	su eos
	local MEAN_EOS = r(mean)
	local MAX_EOS = r(max)
	local MIN_EOS = r(min)
	
	clear
	set obs 500
	gen perc_sim_change = _n/10
	gen dolneeded_meaneos = ((perc_sim_change / `MEAN_EOS') / 100) * `MEAN_DOL'
	gen dolneeded_mineos = ((perc_sim_change / `MIN_EOS') / 100) * `MEAN_DOL'
	gen dolneeded_maxeos = ((perc_sim_change / `MAX_EOS') / 100) * `MEAN_DOL'
	
	keep if perc_sim_change > 1

	foreach var of varlist dolneeded_* {
		replace `var' = (`var' * 4) * 0.14
	}
	
	//FIGURE 5D
	tw 	(line dolneeded_meaneos perc_sim_change, lw(thick) lcolor(forest_green) ) ///
		(rarea dolneeded_maxeos dolneeded_mineos perc_sim_change, fcolor(forest_green%33) lcolor(forest_green%33) ) , yscale(log) ///
		graphregion(color(white) lcolor(white)) bgcolor(white) ///
		ylabel(250000 "250K" 1000000 "1M" 4000000 "4M" 16000000 "16M", angle(horiz)) ///
		ytitle("Expected {c $|} Necessary") xtitle("% Change in Similarity to Induce") ///
		scale(1.4) legend(off)
restore


