set more off

* PROGRAM: porder_selection.do
* 
* NOTES: Created after RR. Use Pei, et al. programs to estimate the AMSE
*
log using "/home/projects/sehs/replication/logs/porder_selection.log", replace

*tier-by-school-by-cohort fe


*********************************************************
*********************************************************
*********************************************************
tempfile temp1 temp2

use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear

#delimit ;
global grade8 "black8 hisp8 male8 frpl8 assignedsch8";
global grade8i "black8_1 black8_2 black8_3 black8_4 hisp8_1 hisp8_2 hisp8_3 hisp8_4 male8_1 male8_2 male8_3 male8_4
        frpl8_1 frpl8_2 frpl8_3 frpl8_4 assignedsch8_1 assignedsch8_2 assignedsch8_3 assignedsch8_4";


global outcomesall "stdcomp stdactcomp latent8pct gpa_unwt2 gpa_unwt2_gr11 grad4yr firstfall verycompetitiveplus 
                    anyhonors hrsstdy10 stdoscie stdossaf stdopeer stdotrts stdopssm distance";

file open myfile using "/home/projects/sehs/replication/tables/porder_select.txt", write replace;
file write myfile "variable" _tab "polynomial order" _tab "Conventional AMSE" _tab "Bias-corrected AMSE" _n;
* Table 4 & 5;
*overall;
foreach v of global outcomesall {;
  qui rdbwselect `v' centered, p(1) q(2) kernel(uniform); 
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(1) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(2) q(3) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(2) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(3) q(4) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(3) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(4) q(5) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(4) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;

};

file close myfile;

file open myfile using "/home/projects/sehs/replication/tables/porder_select_tier1.txt", write replace;
file write myfile "variable" _tab "polynomial order" _tab "Conventional AMSE" _tab "Bias-corrected AMSE" _n;
* Table 4 & 5;
*Tier 1;
preserve;
keep if tier1 == 1;
foreach v of global outcomesall {;
  qui rdbwselect `v' centered, p(1) q(2) kernel(uniform); 
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(1) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(2) q(3) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(2) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(3) q(4) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(3) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(4) q(5) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(4) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;

};

file close myfile;
restore;

file open myfile using "/home/projects/sehs/replication/tables/porder_select_tier4.txt", write replace;
file write myfile "variable" _tab "polynomial order" _tab "Conventional AMSE" _tab "Bias-corrected AMSE" _n;
* Table 4 & 5;
*Tier 4;
preserve;
keep if tier4 == 1;
foreach v of global outcomesall {;
  qui rdbwselect `v' centered, p(1) q(2) kernel(uniform); 
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(1) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(2) q(3) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(2) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(3) q(4) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(3) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;
  qui rdbwselect `v' centered, p(4) q(5) kernel(uniform) ;
  local bw_h = e(h_mserd);
  local bw_b = e(b_mserd);
  rdmse `v' centered, deriv(0) p(4) h(`bw_h') b(`bw_b') kernel(uniform);
  file write myfile %15s "`v'" _tab %7.3f (e(p)) _tab %7.3f (e(amse_cl)) _tab %7.3f (e(amse_bc)) _n;

};

file close myfile;
restore;

