set more off

* PROGRAM: rdplot_pretreat_all.do
* 
* NOTES: Created after RR. Start with the full sample and use rdplot to plot RD figures.
*
log using "/home/projects/sehs/replication/logs/rdplot_pretreat_all.log", replace

*********************************************************
*********************************************************
*********************************************************
tempfile temp1 temp2

* ------  GENERATE THE RIGHT BANDWIDTH USING RDROBUST;

* GETTING BANDWITH FOR EACH EXPERIMENT -- UNIFORM KERNEL;

capture program drop rdplots14;
#delimit;

program def rdplots14;
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear;
label var black8 "Student is African American/Black";
label var hisp8 "Student is Latino";
label var male8 "Student is Male";
label var frpl8 "Student is Eligible for Free/Reduced Price Lunch";
label var assignedsch8 "Student Attended Their Neighborhood Elementary School";
postfile dataNon tierschcoh N_l N_r h_bw coeff se_coeff tiernum using 
"/home/projects/sehs/replication/data/NonParResults.dta", replace;
forvalues i = 1/148 {;
capture rdrobust $var centered if tierschcoh==`i', kernel(uniform) p(1); 
capture local tierschcoh = `i';
capture local N_l = e(N_h_l);
capture local N_r = e(N_h_r);
capture local h_bw = e(h_l);
capture local coeff = e(tau_cl);
capture local se_coeff = e(se_tau_cl);
capture sum tier if tierschcoh == `i';
capture local tiernum = r(mean);
capture post dataNon (`tierschcoh') (`N_l') (`N_r') (`h_bw') (`coeff') 
     (`se_coeff') (`tiernum');
ereturn clear;
};
postclose dataNon;

merge m:1 tierschcoh using "/home/projects/sehs/replication/data/NonParResults.dta";
drop if N_l == .;
quietly tab tierschcoh, gen(tsc);
preserve;

quietly rdrobust $var centered if tier == 1, covs($tsc1) p(1) kernel(uniform);
scalar ehl = e(h_l);
quietly reg $var $tsc1 if tier1==1 & -ehl<=centered & centered<=ehl;
predict yadj if tier1==1, resid; 
quietly sum $var if -ehl<=centered & centered<=ehl & tier1==1;
scalar mean = r(mean);
replace yadj = yadj + mean;
rdplot yadj centered if tier1==1 & -ehl <= centered & centered <= ehl, 
  binselect(esmv) kernel(uniform) p(1) graph_options(legend(off) ylabel($yl) 
  title(`:variable label $var') subtitle("Tier 1") xtitle("Centered Application Score") scheme(sj));
graph save "/home/projects/sehs/replication/figures/${var}_pretreat_tier1.gph", replace;
restore;
quietly rdrobust $var centered if tier == 4, covs($tsc4) p(1) kernel(uniform);
scalar ehl = e(h_l);
quietly reg $var $tsc4 if tier4==1 & -ehl<=centered & centered<=ehl;
predict yadj if tier4==1, resid; 
quietly sum $var if -ehl<=centered & centered<=ehl & tier4==1;
scalar mean = r(mean);
replace yadj = yadj + mean;
rdplot yadj centered if tier4==1 & -ehl <= centered & centered <= ehl, 
  binselect(esmv) kernel(uniform) p(1) graph_options(legend(off) ylabel($yl) 
  title(`:variable label $var') subtitle("Tier 4") xtitle("Centered Application Score") scheme(sj));
graph save "/home/projects/sehs/replication/figures/${var}_pretreat_tier4.gph", replace;

!rm "/home/projects/sehs/replication/data/NonParResults.dta";
end;


* Variable black8;
global var "black8";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc95";
global yl "0(.2)1";
rdplots14;

* Variable hisp8;
global var "hisp8";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc93";
global yl "0(.2)1";
rdplots14;

* Variable male8;
global var "male8";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc94";
global yl "0(.2)1";
rdplots14;

* Variable frpl8;
global var "frpl8";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc95";
global yl "0(.2)1";
rdplots14;

* Variable assignedsch8;
global var "assignedsch8";
global tsc1 "tsc1-tsc20";
global tsc4 "tsc68-tsc94";
global yl "0(.2)1";
rdplots14;
