# first install any of the below packages that you do not have already, then run the below code
library(ggplot2)
library(rgdal)
library(rgeos)
library(maptools)
library(mapproj)
library(ggmap)
library(RColorBrewer) # creates nice color schemes
library(plyr) #the internet encourages us to use its join function

ntier <- 6 # number of color categories
nclr<-ntier
plotclr <- brewer.pal(nclr,"Greys") #standard color palette 
plotclr<-c("red","orange","yellow","green")
nschs<-11
dotclr <- brewer.pal(nschs,"PuOr") #standard color palette 

setwd("C:/Users/username/Documents/Map/Figure 1") # set this to where you have saved your data!!!
wd <- getwd()
centracts <- readOGR(dsn=wd ,"CensusTractsTIGER2010") #pull in the community area shape file downloaded from the city website




##plot(centracts) #creates centract projection

tiers <- read.csv("tiers1213_1516.csv", header=T)
tiers2<-as.data.frame(cbind(tiers$tractce10,tiers$Tier1516))
names(tiers2)<-c("GEOID10","tier1314")
centracts<-merge(centracts,tiers2,by.x="GEOID10", by.y="GEOID10")

#Create PDF of the graph (silently). If you want to see the graph in RStudio, comment out this line and "dev.off()" 
pdf("appendix_figure1.pdf", width=8.5, height=11) #creates centract projection and colors by tier

plot(centracts)
plot(centracts[which(centracts$tier1314==1),], col=plotclr[1],add=TRUE)
plot(centracts[which(centracts$tier1314==2),], col=plotclr[2],add=TRUE)
plot(centracts[which(centracts$tier1314==3),], col=plotclr[3],add=TRUE)
plot(centracts[which(centracts$tier1314==4),], col=plotclr[4],add=TRUE)

#reads in coordinates of schools
sehs <- read.csv("sehsxy.csv", header=T)
sehs<-sehs[sehs$schid!=609694,] #omits Hancock 


coordinates(sehs)=~xcoord+ycoord
proj4string(sehs)=CRS("+proj=longlat")
schlPoints1  <- spTransform(sehs,CRSobj=CRS(proj4string(centracts))) #transform the school lat long so that they are on the same CRS as the community areas
#points(schlPoints1, col="black",bg="white",pch = 21, cex=2.5) #plots points for schools from schlxyNOiei
points(schlPoints1, pch = 19, cex=2.5)

legend(legend = paste0("tier ", 1:4), fill = plotclr[1:4], "topright", cex=0.8)
#legend(legend = sehs$name, fill = dotclr, "bottomleft", cex=0.5)


dev.off() #comment out with pdf() if you just want to display it in RStudio
